/*
 * Decompiled with CFR 0.152.
 */
package dev.simplix.cirrus.schematic;

import com.google.common.base.Preconditions;
import dev.simplix.cirrus.actionhandler.ActionHandler;
import dev.simplix.cirrus.item.CirrusItem;
import dev.simplix.cirrus.menu.MenuElement;
import dev.simplix.cirrus.menu.MenuRow;
import dev.simplix.cirrus.model.BusinessItemMap;
import dev.simplix.cirrus.model.MenuContent;
import dev.simplix.cirrus.model.PlaceholderItem;
import dev.simplix.cirrus.model.SimpleSound;
import dev.simplix.protocolize.api.item.BaseItemStack;
import dev.simplix.protocolize.data.inventory.InventoryType;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

public interface MenuSchematic {
    default public CirrusItem forceBusinessItem(String keyword) {
        return (CirrusItem)((Object)Preconditions.checkNotNull((Object)((Object)this.businessItems().get(keyword)), (Object)("No business-item named '" + keyword + "' found")));
    }

    public MenuSchematic copy();

    @Nullable
    public String title();

    public MenuSchematic title(String var1);

    public Locale locale();

    public InventoryType type();

    default public int typicalSize() {
        return this.typicalSize(769);
    }

    public int typicalSize(int var1);

    public Optional<PlaceholderItem> placeholderItem();

    public Set<Integer> reservedSlots();

    public MenuContent rootItems();

    public int centerSlot();

    default public MenuElement center() {
        return this.element(this.centerSlot());
    }

    @Nullable
    public MenuRow row(int var1);

    default public MenuRow firstRow() {
        return this.row(0);
    }

    default public MenuRow bottomRow() {
        return this.row(this.typicalSize() / 9);
    }

    default public MenuRow middleRow() {
        if (this.typicalSize() == 9) {
            return this.row(1);
        }
        return this.row(this.typicalSize() / 18);
    }

    public BusinessItemMap businessItems();

    public MenuSchematic type(InventoryType var1);

    public MenuSchematic placeholderItem(PlaceholderItem var1);

    public MenuSchematic reservedSlots(Set<Integer> var1);

    public MenuSchematic businessItems(BusinessItemMap var1);

    public MenuSchematic remove(int var1);

    public Optional<String> actionHandlerString(int var1);

    public Optional<ActionHandler> actionHandler(int var1);

    public MenuSchematic set(BaseItemStack var1, int var2, @Nullable String var3);

    default public MenuSchematic set(CirrusItem item) {
        return this.set((BaseItemStack)item, item.slot(), item.actionHandler());
    }

    public MenuElement element(int var1);

    @Nullable
    public BaseItemStack get(int var1);

    public int add(BaseItemStack var1, @Nullable String var2);

    default public int add(CirrusItem item) {
        return this.add((BaseItemStack)item, item.actionHandler());
    }

    @Nullable
    public SimpleSound soundOnOpen();
}

