/*
 * Decompiled with CFR 0.152.
 */
package dev.simplix.cirrus.schematic.impl;

import dev.simplix.cirrus.Cirrus;
import dev.simplix.cirrus.actionhandler.ActionHandler;
import dev.simplix.cirrus.actionhandler.RegisteredActionHandler;
import dev.simplix.cirrus.item.CirrusItem;
import dev.simplix.cirrus.menu.MenuElement;
import dev.simplix.cirrus.menu.MenuRow;
import dev.simplix.cirrus.model.BusinessItemMap;
import dev.simplix.cirrus.model.MenuContent;
import dev.simplix.cirrus.model.PlaceholderItem;
import dev.simplix.cirrus.model.SimpleSound;
import dev.simplix.cirrus.schematic.MenuSchematic;
import dev.simplix.cirrus.service.CapacityService;
import dev.simplix.protocolize.api.SoundCategory;
import dev.simplix.protocolize.api.item.BaseItemStack;
import dev.simplix.protocolize.data.Sound;
import dev.simplix.protocolize.data.inventory.InventoryType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

public class SimpleMenuSchematic
implements MenuSchematic {
    protected final List<RegisteredActionHandler> actionHandlers = new ArrayList<RegisteredActionHandler>();
    private final Map<Integer, String> actionHandlerStringMap = new HashMap<Integer, String>(0);
    private String title;
    private InventoryType type;
    private PlaceholderItem placeholderItem;
    private Set<Integer> reservedSlots;
    private BusinessItemMap businessItems;
    private MenuContent rootItems;
    private SimpleSound soundOnOpen;

    @Override
    public MenuSchematic copy() {
        return SimpleMenuSchematic.builder().title(this.title).placeholderItem(this.placeholderItem.copy()).reservedSlots(new HashSet<Integer>(this.reservedSlots)).businessItems(this.businessItems.copy()).type(this.type).rootItems(this.rootItems.copy()).build();
    }

    @Override
    public Locale locale() {
        return Objects.requireNonNull(Cirrus.defaultLocale(), "defaultLocale must not be null");
    }

    @Override
    @Nullable
    public String title() {
        return this.title;
    }

    @Override
    public InventoryType type() {
        return Objects.requireNonNull(this.type, "Type must not be null");
    }

    @Override
    public int typicalSize(int protocolVersion) {
        return this.type().getTypicalSize(protocolVersion);
    }

    @Override
    public Optional<PlaceholderItem> placeholderItem() {
        return Optional.ofNullable(this.placeholderItem);
    }

    @Override
    public int centerSlot() {
        int pos = this.typicalSize() / 2;
        return this.typicalSize() % 2 == 1 ? pos : pos - 5;
    }

    @Override
    public MenuRow row(int row) {
        LinkedList<MenuElement> items = new LinkedList<MenuElement>();
        for (int i = 9 * (row - 1); i < 9 * row; ++i) {
            items.add(this.element(i));
        }
        return new MenuRow(items);
    }

    @Override
    public SimpleMenuSchematic set(CirrusItem item) {
        return (SimpleMenuSchematic)MenuSchematic.super.set(item);
    }

    @Override
    public MenuSchematic set(BaseItemStack item, int slot, @Nullable String actionHandler) {
        this.rootItems().put(slot, item);
        if (actionHandler != null) {
            this.actionHandlerStringMap.put(slot, actionHandler);
        }
        return this;
    }

    @Override
    public MenuElement element(int slot) {
        return new MenuElement(this, this.get(slot), slot, this.actionHandlerString(slot).orElse(null));
    }

    @Override
    @Nullable
    public BaseItemStack get(int slot) {
        return this.rootItems.get(slot);
    }

    @Override
    public int add(BaseItemStack item, @Nullable String actionHandler) {
        int capacity = Cirrus.service(CapacityService.class).capacity(this.type());
        for (int i = -1; i < capacity; ++i) {
            if (this.rootItems().containsKey(i) || this.reservedSlots().contains(i)) continue;
            this.rootItems().put(i, item);
            return i;
        }
        return -1;
    }

    @Override
    public Optional<ActionHandler> actionHandler(int slot) {
        return this.actionHandlerString(slot).flatMap(this::findActionHandler);
    }

    private Optional<ActionHandler> findActionHandler(String actionHandlerString) {
        for (RegisteredActionHandler registeredActionHandler : this.actionHandlers) {
            if (!registeredActionHandler.name().equals(actionHandlerString)) continue;
            return Optional.of(registeredActionHandler.handler());
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> actionHandlerString(int slot) {
        return Optional.ofNullable(this.actionHandlerStringMap.get(slot));
    }

    @Override
    public SimpleMenuSchematic remove(int slot) {
        this.rootItems.remove(slot);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SimpleMenuSchematic)) {
            return false;
        }
        SimpleMenuSchematic other = (SimpleMenuSchematic)obj;
        return (other.title == null && this.title() == null || other.title().equals(this.title())) && other.type() == this.type() && other.placeholderItem().equals(this.placeholderItem()) && other.reservedSlots().equals(this.reservedSlots()) && other.businessItems().equals(this.businessItems()) && other.rootItems().equals(this.rootItems());
    }

    private static String $default$title() {
        return "Menu";
    }

    private static InventoryType $default$type() {
        return InventoryType.GENERIC_9X3;
    }

    private static PlaceholderItem $default$placeholderItem() {
        return null;
    }

    private static Set<Integer> $default$reservedSlots() {
        return new HashSet<Integer>(0);
    }

    private static BusinessItemMap $default$businessItems() {
        return new BusinessItemMap();
    }

    private static MenuContent $default$rootItems() {
        return new MenuContent();
    }

    private static SimpleSound $default$soundOnOpen() {
        return new SimpleSound(Sound.BLOCK_NOTE_BLOCK_HAT, SoundCategory.AMBIENT, 0.4f, 1.5f);
    }

    public static SimpleMenuSchematicBuilder builder() {
        return new SimpleMenuSchematicBuilder();
    }

    public List<RegisteredActionHandler> actionHandlers() {
        return this.actionHandlers;
    }

    public Map<Integer, String> actionHandlerStringMap() {
        return this.actionHandlerStringMap;
    }

    @Override
    public Set<Integer> reservedSlots() {
        return this.reservedSlots;
    }

    @Override
    public BusinessItemMap businessItems() {
        return this.businessItems;
    }

    @Override
    public MenuContent rootItems() {
        return this.rootItems;
    }

    @Override
    public SimpleSound soundOnOpen() {
        return this.soundOnOpen;
    }

    @Override
    public SimpleMenuSchematic title(String title) {
        this.title = title;
        return this;
    }

    @Override
    public SimpleMenuSchematic type(InventoryType type) {
        this.type = type;
        return this;
    }

    @Override
    public SimpleMenuSchematic placeholderItem(PlaceholderItem placeholderItem) {
        this.placeholderItem = placeholderItem;
        return this;
    }

    @Override
    public SimpleMenuSchematic reservedSlots(Set<Integer> reservedSlots) {
        this.reservedSlots = reservedSlots;
        return this;
    }

    @Override
    public SimpleMenuSchematic businessItems(BusinessItemMap businessItems) {
        this.businessItems = businessItems;
        return this;
    }

    public SimpleMenuSchematic rootItems(MenuContent rootItems) {
        this.rootItems = rootItems;
        return this;
    }

    public SimpleMenuSchematic soundOnOpen(SimpleSound soundOnOpen) {
        this.soundOnOpen = soundOnOpen;
        return this;
    }

    public SimpleMenuSchematic() {
        this.title = SimpleMenuSchematic.$default$title();
        this.type = SimpleMenuSchematic.$default$type();
        this.placeholderItem = SimpleMenuSchematic.$default$placeholderItem();
        this.reservedSlots = SimpleMenuSchematic.$default$reservedSlots();
        this.businessItems = SimpleMenuSchematic.$default$businessItems();
        this.rootItems = SimpleMenuSchematic.$default$rootItems();
        this.soundOnOpen = SimpleMenuSchematic.$default$soundOnOpen();
    }

    public String toString() {
        return "SimpleMenuSchematic(actionHandlers=" + this.actionHandlers() + ", actionHandlerStringMap=" + this.actionHandlerStringMap() + ", title=" + this.title() + ", type=" + this.type() + ", placeholderItem=" + this.placeholderItem() + ", reservedSlots=" + this.reservedSlots() + ", businessItems=" + this.businessItems() + ", rootItems=" + this.rootItems() + ", soundOnOpen=" + this.soundOnOpen() + ")";
    }

    public SimpleMenuSchematic(String title, InventoryType type, PlaceholderItem placeholderItem, Set<Integer> reservedSlots, BusinessItemMap businessItems, MenuContent rootItems, SimpleSound soundOnOpen) {
        this.title = title;
        this.type = type;
        this.placeholderItem = placeholderItem;
        this.reservedSlots = reservedSlots;
        this.businessItems = businessItems;
        this.rootItems = rootItems;
        this.soundOnOpen = soundOnOpen;
    }

    public static class SimpleMenuSchematicBuilder {
        private boolean title$set;
        private String title$value;
        private boolean type$set;
        private InventoryType type$value;
        private boolean placeholderItem$set;
        private PlaceholderItem placeholderItem$value;
        private boolean reservedSlots$set;
        private Set<Integer> reservedSlots$value;
        private boolean businessItems$set;
        private BusinessItemMap businessItems$value;
        private boolean rootItems$set;
        private MenuContent rootItems$value;
        private boolean soundOnOpen$set;
        private SimpleSound soundOnOpen$value;

        SimpleMenuSchematicBuilder() {
        }

        public SimpleMenuSchematicBuilder title(String title) {
            this.title$value = title;
            this.title$set = true;
            return this;
        }

        public SimpleMenuSchematicBuilder type(InventoryType type) {
            this.type$value = type;
            this.type$set = true;
            return this;
        }

        public SimpleMenuSchematicBuilder placeholderItem(PlaceholderItem placeholderItem) {
            this.placeholderItem$value = placeholderItem;
            this.placeholderItem$set = true;
            return this;
        }

        public SimpleMenuSchematicBuilder reservedSlots(Set<Integer> reservedSlots) {
            this.reservedSlots$value = reservedSlots;
            this.reservedSlots$set = true;
            return this;
        }

        public SimpleMenuSchematicBuilder businessItems(BusinessItemMap businessItems) {
            this.businessItems$value = businessItems;
            this.businessItems$set = true;
            return this;
        }

        public SimpleMenuSchematicBuilder rootItems(MenuContent rootItems) {
            this.rootItems$value = rootItems;
            this.rootItems$set = true;
            return this;
        }

        public SimpleMenuSchematicBuilder soundOnOpen(SimpleSound soundOnOpen) {
            this.soundOnOpen$value = soundOnOpen;
            this.soundOnOpen$set = true;
            return this;
        }

        public SimpleMenuSchematic build() {
            String title$value = this.title$value;
            if (!this.title$set) {
                title$value = SimpleMenuSchematic.$default$title();
            }
            InventoryType type$value = this.type$value;
            if (!this.type$set) {
                type$value = SimpleMenuSchematic.$default$type();
            }
            PlaceholderItem placeholderItem$value = this.placeholderItem$value;
            if (!this.placeholderItem$set) {
                placeholderItem$value = SimpleMenuSchematic.$default$placeholderItem();
            }
            Set<Integer> reservedSlots$value = this.reservedSlots$value;
            if (!this.reservedSlots$set) {
                reservedSlots$value = SimpleMenuSchematic.$default$reservedSlots();
            }
            BusinessItemMap businessItems$value = this.businessItems$value;
            if (!this.businessItems$set) {
                businessItems$value = SimpleMenuSchematic.$default$businessItems();
            }
            MenuContent rootItems$value = this.rootItems$value;
            if (!this.rootItems$set) {
                rootItems$value = SimpleMenuSchematic.$default$rootItems();
            }
            SimpleSound soundOnOpen$value = this.soundOnOpen$value;
            if (!this.soundOnOpen$set) {
                soundOnOpen$value = SimpleMenuSchematic.$default$soundOnOpen();
            }
            return new SimpleMenuSchematic(title$value, type$value, placeholderItem$value, reservedSlots$value, businessItems$value, rootItems$value, soundOnOpen$value);
        }

        public String toString() {
            return "SimpleMenuSchematic.SimpleMenuSchematicBuilder(title$value=" + this.title$value + ", type$value=" + this.type$value + ", placeholderItem$value=" + this.placeholderItem$value + ", reservedSlots$value=" + this.reservedSlots$value + ", businessItems$value=" + this.businessItems$value + ", rootItems$value=" + this.rootItems$value + ", soundOnOpen$value=" + this.soundOnOpen$value + ")";
        }
    }
}

