/*
 * Decompiled with CFR 0.152.
 */
package dev.simplix.cirrus.service.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import dev.simplix.cirrus.menus.AbstractSearchableBrowser;
import dev.simplix.cirrus.model.SearchConversation;
import dev.simplix.cirrus.player.CirrusPlayerWrapper;
import dev.simplix.cirrus.service.SearchConversationHandleService;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public abstract class AbstractSearchConversationHandlerService
implements SearchConversationHandleService {
    protected static final Cache<UUID, Search> cache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(10L, TimeUnit.MINUTES).removalListener(notification -> {
        Search value = (Search)notification.getValue();
        if (value != null) {
            value.cirrusPlayerWrapper.sendMessage(value.searchConversation.timeoutMessage());
        }
    }).build();

    protected boolean handleInput(CirrusPlayerWrapper playerWrapper, String playerMessage, AbstractSearchableBrowser browser) {
        Search search = (Search)cache.getIfPresent((Object)playerWrapper.uuid());
        if (search == null) {
            return false;
        }
        browser.redisplay(browser.searchByPartialString(playerMessage));
        return true;
    }

    @Override
    public <T> void handle(CirrusPlayerWrapper playerWrapper, AbstractSearchableBrowser<T> browser, SearchConversation conversation) {
        String prompt = conversation.prompt();
        playerWrapper.sendMessage(prompt);
    }

    protected static class Search {
        private final CirrusPlayerWrapper cirrusPlayerWrapper;
        AbstractSearchableBrowser abstractSearchableBrowser;
        SearchConversation searchConversation;

        public Search(CirrusPlayerWrapper cirrusPlayerWrapper) {
            this.cirrusPlayerWrapper = cirrusPlayerWrapper;
        }

        public CirrusPlayerWrapper cirrusPlayerWrapper() {
            return this.cirrusPlayerWrapper;
        }

        public AbstractSearchableBrowser abstractSearchableBrowser() {
            return this.abstractSearchableBrowser;
        }

        public SearchConversation searchConversation() {
            return this.searchConversation;
        }

        public Search abstractSearchableBrowser(AbstractSearchableBrowser abstractSearchableBrowser) {
            this.abstractSearchableBrowser = abstractSearchableBrowser;
            return this;
        }

        public Search searchConversation(SearchConversation searchConversation) {
            this.searchConversation = searchConversation;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Search)) {
                return false;
            }
            Search other = (Search)o;
            if (!other.canEqual(this)) {
                return false;
            }
            CirrusPlayerWrapper this$cirrusPlayerWrapper = this.cirrusPlayerWrapper();
            CirrusPlayerWrapper other$cirrusPlayerWrapper = other.cirrusPlayerWrapper();
            if (this$cirrusPlayerWrapper == null ? other$cirrusPlayerWrapper != null : !this$cirrusPlayerWrapper.equals(other$cirrusPlayerWrapper)) {
                return false;
            }
            AbstractSearchableBrowser this$abstractSearchableBrowser = this.abstractSearchableBrowser();
            AbstractSearchableBrowser other$abstractSearchableBrowser = other.abstractSearchableBrowser();
            if (this$abstractSearchableBrowser == null ? other$abstractSearchableBrowser != null : !this$abstractSearchableBrowser.equals(other$abstractSearchableBrowser)) {
                return false;
            }
            SearchConversation this$searchConversation = this.searchConversation();
            SearchConversation other$searchConversation = other.searchConversation();
            return !(this$searchConversation == null ? other$searchConversation != null : !((Object)this$searchConversation).equals(other$searchConversation));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Search;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CirrusPlayerWrapper $cirrusPlayerWrapper = this.cirrusPlayerWrapper();
            result = result * 59 + ($cirrusPlayerWrapper == null ? 43 : $cirrusPlayerWrapper.hashCode());
            AbstractSearchableBrowser $abstractSearchableBrowser = this.abstractSearchableBrowser();
            result = result * 59 + ($abstractSearchableBrowser == null ? 43 : $abstractSearchableBrowser.hashCode());
            SearchConversation $searchConversation = this.searchConversation();
            result = result * 59 + ($searchConversation == null ? 43 : ((Object)$searchConversation).hashCode());
            return result;
        }

        public String toString() {
            return "AbstractSearchConversationHandlerService.Search(cirrusPlayerWrapper=" + this.cirrusPlayerWrapper() + ", abstractSearchableBrowser=" + this.abstractSearchableBrowser() + ", searchConversation=" + this.searchConversation() + ")";
        }
    }
}

