/*
 * Decompiled with CFR 0.152.
 */
package dev.simplix.cirrus.spigot;

import dev.simplix.cirrus.Cirrus;
import dev.simplix.cirrus.menu.MenuUpdateTask;
import dev.simplix.cirrus.service.ItemService;
import dev.simplix.cirrus.service.MenuBuildService;
import dev.simplix.cirrus.service.RunSyncService;
import dev.simplix.cirrus.spigot.listener.SpigotMenuListener;
import dev.simplix.cirrus.spigot.menubuilder.SpigotMenuBuildService;
import dev.simplix.cirrus.spigot.services.SpigotItemService;
import dev.simplix.cirrus.spigot.services.converters.BukkitItemStackConverter;
import dev.simplix.cirrus.spigot.services.converters.ItemStackConverter;
import dev.simplix.cirrus.spigot.services.converters.ItemTypeMaterialConverter;
import dev.simplix.cirrus.spigot.services.converters.NmsNbtQuerzNbtConverter;
import dev.simplix.cirrus.spigot.services.converters.QuerzNbtNmsNbtConverter;
import dev.simplix.cirrus.spigot.services.converters.SimpleComponentConverterProvider;
import dev.simplix.cirrus.spigot.services.converters.SpigotClickTypeConverter;
import dev.simplix.cirrus.spigot.services.converters.SpigotInventoryTypeConverter;
import dev.simplix.protocolize.api.providers.ComponentConverterProvider;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CirrusSpigot {
    private static final Logger log = LoggerFactory.getLogger(CirrusSpigot.class);
    private final JavaPlugin plugin;

    public void init() {
        Cirrus.init();
        Cirrus.canDisplayAsync(false);
        Cirrus.isSpigot(true);
        Cirrus.registerService(ItemService.class, new SpigotItemService());
        Cirrus.registerService(BukkitItemStackConverter.class, new BukkitItemStackConverter());
        Cirrus.registerService(ItemStackConverter.class, new ItemStackConverter());
        Cirrus.registerService(ItemTypeMaterialConverter.class, new ItemTypeMaterialConverter());
        Cirrus.registerService(NmsNbtQuerzNbtConverter.class, new NmsNbtQuerzNbtConverter());
        Cirrus.registerService(QuerzNbtNmsNbtConverter.class, new QuerzNbtNmsNbtConverter());
        Cirrus.registerService(SpigotClickTypeConverter.class, new SpigotClickTypeConverter());
        Cirrus.registerService(SpigotInventoryTypeConverter.class, new SpigotInventoryTypeConverter());
        Cirrus.registerService(MenuBuildService.class, new SpigotMenuBuildService(this.plugin));
        Cirrus.registerService(ComponentConverterProvider.class, new SimpleComponentConverterProvider());
        Cirrus.registerService(RunSyncService.class, runnable -> Bukkit.getScheduler().runTask((Plugin)this.plugin, runnable));
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, (Runnable)new MenuUpdateTask(), 0L, 1L);
        Bukkit.getPluginManager().registerEvents((Listener)new SpigotMenuListener(), (Plugin)this.plugin);
    }

    public CirrusSpigot(JavaPlugin plugin) {
        this.plugin = plugin;
    }
}

