/*
 * Decompiled with CFR 0.152.
 */
package dev.simplix.cirrus.spigot.menubuilder;

import dev.simplix.cirrus.Cirrus;
import dev.simplix.cirrus.menu.DisplayedMenu;
import dev.simplix.cirrus.menu.Menu;
import dev.simplix.cirrus.menu.Menus;
import dev.simplix.cirrus.player.CirrusPlayerWrapper;
import dev.simplix.cirrus.service.MenuBuildService;
import dev.simplix.cirrus.spigot.menubuilder.ModernInventoryView;
import dev.simplix.cirrus.spigot.services.converters.ItemStackConverter;
import dev.simplix.cirrus.spigot.services.converters.SpigotInventoryTypeConverter;
import dev.simplix.cirrus.spigot.util.ProtocolVersionUtil;
import dev.simplix.protocolize.api.item.BaseItemStack;
import dev.simplix.protocolize.data.inventory.InventoryType;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.java.JavaPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpigotMenuBuildService
implements MenuBuildService {
    private static final Logger log = LoggerFactory.getLogger(SpigotMenuBuildService.class);
    private final JavaPlugin plugin;
    private final Set<Long> usedIDs = new HashSet<Long>();

    private static boolean isChest(InventoryType type) {
        if (type == InventoryType.GENERIC_3X3) {
            return false;
        }
        return type.name().startsWith("GENERIC") || type.name().contains("CHEST");
    }

    @Override
    public DisplayedMenu openAndBuildMenu0(Menu menu, CirrusPlayerWrapper playerWrapper) {
        Player player = (Player)playerWrapper.handle();
        InventoryView inventoryView = this.makeView(menu, player);
        Inventory top = inventoryView.getTopInventory();
        if (top == null) {
            throw new IllegalStateException("Top inventory must not be null");
        }
        this.buildMenuIntoInventory(top, menu);
        player.openInventory(top);
        long id = this.generateID();
        DisplayedMenu displayedMenu = new DisplayedMenu(menu, inventoryView, playerWrapper, this, id);
        return displayedMenu;
    }

    @Override
    public void updateMenu(DisplayedMenu displayedMenu) {
        InventoryView inventoryView = (InventoryView)displayedMenu.nativeMenu();
        Inventory top = inventoryView.getTopInventory();
        if (top.getSize() == displayedMenu.value().type().getTypicalSize(ProtocolVersionUtil.serverProtocolVersion())) {
            this.buildMenuIntoInventory(top, displayedMenu.value());
        } else {
            this.buildAndOpenMenu(displayedMenu.value(), displayedMenu.player());
        }
    }

    @Override
    public void closeMenu0(DisplayedMenu displayedMenu) {
        Menus.remove(displayedMenu.player().uuid());
        Object t = displayedMenu.player().handle();
        if (t instanceof Player) {
            Player player = (Player)t;
            player.closeInventory();
        }
    }

    public void buildMenuIntoInventory(Inventory inventory, Menu menu) {
        menu.rootItems().forEach((BiConsumer<? super Integer, ? super BaseItemStack>)((BiConsumer<Integer, BaseItemStack>)(slot, item) -> {
            ItemStack apply = Cirrus.service(ItemStackConverter.class).apply((BaseItemStack)item);
            inventory.setItem(slot.intValue(), apply);
        }));
    }

    private InventoryView makeView(Menu menu, Player player) {
        PlayerInventory bottom = player.getInventory();
        Inventory result = SpigotMenuBuildService.isChest(menu.type()) ? Bukkit.createInventory((InventoryHolder)player, (int)menu.type().getTypicalSize(ProtocolVersionUtil.serverProtocolVersion()), (String)menu.title()) : Bukkit.createInventory((InventoryHolder)player, (org.bukkit.event.inventory.InventoryType)Cirrus.service(SpigotInventoryTypeConverter.class).apply(menu.type()), (String)menu.title());
        return new ModernInventoryView(menu, player, result, (Inventory)bottom);
    }

    private long generateID() {
        long id = 0L;
        while (this.usedIDs.contains(id)) {
            ++id;
        }
        this.usedIDs.add(id);
        return id;
    }

    public SpigotMenuBuildService(JavaPlugin plugin) {
        this.plugin = plugin;
    }
}

