/*
 * Decompiled with CFR 0.152.
 */
package dev.simplix.cirrus.spigot.services;

import dev.simplix.cirrus.service.ItemService;
import dev.simplix.protocolize.data.ItemType;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Material;

public class SpigotItemService
extends ItemService {
    private final Set<String> materialNames = Arrays.stream(Material.values()).map(Enum::name).collect(Collectors.toSet());

    @Override
    public boolean isItemAvailable(ItemType itemType, int protocolVersion) {
        Material material = this.material(itemType.name());
        return material != null && material.isItem() && !material.isAir();
    }

    private Material material(String name) {
        if (!this.materialNames.contains(name)) {
            return null;
        }
        try {
            return Material.valueOf((String)name);
        }
        catch (IllegalArgumentException exception) {
            return null;
        }
    }
}

