/*
 * Decompiled with CFR 0.152.
 */
package dev.simplix.cirrus.spigot.services.converters;

import dev.simplix.cirrus.Cirrus;
import dev.simplix.cirrus.spigot.services.converters.MaterialDataItemTypeConverter;
import dev.simplix.cirrus.spigot.services.converters.NmsNbtQuerzNbtConverter;
import dev.simplix.cirrus.spigot.util.ReflectionClasses;
import dev.simplix.cirrus.spigot.util.ReflectionUtil;
import dev.simplix.protocolize.api.item.ItemStack;
import java.util.function.Function;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BukkitItemStackConverter
implements Function<org.bukkit.inventory.ItemStack, ItemStack> {
    private static final Logger log = LoggerFactory.getLogger(BukkitItemStackConverter.class);
    private static Class<?> craftItemStackClass;
    private static Class<?> itemStackNMSClass;

    @Override
    public ItemStack apply(@NonNull org.bukkit.inventory.ItemStack src) {
        if (src == null) {
            throw new NullPointerException("src is marked non-null but is null");
        }
        try {
            ItemStack out = new ItemStack(Cirrus.service(MaterialDataItemTypeConverter.class).apply(src.getData()), src.getAmount(), src.getDurability());
            Object handle = ReflectionUtil.fieldValue(craftItemStackClass, src, "handle");
            out.nbtData(Cirrus.service(NmsNbtQuerzNbtConverter.class).apply(itemStackNMSClass.getMethod("getTag", new Class[0]).invoke(handle, new Object[0])));
            return out;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Could not convert item stack", exception);
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException("Fatal error converting item stack", throwable);
        }
    }

    static {
        try {
            craftItemStackClass = ReflectionUtil.getClass("{obc}.inventory.CraftItemStack");
            itemStackNMSClass = ReflectionClasses.itemStackClass();
        }
        catch (Exception exception) {
            log.error("Could not get required classes", (Throwable)exception);
        }
    }
}

