/*
 * Decompiled with CFR 0.152.
 */
package dev.simplix.cirrus.spigot.services.converters;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import dev.simplix.cirrus.Cirrus;
import dev.simplix.cirrus.spigot.services.converters.ItemTypeMaterialConverter;
import dev.simplix.cirrus.spigot.services.converters.QuerzNbtNmsNbtConverter;
import dev.simplix.cirrus.spigot.util.ComponentHelper;
import dev.simplix.cirrus.spigot.util.ProtocolVersionUtil;
import dev.simplix.cirrus.spigot.util.ReflectionClasses;
import dev.simplix.cirrus.spigot.util.ReflectionUtil;
import dev.simplix.protocolize.api.item.BaseItemStack;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;
import net.kyori.adventure.text.Component;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.querz.nbt.tag.CompoundTag;
import net.querz.nbt.tag.IntTag;
import net.querz.nbt.tag.ListTag;
import net.querz.nbt.tag.StringTag;
import net.querz.nbt.tag.Tag;
import org.bukkit.Material;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemStackConverter
implements Function<BaseItemStack, ItemStack> {
    private static final Logger log = LoggerFactory.getLogger(ItemStackConverter.class);
    private static Class<?> craftItemStackClass;
    private static Class<?> nbtTagCompoundClass;
    private static Class<?> itemStackNMSClass;
    private static Method nmsCopyMethod;
    private static Method bukkitCopyMethod;
    private static Method setTagMethod;

    @Override
    public ItemStack apply(BaseItemStack protocolizeItemStack) {
        CompoundTag skullOwnerTag;
        Tag propertiesRaw;
        CompoundTag tag;
        if (protocolizeItemStack.itemType() == null) {
            return new ItemStack(Material.AIR);
        }
        Material material = Cirrus.service(ItemTypeMaterialConverter.class).apply(protocolizeItemStack.itemType());
        ItemStack itemStack = ProtocolVersionUtil.serverProtocolVersion() < 393 ? new ItemStack(material, (int)protocolizeItemStack.amount(), protocolizeItemStack.durability(), Byte.valueOf((byte)0)) : new ItemStack(Cirrus.service(ItemTypeMaterialConverter.class).apply(protocolizeItemStack.itemType()), (int)protocolizeItemStack.amount(), protocolizeItemStack.durability());
        if (protocolizeItemStack.nbtData() == null) {
            protocolizeItemStack.nbtData(new CompoundTag());
        }
        String textureHashToInsert = null;
        if (protocolizeItemStack.nbtData() != null && !protocolizeItemStack.nbtData().keySet().isEmpty() && (tag = protocolizeItemStack.nbtData()).containsKey("SkullOwner") && tag.get("SkullOwner") instanceof CompoundTag && (propertiesRaw = (skullOwnerTag = tag.getCompoundTag("SkullOwner")).get("Properties")) instanceof CompoundTag) {
            ListTag textures = ((CompoundTag)propertiesRaw).getListTag("textures");
            textureHashToInsert = ((CompoundTag)textures.get(0)).getString("Value");
        }
        this.writeLoreAndDisplayNameToStack(protocolizeItemStack);
        try {
            Object nmsItemStack = nmsCopyMethod.invoke(null, itemStack);
            if (protocolizeItemStack.nbtData() != null && !protocolizeItemStack.nbtData().keySet().isEmpty()) {
                try {
                    Method setTag = this.setTagMethod();
                    CompoundTag nbtTag = protocolizeItemStack.nbtData().clone();
                    if (textureHashToInsert != null) {
                        nbtTag.remove("SkullOwner");
                    }
                    setTag.invoke(nmsItemStack, Cirrus.service(QuerzNbtNmsNbtConverter.class).apply(nbtTag));
                }
                catch (Throwable throwable) {
                    log.error("Error while setting nbt tag", throwable);
                }
            }
            ItemStack result = (ItemStack)bukkitCopyMethod.invoke(null, nmsItemStack);
            ItemMeta itemMeta = result.getItemMeta();
            this.mutateMetaDataToHideAttributes(itemMeta);
            result.setType(material);
            itemMeta.displayName((Component)protocolizeItemStack.displayName().asComponent());
            if (textureHashToInsert != null && itemMeta instanceof SkullMeta) {
                SkullMeta skullMeta = (SkullMeta)itemMeta;
                this.mutateItemMetaForTextureHash(skullMeta, textureHashToInsert);
            }
            result.setItemMeta(itemMeta);
            return result;
        }
        catch (Exception exception) {
            throw new IllegalStateException("Could not fully execute copying operations ", exception);
        }
    }

    private Method setTagMethod() throws NoSuchMethodException {
        Method setTag;
        if (setTagMethod != null) {
            return setTagMethod;
        }
        try {
            setTag = itemStackNMSClass.getMethod("setTag", nbtTagCompoundClass);
        }
        catch (NoSuchMethodException e) {
            setTag = itemStackNMSClass.getDeclaredMethod("setTagClone", nbtTagCompoundClass);
            setTag.setAccessible(true);
        }
        setTagMethod = setTag;
        return setTagMethod;
    }

    private void mutateMetaDataToHideAttributes(ItemMeta itemMeta) {
        try {
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_PLACED_ON});
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private GameProfile makeProfile(@NonNull String textureHash) {
        if (textureHash == null) {
            throw new NullPointerException("textureHash is marked non-null but is null");
        }
        UUID id = new UUID(textureHash.substring(textureHash.length() - 20).hashCode(), textureHash.substring(textureHash.length() - 10).hashCode());
        GameProfile profile = new GameProfile(id, "Player");
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", textureHash));
        return profile;
    }

    private void mutateItemMetaForTextureHash(SkullMeta meta, String textureHash) {
        try {
            Method metaSetProfileMethod = meta.getClass().getDeclaredMethod("setProfile", GameProfile.class);
            metaSetProfileMethod.setAccessible(true);
            metaSetProfileMethod.invoke((Object)meta, this.makeProfile(textureHash));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            try {
                Field profileField = meta.getClass().getDeclaredField("profile");
                profileField.setAccessible(true);
                profileField.set(meta, this.makeProfile(textureHash));
            }
            catch (IllegalAccessException | NoSuchFieldException exception) {
                exception.printStackTrace();
            }
        }
    }

    private void writeLoreAndDisplayNameToStack(@NonNull BaseItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("stack is marked non-null but is null");
        }
        if (stack.displayName() != null) {
            if (ProtocolVersionUtil.serverProtocolVersion() >= 393) {
                stack.nbtData().put("Damage", (Tag)new IntTag((int)stack.durability()));
                BaseComponent[] baseComponents = (BaseComponent[])stack.displayName().asComponent();
                ComponentHelper.removeItalic(baseComponents);
                this.setDisplayNameTag(stack.nbtData(), ComponentSerializer.toString((BaseComponent[])baseComponents));
            } else {
                this.setDisplayNameTag(stack.nbtData(), TextComponent.toLegacyText((BaseComponent[])new BaseComponent[]{(BaseComponent)stack.displayName().asComponent()}));
            }
        }
        if (stack.lore() != null) {
            this.setLoreTag(stack.nbtData(), new ArrayList<BaseComponent[]>(stack.lore().stream().map(i -> (BaseComponent[])i.asComponent()).toList()), ProtocolVersionUtil.serverProtocolVersion());
        }
    }

    private void setDisplayNameTag(@NonNull CompoundTag nbtData, @NonNull String name) {
        if (nbtData == null) {
            throw new NullPointerException("nbtData is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (name == null) {
            return;
        }
        CompoundTag display = (CompoundTag)nbtData.get("display");
        if (display == null) {
            display = new CompoundTag();
        }
        StringTag tag = new StringTag(name);
        display.put("Name", (Tag)tag);
        nbtData.put("display", (Tag)display);
    }

    private void setLoreTag(@NonNull CompoundTag nbtData, @NonNull List<BaseComponent[]> lore, int protocolVersion) {
        if (nbtData == null) {
            throw new NullPointerException("nbtData is marked non-null but is null");
        }
        if (lore == null) {
            throw new NullPointerException("lore is marked non-null but is null");
        }
        CompoundTag display = (CompoundTag)nbtData.get("display");
        if (display == null) {
            display = new CompoundTag();
        }
        ListTag tag = new ListTag(StringTag.class);
        if (protocolVersion < 477) {
            tag.addAll((Collection)lore.stream().map(i -> new StringTag(TextComponent.toLegacyText((BaseComponent[])i))).collect(Collectors.toList()));
        } else {
            tag.addAll((Collection)lore.stream().map(components -> {
                for (BaseComponent component : components) {
                    if (component.isItalic()) continue;
                    component.setItalic(Boolean.valueOf(false));
                }
                return new StringTag(ComponentSerializer.toString((BaseComponent[])components));
            }).collect(Collectors.toList()));
        }
        display.put("Lore", (Tag)tag);
        nbtData.put("display", (Tag)display);
    }

    static {
        try {
            craftItemStackClass = ReflectionUtil.getClass("{obc}.inventory.CraftItemStack");
            nbtTagCompoundClass = ReflectionClasses.nbtTagCompound();
            itemStackNMSClass = ReflectionClasses.itemStackClass();
            nmsCopyMethod = craftItemStackClass.getMethod("asNMSCopy", ItemStack.class);
            bukkitCopyMethod = craftItemStackClass.getMethod("asBukkitCopy", itemStackNMSClass);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

