/*
 * Decompiled with CFR 0.152.
 */
package dev.simplix.cirrus.spigot.services.converters;

import dev.simplix.cirrus.spigot.util.ReflectionClasses;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.function.Function;
import lombok.NonNull;
import net.querz.nbt.io.NBTInputStream;
import net.querz.nbt.tag.CompoundTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NmsNbtQuerzNbtConverter
implements Function<Object, CompoundTag> {
    private static final Logger log = LoggerFactory.getLogger(NmsNbtQuerzNbtConverter.class);
    private static Method nbtCompressedStreamToolAMethod;

    @Override
    public CompoundTag apply(@NonNull Object src) {
        CompoundTag compoundTag;
        if (src == null) {
            throw new NullPointerException("src is marked non-null but is null");
        }
        byte[] data = null;
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            nbtCompressedStreamToolAMethod.invoke(null, src, byteArrayOutputStream);
            data = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);
        try {
            compoundTag = (CompoundTag)new NBTInputStream((InputStream)byteArrayInputStream).readTag(99).getTag();
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteArrayInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
                return null;
            }
        }
        byteArrayInputStream.close();
        return compoundTag;
    }

    static {
        try {
            nbtCompressedStreamToolAMethod = ReflectionClasses.nbtCompressedStreamTools().getMethod("a", ReflectionClasses.nbtTagCompound(), OutputStream.class);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

