/*
 * Decompiled with CFR 0.152.
 */
package dev.simplix.cirrus.spigot.services.converters;

import dev.simplix.cirrus.spigot.util.ReflectionClasses;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.function.Function;
import java.util.zip.GZIPOutputStream;
import lombok.NonNull;
import net.querz.nbt.io.NBTOutputStream;
import net.querz.nbt.tag.CompoundTag;
import net.querz.nbt.tag.Tag;
import org.jetbrains.annotations.NotNull;

public class QuerzNbtNmsNbtConverter
implements Function<CompoundTag, Object> {
    private static Method nbtCompressedStreamToolAMethod;

    @Override
    public Object apply(@NonNull @NotNull CompoundTag src) {
        Object object;
        if (src == null) {
            throw new NullPointerException("src is marked non-null but is null");
        }
        byte[] data = null;
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            new NBTOutputStream((OutputStream)gzipOutputStream).writeTag((Tag)src, 99);
            gzipOutputStream.close();
            data = byteArrayOutputStream.toByteArray();
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);
        try {
            object = nbtCompressedStreamToolAMethod.invoke(null, byteArrayInputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteArrayInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        byteArrayInputStream.close();
        return object;
    }

    static {
        try {
            nbtCompressedStreamToolAMethod = ReflectionClasses.nbtCompressedStreamTools().getMethod("a", InputStream.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

