/*
 * Decompiled with CFR 0.152.
 */
package dev.simplix.cirrus.spigot.util;

import dev.simplix.protocolize.api.Platform;
import dev.simplix.protocolize.api.Protocolize;
import dev.simplix.protocolize.api.module.ProtocolizeModule;
import dev.simplix.protocolize.api.providers.ModuleProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OtherModuleProvider
implements ModuleProvider {
    private static final Logger log = LoggerFactory.getLogger((String)"Protocolize");
    private final List<ProtocolizeModule> modules = new ArrayList<ProtocolizeModule>();

    public void registerModule(ProtocolizeModule module) {
        if (!this.supportedPlatform(module.supportedPlatforms())) {
            log.warn("Won't register module " + module.getClass().getName() + ": Only supports " + Arrays.toString(module.supportedPlatforms()));
            return;
        }
        this.modules.add(module);
        this.enableModule(module);
    }

    public boolean moduleInstalled(String s) {
        return this.modules.stream().map(module -> module.getClass().getSimpleName()).collect(Collectors.toList()).contains(s);
    }

    public ProtocolizeModule module(String s) {
        return this.modules.stream().filter(module -> module.getClass().getSimpleName().equalsIgnoreCase(s)).findFirst().orElse(null);
    }

    private boolean supportedPlatform(Platform[] supportedPlatforms) {
        for (Platform platform : supportedPlatforms) {
            if (Protocolize.platform() != platform) continue;
            return true;
        }
        return false;
    }

    private void enableModule(ProtocolizeModule module) {
        module.registerMappings(Protocolize.mappingProvider());
        module.registerPackets(Protocolize.protocolRegistration());
        log.info("Enabled module " + module.getClass().getName());
    }

    public List<ProtocolizeModule> modules() {
        return this.modules;
    }
}

