/*
 * Decompiled with CFR 0.152.
 */
package dev.simplix.cirrus.spigot.util;

import dev.simplix.cirrus.spigot.util.ReflectionUtil;
import dev.simplix.protocolize.api.util.ProtocolVersions;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProtocolVersionUtil {
    private static final Logger log = LoggerFactory.getLogger(ProtocolVersionUtil.class);
    private static int protocolVersion;
    private static String versionString;

    public static int serverProtocolVersion() {
        if (protocolVersion == 0) {
            protocolVersion = ProtocolVersionUtil.detectVersion();
        }
        return protocolVersion;
    }

    public static String versionString() {
        if (versionString != null) {
            return versionString;
        }
        versionString = ReflectionUtil.serverVersion().substring(1, ReflectionUtil.serverVersion().indexOf(95, 3));
        return versionString;
    }

    private static int detectVersion() {
        String majorVersion = ReflectionUtil.serverVersion().substring(1, ReflectionUtil.serverVersion().indexOf(95, 3));
        try {
            Field field = ProtocolVersions.class.getField("MINECRAFT_" + majorVersion);
            return field.getInt(null);
        }
        catch (IllegalAccessException exception) {
            log.error("Could not access field MINECRAFT_" + majorVersion, (Throwable)exception);
        }
        catch (NoSuchFieldException exception) {
            log.warn("[Cirrus] Cirrus is not compatible with this version ", (Throwable)exception);
            log.warn("[Cirrus] [Compatibility Mode] Proceeding as if in Minecraft 1.18");
        }
        return 757;
    }

    private ProtocolVersionUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

