/*
 * Decompiled with CFR 0.152.
 */
package dev.simplix.cirrus.spigot.util;

import com.mojang.authlib.GameProfile;
import dev.simplix.cirrus.spigot.util.ProtocolVersionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Scoreboard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReflectionUtil {
    private static final Logger log = LoggerFactory.getLogger(ReflectionUtil.class);
    private static final String EXCEPTION_OCCURRED = "Exception occurred";
    private static final String GET_HANDLE = "getHandle";
    private static final String PLAYER_CONNECTION = "playerConnection";
    private static final String SEND_PACKET = "sendPacket";
    private static final String NMS_PACKET = "{nms}.Packet";
    private static final Map<Map.Entry<Class<?>, String>, Field> CACHED_FIELDS = new HashMap();
    private static final Map<String, Class<?>> CACHED_CLASSES = new HashMap();

    public static boolean hasNewItemTypeStructure() {
        return ProtocolVersionUtil.serverProtocolVersion() >= 477;
    }

    public static boolean hasNewPackageStructure() {
        return ProtocolVersionUtil.serverProtocolVersion() >= 755;
    }

    public static Class<?> getClass(String classname) throws ClassNotFoundException {
        String path = classname.replace("{nm}", "net.minecraft" + (String)(ReflectionUtil.hasNewPackageStructure() ? "" : "." + ReflectionUtil.serverVersion())).replace("{nms}", "net.minecraft.server" + (String)(ReflectionUtil.hasNewPackageStructure() ? "" : "." + ReflectionUtil.serverVersion())).replace("{obc}", "org.bukkit.craftbukkit." + ReflectionUtil.serverVersion());
        Class<?> out = CACHED_CLASSES.get(path);
        if (out == null) {
            out = Class.forName(path);
            CACHED_CLASSES.put(path, out);
        }
        return out;
    }

    public static String serverVersion() {
        String packageString = null;
        try {
            packageString = Bukkit.getServer().getClass().getPackage().getName();
            return packageString.split("\\.")[3];
        }
        catch (Exception exception) {
            log.warn("[Cirrus] Could not determine server version from " + packageString, (Throwable)exception);
            return "v1_18_1";
        }
    }

    public static GameProfile gameProfile(@NonNull Player player) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        Object obcPlayer = ReflectionUtil.obcPlayer(player);
        Class<?> obcPlayerClass = obcPlayer.getClass();
        return (GameProfile)obcPlayerClass.getMethod("getProfile", new Class[0]).invoke((Object)player, new Object[0]);
    }

    public static Object nmsPlayer(@NonNull Player player) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        Method getHandle = player.getClass().getMethod(GET_HANDLE, new Class[0]);
        return getHandle.invoke((Object)player, new Object[0]);
    }

    public static Object obcPlayer(@NonNull Player player) throws ClassNotFoundException {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return ReflectionUtil.getClass("{obc}.entity.CraftPlayer").cast(player);
    }

    public static Object nmsWorld(@NonNull World world) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
        Method getHandle = world.getClass().getMethod(GET_HANDLE, new Class[0]);
        return getHandle.invoke((Object)world, new Object[0]);
    }

    public static Object nmsScoreboard(@NonNull Scoreboard scoreboard) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (scoreboard == null) {
            throw new NullPointerException("scoreboard is marked non-null but is null");
        }
        Method getHandle = scoreboard.getClass().getMethod(GET_HANDLE, new Class[0]);
        return getHandle.invoke((Object)scoreboard, new Object[0]);
    }

    public static Object fieldValue(@NonNull Object instance, @NonNull String fieldName) throws IllegalAccessException {
        if (instance == null) {
            throw new NullPointerException("instance is marked non-null but is null");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        AbstractMap.SimpleEntry key = new AbstractMap.SimpleEntry(instance.getClass(), fieldName);
        Field field = CACHED_FIELDS.computeIfAbsent(key, i -> {
            try {
                return instance.getClass().getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                log.error(EXCEPTION_OCCURRED, (Throwable)e);
                return null;
            }
        });
        if (field == null) {
            return null;
        }
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        return field.get(instance);
    }

    public static <T> T fieldValue(@NonNull Field field, @NonNull Object obj) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        try {
            return (T)field.get(obj);
        }
        catch (Exception exception) {
            log.error(EXCEPTION_OCCURRED, (Throwable)exception);
            return null;
        }
    }

    public static Field field(@NonNull Class<?> clazz, @NonNull String fieldName) throws NoSuchFieldException {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        return field;
    }

    public static void value(Object instance, String field, Object value) {
        try {
            Field f = instance.getClass().getDeclaredField(field);
            f.setAccessible(true);
            f.set(instance, value);
        }
        catch (Exception exception) {
            log.error(EXCEPTION_OCCURRED, (Throwable)exception);
        }
    }

    public static void value(@NonNull Class<?> clazz, @NonNull Object instance, @NonNull String field, @NonNull Object value) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (instance == null) {
            throw new NullPointerException("instance is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        try {
            Field declaredField = clazz.getDeclaredField(field);
            declaredField.setAccessible(true);
            declaredField.set(instance, value);
        }
        catch (Exception e) {
            log.error(EXCEPTION_OCCURRED, (Throwable)e);
        }
    }

    public static void valueSubclass(@NonNull Class<?> clazz, @NonNull Object instance, @NonNull String field, @NonNull Object value) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (instance == null) {
            throw new NullPointerException("instance is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        try {
            Field declaredField = clazz.getDeclaredField(field);
            declaredField.setAccessible(true);
            declaredField.set(instance, value);
        }
        catch (Exception e) {
            log.error(EXCEPTION_OCCURRED, (Throwable)e);
        }
    }

    public static void sendAllPacket(@NonNull Object packet) throws ReflectiveOperationException {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        for (Player p : Bukkit.getOnlinePlayers()) {
            Object nmsPlayer = ReflectionUtil.nmsPlayer(p);
            Object connection = nmsPlayer.getClass().getField(PLAYER_CONNECTION).get(nmsPlayer);
            connection.getClass().getMethod(SEND_PACKET, ReflectionUtil.getClass(NMS_PACKET)).invoke(connection, packet);
        }
    }

    public static void sendListPacket(@NonNull List<String> players, @NonNull Object packet) {
        if (players == null) {
            throw new NullPointerException("players is marked non-null but is null");
        }
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        try {
            for (String name : players) {
                Object nmsPlayer = ReflectionUtil.nmsPlayer(Bukkit.getPlayer((String)name));
                Object connection = nmsPlayer.getClass().getField(PLAYER_CONNECTION).get(nmsPlayer);
                connection.getClass().getMethod(SEND_PACKET, ReflectionUtil.getClass(NMS_PACKET)).invoke(connection, packet);
            }
        }
        catch (Exception exception) {
            log.error(EXCEPTION_OCCURRED, (Throwable)exception);
        }
    }

    public static void sendPlayerPacket(@NonNull Player player, @NonNull Object packet) throws ReflectiveOperationException {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        Object nmsPlayer = ReflectionUtil.nmsPlayer(player);
        Object connection = nmsPlayer.getClass().getField(PLAYER_CONNECTION).get(nmsPlayer);
        connection.getClass().getMethod(SEND_PACKET, ReflectionUtil.getClass(NMS_PACKET)).invoke(connection, packet);
    }

    public static void listFields(@NonNull Object object) {
        Field[] declaredFields;
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        log.info(object.getClass().getName() + " contains " + object.getClass().getDeclaredFields().length + " declared fields.");
        log.info(object.getClass().getName() + " contains " + object.getClass().getDeclaredClasses().length + " declared classes.");
        for (Field field : declaredFields = object.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            try {
                log.info(field.getName() + " -> " + field.get(object));
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                log.error(EXCEPTION_OCCURRED, (Throwable)exception);
            }
        }
    }

    public static Object fieldValue(@NonNull Class<?> superclass, @NonNull Object instance, @NonNull String fieldName) throws IllegalAccessException, NoSuchFieldException {
        if (superclass == null) {
            throw new NullPointerException("superclass is marked non-null but is null");
        }
        if (instance == null) {
            throw new NullPointerException("instance is marked non-null but is null");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        Field field = superclass.getDeclaredField(fieldName);
        field.setAccessible(true);
        return field.get(instance);
    }

    private ReflectionUtil() {
    }
}

