/*
 * Decompiled with CFR 0.152.
 */
package dev.simplix.cirrus.spigot.wrapper;

import dev.simplix.cirrus.Utils;
import dev.simplix.cirrus.model.SimpleSound;
import dev.simplix.cirrus.player.CirrusPlayerWrapper;
import dev.simplix.cirrus.spigot.util.ProtocolVersionUtil;
import java.util.UUID;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class SpigotPlayerWrapper
implements CirrusPlayerWrapper {
    private final Player handle;

    @Override
    public UUID uuid() {
        return this.handle.getUniqueId();
    }

    @Override
    public <T> T handle() {
        return (T)this.handle;
    }

    @Override
    public int protocolVersion() {
        return ProtocolVersionUtil.serverProtocolVersion();
    }

    @Override
    public void play(SimpleSound sound) {
        try {
            Sound bukkitSound = Sound.valueOf((String)sound.sound().name());
            this.handle.playSound(this.handle.getLocation(), bukkitSound, sound.volume(), sound.pitch());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void sendMessage(String message) {
        this.handle.sendMessage(Utils.colorize(message));
    }

    public SpigotPlayerWrapper(Player handle) {
        this.handle = handle;
    }
}

