/*
 * Decompiled with CFR 0.152.
 */
package dev.simplix.cirrus.util;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;

public final class ToStringUtil {
    private final String className;
    private ValueHolder holderHead;
    private ValueHolder holderTail;
    private boolean omitNullValues;

    public static ToStringUtil of(Object self) {
        return new ToStringUtil(self.getClass().getSimpleName());
    }

    public static ToStringUtil of(String className) {
        return new ToStringUtil(className);
    }

    public static ToStringUtil of(Class<?> clazz) {
        return new ToStringUtil(clazz.getSimpleName());
    }

    private ToStringUtil(String className) {
        this.holderTail = this.holderHead = new ValueHolder();
        this.omitNullValues = false;
        this.className = (String)Preconditions.checkNotNull((Object)className);
    }

    public ToStringUtil omitNullValues() {
        this.omitNullValues = true;
        return this;
    }

    public ToStringUtil add(String name, @Nullable Object value) {
        return this.addHolder(name, value);
    }

    public ToStringUtil add(String name, boolean value) {
        return this.addHolder(name, String.valueOf(value));
    }

    public ToStringUtil add(String name, char value) {
        return this.addHolder(name, String.valueOf(value));
    }

    public ToStringUtil add(String name, double value) {
        return this.addHolder(name, String.valueOf(value));
    }

    public ToStringUtil add(String name, float value) {
        return this.addHolder(name, String.valueOf(value));
    }

    public ToStringUtil add(String name, int value) {
        return this.addHolder(name, String.valueOf(value));
    }

    public ToStringUtil add(String name, long value) {
        return this.addHolder(name, String.valueOf(value));
    }

    public ToStringUtil addValue(@Nullable Object value) {
        return this.addHolder(value);
    }

    public ToStringUtil addValue(boolean value) {
        return this.addHolder(String.valueOf(value));
    }

    public ToStringUtil addValue(char value) {
        return this.addHolder(String.valueOf(value));
    }

    public ToStringUtil addValue(double value) {
        return this.addHolder(String.valueOf(value));
    }

    public ToStringUtil addValue(float value) {
        return this.addHolder(String.valueOf(value));
    }

    public ToStringUtil addValue(int value) {
        return this.addHolder(String.valueOf(value));
    }

    public ToStringUtil addValue(long value) {
        return this.addHolder(String.valueOf(value));
    }

    public String toString() {
        boolean omitNullValuesSnapshot = this.omitNullValues;
        String nextSeparator = "";
        StringBuilder builder = new StringBuilder(32).append(this.className).append('{');
        ValueHolder valueHolder = this.holderHead.next;
        while (valueHolder != null) {
            if (!omitNullValuesSnapshot || valueHolder.value != null) {
                builder.append(nextSeparator);
                nextSeparator = ", ";
                if (valueHolder.name != null) {
                    builder.append(valueHolder.name).append('=');
                }
                builder.append(valueHolder.value);
            }
            valueHolder = valueHolder.next;
        }
        return builder.append('}').toString();
    }

    private ValueHolder addHolder() {
        ValueHolder valueHolder;
        this.holderTail = this.holderTail.next = (valueHolder = new ValueHolder());
        return valueHolder;
    }

    private ToStringUtil addHolder(@Nullable Object value) {
        ValueHolder valueHolder = this.addHolder();
        valueHolder.value = value;
        return this;
    }

    private ToStringUtil addHolder(String name, @Nullable Object value) {
        ValueHolder valueHolder = this.addHolder();
        valueHolder.value = value;
        valueHolder.name = (String)Preconditions.checkNotNull((Object)name);
        return this;
    }

    private static final class ValueHolder {
        String name;
        Object value;
        ValueHolder next;

        private ValueHolder() {
        }
    }
}

