/*
 * Decompiled with CFR 0.152.
 */
package gg.modl.minecraft.api;

import com.google.gson.annotations.SerializedName;
import gg.modl.minecraft.api.Modification;
import gg.modl.minecraft.api.Note;
import gg.modl.minecraft.api.PunishmentData;
import java.util.Date;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class Punishment {
    @SerializedName(value="id")
    @NotNull
    private final String id;
    @SerializedName(value="issuerName")
    @NotNull
    private final String issuerName;
    @SerializedName(value="issued")
    @NotNull
    private final Date issued;
    @SerializedName(value="started")
    private final Date started;
    @SerializedName(value="type")
    private final Type type;
    @SerializedName(value="modifications")
    @NotNull
    private final List<Modification> modifications;
    @SerializedName(value="notes")
    @NotNull
    private final List<Note> notes;
    @SerializedName(value="attachedTicketIds")
    @NotNull
    private final List<String> attachedTicketIds;
    @SerializedName(value="data")
    @NotNull
    private final Map<String, Object> dataMap;
    private transient PunishmentData data;

    public PunishmentData getData() {
        if (this.data == null) {
            this.data = PunishmentData.fromMap(this.dataMap);
        }
        return this.data;
    }

    public String getReason() {
        return this.notes.get(0).getText();
    }

    public Date getExpires() {
        Object expires = this.dataMap.get("expires");
        if (expires instanceof Date) {
            return (Date)expires;
        }
        if (expires instanceof Long) {
            return new Date((Long)expires);
        }
        return null;
    }

    public boolean isActive() {
        Object activeFlag = this.dataMap.get("active");
        if (activeFlag instanceof Boolean && !((Boolean)activeFlag).booleanValue()) {
            return false;
        }
        Date expiry = this.getExpires();
        if (expiry != null && expiry.before(new Date())) {
            return false;
        }
        if (this.type == Type.BAN || this.type == Type.MUTE) {
            return this.started != null;
        }
        return true;
    }

    public Long getDuration() {
        Object duration = this.dataMap.get("duration");
        if (duration instanceof Number) {
            return ((Number)duration).longValue();
        }
        return null;
    }

    public boolean isSilent() {
        Object silent = this.dataMap.get("silent");
        return silent instanceof Boolean && (Boolean)silent != false;
    }

    @NotNull
    @Generated
    public String getId() {
        return this.id;
    }

    @NotNull
    @Generated
    public String getIssuerName() {
        return this.issuerName;
    }

    @NotNull
    @Generated
    public Date getIssued() {
        return this.issued;
    }

    @Generated
    public Date getStarted() {
        return this.started;
    }

    @Generated
    public Type getType() {
        return this.type;
    }

    @NotNull
    @Generated
    public List<Modification> getModifications() {
        return this.modifications;
    }

    @NotNull
    @Generated
    public List<Note> getNotes() {
        return this.notes;
    }

    @NotNull
    @Generated
    public List<String> getAttachedTicketIds() {
        return this.attachedTicketIds;
    }

    @NotNull
    @Generated
    public Map<String, Object> getDataMap() {
        return this.dataMap;
    }

    @Generated
    public Punishment(@NotNull String id, @NotNull String issuerName, @NotNull Date issued, Date started, Type type, @NotNull List<Modification> modifications, @NotNull List<Note> notes, @NotNull List<String> attachedTicketIds, @NotNull Map<String, Object> dataMap) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (issuerName == null) {
            throw new NullPointerException("issuerName is marked non-null but is null");
        }
        if (issued == null) {
            throw new NullPointerException("issued is marked non-null but is null");
        }
        if (modifications == null) {
            throw new NullPointerException("modifications is marked non-null but is null");
        }
        if (notes == null) {
            throw new NullPointerException("notes is marked non-null but is null");
        }
        if (attachedTicketIds == null) {
            throw new NullPointerException("attachedTicketIds is marked non-null but is null");
        }
        if (dataMap == null) {
            throw new NullPointerException("dataMap is marked non-null but is null");
        }
        this.id = id;
        this.issuerName = issuerName;
        this.issued = issued;
        this.started = started;
        this.type = type;
        this.modifications = modifications;
        this.notes = notes;
        this.attachedTicketIds = attachedTicketIds;
        this.dataMap = dataMap;
    }

    public static enum Type {
        KICK(0),
        MUTE(1),
        BAN(2),
        SECURITY_BAN(3),
        LINKED_BAN(4),
        BLACKLIST(5);

        private final int value;

        public int getValue() {
            return this.value;
        }

        public static Type fromValue(int value) {
            for (Type type : Type.values()) {
                if (type.value != value) continue;
                return type;
            }
            return null;
        }

        @Generated
        private Type(int value) {
            this.value = value;
        }
    }
}

