/*
 * Decompiled with CFR 0.152.
 */
package gg.modl.minecraft.api;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PunishmentData(@Nullable String blockedName, @Nullable String blockedSkin, @Nullable String linkedBanId, @NotNull AtomicReference<Date> linkedBanExpiry, @Nullable List<String> chatLog, long duration, boolean altBlocking, boolean wipeAfterExpiry) {
    public Map<String, Object> export() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.blockedName != null) {
            map.put("blockedName", this.blockedName);
        }
        if (this.blockedSkin != null) {
            map.put("blockedSkin", this.blockedSkin);
        }
        if (this.linkedBanId != null) {
            map.put("linkedBanId", this.linkedBanId);
        }
        if (this.linkedBanExpiry.get() != null) {
            map.put("linkedBanExpiry", this.linkedBanExpiry.get().getTime());
        }
        if (this.chatLog != null) {
            map.put("chatLog", this.chatLog);
        }
        if (this.duration != -1L) {
            map.put("duration", this.duration);
        }
        if (this.altBlocking) {
            map.put("altBlocking", true);
        }
        if (this.wipeAfterExpiry) {
            map.put("wipeAfterExpiry", true);
        }
        return map;
    }

    public static PunishmentData fromMap(Map<String, Object> map) {
        Object chatLogObj;
        String blockedName = (String)map.get("blockedName");
        String blockedSkin = (String)map.get("blockedSkin");
        String linkedBanId = (String)map.get("linkedBanId");
        AtomicReference<Date> linkedBanExpiry = new AtomicReference<Date>();
        if (map.containsKey("linkedBanExpiry")) {
            Object expiry = map.get("linkedBanExpiry");
            if (expiry instanceof Long) {
                linkedBanExpiry.set(new Date((Long)expiry));
            } else if (expiry instanceof Date) {
                linkedBanExpiry.set((Date)expiry);
            }
        }
        ArrayList<String> chatLog = null;
        if (map.containsKey("chatLog") && (chatLogObj = map.get("chatLog")) instanceof List) {
            chatLog = new ArrayList<String>((List)chatLogObj);
        }
        long duration = -1L;
        if (map.containsKey("duration")) {
            Object durationObj = map.get("duration");
            if (durationObj instanceof Long) {
                duration = (Long)durationObj;
            } else if (durationObj instanceof Integer) {
                duration = ((Integer)durationObj).longValue();
            }
        }
        boolean altBlocking = map.containsKey("altBlocking");
        boolean wipeAfterExpiry = map.containsKey("wipeAfterExpiry");
        return new PunishmentData(blockedName, blockedSkin, linkedBanId, linkedBanExpiry, chatLog, duration, altBlocking, wipeAfterExpiry);
    }
}

