/*
 * Decompiled with CFR 0.152.
 */
package gg.modl.minecraft.api;

import java.util.Date;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimplePunishment {
    @NotNull
    private String type;
    private boolean started;
    @Nullable
    private Long expiration;
    @NotNull
    private String description;
    @NotNull
    private String id;
    private int ordinal;

    public boolean isBan() {
        return "BAN".equalsIgnoreCase(this.type);
    }

    public boolean isMute() {
        return "MUTE".equalsIgnoreCase(this.type);
    }

    public boolean isKick() {
        return "KICK".equalsIgnoreCase(this.type) || this.ordinal == 0;
    }

    public boolean isPermanent() {
        return this.expiration == null;
    }

    public boolean isExpired() {
        return this.expiration != null && this.expiration < System.currentTimeMillis();
    }

    public Date getExpirationAsDate() {
        return this.expiration != null ? new Date(this.expiration) : null;
    }

    @NotNull
    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public boolean isStarted() {
        return this.started;
    }

    @Nullable
    @Generated
    public Long getExpiration() {
        return this.expiration;
    }

    @NotNull
    @Generated
    public String getDescription() {
        return this.description;
    }

    @NotNull
    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public int getOrdinal() {
        return this.ordinal;
    }

    @Generated
    public void setType(@NotNull String type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
    }

    @Generated
    public void setStarted(boolean started) {
        this.started = started;
    }

    @Generated
    public void setExpiration(@Nullable Long expiration) {
        this.expiration = expiration;
    }

    @Generated
    public void setDescription(@NotNull String description) {
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        this.description = description;
    }

    @Generated
    public void setId(@NotNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    @Generated
    public void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimplePunishment)) {
            return false;
        }
        SimplePunishment other = (SimplePunishment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isStarted() != other.isStarted()) {
            return false;
        }
        if (this.getOrdinal() != other.getOrdinal()) {
            return false;
        }
        Long this$expiration = this.getExpiration();
        Long other$expiration = other.getExpiration();
        if (this$expiration == null ? other$expiration != null : !((Object)this$expiration).equals(other$expiration)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SimplePunishment;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isStarted() ? 79 : 97);
        result = result * 59 + this.getOrdinal();
        Long $expiration = this.getExpiration();
        result = result * 59 + ($expiration == null ? 43 : ((Object)$expiration).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SimplePunishment(type=" + this.getType() + ", started=" + this.isStarted() + ", expiration=" + this.getExpiration() + ", description=" + this.getDescription() + ", id=" + this.getId() + ", ordinal=" + this.getOrdinal() + ")";
    }

    @Generated
    public SimplePunishment(@NotNull String type, boolean started, @Nullable Long expiration, @NotNull String description, @NotNull String id, int ordinal) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.type = type;
        this.started = started;
        this.expiration = expiration;
        this.description = description;
        this.id = id;
        this.ordinal = ordinal;
    }

    @Generated
    public SimplePunishment() {
    }
}

