/*
 * Decompiled with CFR 0.152.
 */
package gg.modl.minecraft.bungee;

import com.google.gson.JsonObject;
import gg.modl.minecraft.api.Punishment;
import gg.modl.minecraft.api.SimplePunishment;
import gg.modl.minecraft.api.http.ModlHttpClient;
import gg.modl.minecraft.api.http.PanelUnavailableException;
import gg.modl.minecraft.api.http.request.PlayerDisconnectRequest;
import gg.modl.minecraft.api.http.request.PlayerLoginRequest;
import gg.modl.minecraft.api.http.request.PunishmentAcknowledgeRequest;
import gg.modl.minecraft.api.http.response.PlayerLoginResponse;
import gg.modl.minecraft.api.http.response.SyncResponse;
import gg.modl.minecraft.bungee.BungeePlatform;
import gg.modl.minecraft.core.impl.cache.Cache;
import gg.modl.minecraft.core.locale.LocaleManager;
import gg.modl.minecraft.core.service.ChatMessageCache;
import gg.modl.minecraft.core.sync.SyncService;
import gg.modl.minecraft.core.util.IpApiClient;
import gg.modl.minecraft.core.util.PunishmentMessages;
import gg.modl.minecraft.core.util.WebPlayer;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.ChatEvent;
import net.md_5.bungee.api.event.LoginEvent;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.event.EventHandler;

public class BungeeListener
implements Listener {
    private final BungeePlatform platform;
    private final Cache cache;
    private final ModlHttpClient httpClient;
    private final ChatMessageCache chatMessageCache;
    private final SyncService syncService;
    private final String panelUrl;
    private final LocaleManager localeManager;

    @EventHandler(priority=64)
    public void onLogin(LoginEvent event) {
        String ipAddress;
        String socketAddress = event.getConnection().getSocketAddress().toString();
        String string = ipAddress = socketAddress.startsWith("/") ? socketAddress.substring(1) : socketAddress;
        if (ipAddress.contains(":")) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf(":"));
        }
        JsonObject ipInfo = null;
        try {
            CompletableFuture<JsonObject> ipInfoFuture = IpApiClient.getIpInfo(ipAddress);
            ipInfo = ipInfoFuture.get(3L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            this.platform.getLogger().warning("Failed to get IP info for " + ipAddress + " within timeout: " + e.getMessage());
        }
        String skinHash = null;
        try {
            WebPlayer webPlayer = WebPlayer.get(event.getConnection().getUniqueId()).get(3L, TimeUnit.SECONDS);
            if (webPlayer != null && webPlayer.valid()) {
                skinHash = webPlayer.skin();
            }
        }
        catch (Exception e) {
            this.platform.getLogger().warning("Failed to get skin hash for " + event.getConnection().getName() + ": " + e.getMessage());
        }
        PlayerLoginRequest request = new PlayerLoginRequest(event.getConnection().getUniqueId().toString(), event.getConnection().getName(), ipAddress, skinHash, ipInfo, this.platform.getServerName());
        try {
            CompletableFuture<PlayerLoginResponse> loginFuture = this.httpClient.playerLogin(request);
            PlayerLoginResponse response = loginFuture.get(5L, TimeUnit.SECONDS);
            if (response.hasActiveBan()) {
                SimplePunishment ban = response.getActiveBan();
                String banText = PunishmentMessages.formatBanMessage(ban, this.localeManager, PunishmentMessages.MessageContext.LOGIN);
                TextComponent kickMessage = new TextComponent(banText);
                event.setCancelReason(new BaseComponent[]{kickMessage});
                event.setCancelled(true);
                if (!ban.isStarted()) {
                    this.acknowledgeBanEnforcement(ban, event.getConnection().getUniqueId().toString());
                }
            }
        }
        catch (PanelUnavailableException e) {
            this.platform.getLogger().warning("Panel 502 during login check for " + event.getConnection().getName() + " - blocking login for safety");
            TextComponent errorMessage = new TextComponent("Unable to verify ban status. Login temporarily restricted for safety.");
            event.setCancelReason(new BaseComponent[]{errorMessage});
            event.setCancelled(true);
        }
        catch (TimeoutException e) {
            this.platform.getLogger().warning("Login check timed out for " + event.getConnection().getName() + " - blocking login for safety");
            TextComponent errorMessage = new TextComponent("Login verification timed out. Please try again.");
            event.setCancelReason(new BaseComponent[]{errorMessage});
            event.setCancelled(true);
        }
        catch (Exception e) {
            this.platform.getLogger().severe("Failed to check punishments for " + event.getConnection().getName() + ": " + e.getMessage());
        }
    }

    @EventHandler
    public void onPostLogin(PostLoginEvent event) {
        String skinHash = null;
        try {
            WebPlayer webPlayer = WebPlayer.get(event.getPlayer().getUniqueId()).get(3L, TimeUnit.SECONDS);
            if (webPlayer != null && webPlayer.valid()) {
                skinHash = webPlayer.skin();
            }
        }
        catch (Exception e) {
            this.platform.getLogger().warning("Failed to get skin hash for " + event.getPlayer().getName() + ": " + e.getMessage());
        }
        PlayerLoginRequest request = new PlayerLoginRequest(event.getPlayer().getUniqueId().toString(), event.getPlayer().getName(), event.getPlayer().getSocketAddress().toString(), skinHash, null, this.platform.getServerName());
        ((CompletableFuture)this.httpClient.playerLogin(request).thenAccept(response -> {
            if (response.hasActiveMute()) {
                this.cache.cacheMute(event.getPlayer().getUniqueId(), response.getActiveMute());
            }
            if (response.hasNotifications()) {
                for (Map<String, Object> notificationData : response.getPendingNotifications()) {
                    SyncResponse.PlayerNotification notification = this.mapToPlayerNotification(notificationData);
                    if (notification == null) continue;
                    this.syncService.deliverLoginNotification(event.getPlayer().getUniqueId(), notification);
                }
            }
        })).exceptionally(throwable -> {
            this.platform.getLogger().severe("Failed to cache mute for " + event.getPlayer().getName() + ": " + throwable.getMessage());
            return null;
        });
        this.syncService.deliverPendingNotifications(event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onPlayerDisconnect(PlayerDisconnectEvent event) {
        PlayerDisconnectRequest request = new PlayerDisconnectRequest(event.getPlayer().getUniqueId().toString());
        this.httpClient.playerDisconnect(request);
        this.cache.removePlayer(event.getPlayer().getUniqueId());
        this.chatMessageCache.removePlayer(event.getPlayer().getUniqueId().toString());
    }

    @EventHandler(priority=64)
    public void onChat(ChatEvent event) {
        if (event.isCommand() || event.getSender() == null) {
            return;
        }
        ProxiedPlayer sender = (ProxiedPlayer)event.getSender();
        String serverName = sender.getServer() != null ? sender.getServer().getInfo().getName() : "unknown";
        this.chatMessageCache.addMessage(serverName, sender.getUniqueId().toString(), sender.getName(), event.getMessage());
        if (this.cache.isMuted(sender.getUniqueId())) {
            event.setCancelled(true);
            Cache.CachedPlayerData data = this.cache.getCache().get(sender.getUniqueId());
            if (data != null) {
                String muteMessage = data.getSimpleMute() != null ? PunishmentMessages.formatMuteMessage(data.getSimpleMute(), this.localeManager, PunishmentMessages.MessageContext.CHAT) : (data.getMute() != null ? this.formatMuteMessage(data.getMute()) : "\u00a7cYou are muted!");
                String formattedMessage = muteMessage.replace("\\n", "\n").replace("\\\\n", "\n");
                sender.sendMessage((BaseComponent)new TextComponent(formattedMessage));
            }
        }
    }

    private String formatMuteMessage(Punishment mute) {
        String reason = mute.getReason() != null ? mute.getReason() : "No reason provided";
        StringBuilder message = new StringBuilder();
        message.append(ChatColor.RED).append("You are muted!\n");
        message.append(ChatColor.GRAY).append("Reason: ").append(ChatColor.WHITE).append(reason);
        if (mute.getExpires() != null) {
            long timeLeft = mute.getExpires().getTime() - System.currentTimeMillis();
            if (timeLeft > 0L) {
                String timeString = PunishmentMessages.formatDuration(timeLeft);
                message.append("\n").append(ChatColor.GRAY).append("Time remaining: ").append(ChatColor.WHITE).append(timeString);
            }
        } else {
            message.append("\n").append(ChatColor.DARK_RED).append("This mute is permanent.");
        }
        return message.toString();
    }

    public Cache getPunishmentCache() {
        return this.cache;
    }

    public ChatMessageCache getChatMessageCache() {
        return this.chatMessageCache;
    }

    private void acknowledgeBanEnforcement(SimplePunishment ban, String playerUuid) {
        try {
            PunishmentAcknowledgeRequest request = new PunishmentAcknowledgeRequest(ban.getId(), playerUuid, Instant.now().toString(), true, null);
            ((CompletableFuture)this.httpClient.acknowledgePunishment(request).thenAccept(response -> this.platform.getLogger().info("Successfully acknowledged ban enforcement for punishment " + ban.getId()))).exceptionally(throwable -> {
                this.platform.getLogger().severe("Failed to acknowledge ban enforcement for punishment " + ban.getId() + ": " + throwable.getMessage());
                return null;
            });
        }
        catch (Exception e) {
            this.platform.getLogger().severe("Error acknowledging ban enforcement for punishment " + ban.getId() + ": " + e.getMessage());
        }
    }

    private SyncResponse.PlayerNotification mapToPlayerNotification(Map<String, Object> data) {
        try {
            SyncResponse.PlayerNotification notification = new SyncResponse.PlayerNotification();
            notification.setId((String)data.get("id"));
            notification.setMessage((String)data.get("message"));
            notification.setType((String)data.get("type"));
            if (data.get("timestamp") instanceof Number) {
                notification.setTimestamp(((Number)data.get("timestamp")).longValue());
            }
            notification.setTargetPlayerUuid((String)data.get("targetPlayerUuid"));
            Object nestedData = data.get("data");
            if (nestedData instanceof Map) {
                Map dataMap = (Map)nestedData;
                notification.setData(dataMap);
            }
            return notification;
        }
        catch (Exception e) {
            this.platform.getLogger().warning("Failed to convert notification data: " + e.getMessage());
            return null;
        }
    }

    @Generated
    public BungeeListener(BungeePlatform platform, Cache cache, ModlHttpClient httpClient, ChatMessageCache chatMessageCache, SyncService syncService, String panelUrl, LocaleManager localeManager) {
        this.platform = platform;
        this.cache = cache;
        this.httpClient = httpClient;
        this.chatMessageCache = chatMessageCache;
        this.syncService = syncService;
        this.panelUrl = panelUrl;
        this.localeManager = localeManager;
    }
}

