/*
 * Decompiled with CFR 0.152.
 */
package gg.modl.minecraft.bungee;

import co.aikar.commands.BungeeCommandManager;
import co.aikar.commands.CommandManager;
import dev.simplix.cirrus.player.CirrusPlayerWrapper;
import gg.modl.minecraft.api.AbstractPlayer;
import gg.modl.minecraft.core.Platform;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import lombok.Generated;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.chat.ComponentSerializer;
import org.jetbrains.annotations.NotNull;

public class BungeePlatform
implements Platform {
    private final BungeeCommandManager commandManager;
    private final Logger logger;

    @Override
    public void broadcast(String string) {
        TextComponent message = new TextComponent(ChatColor.translateAlternateColorCodes((char)'&', (String)string));
        ProxyServer.getInstance().broadcast((BaseComponent)message);
    }

    @Override
    public void staffBroadcast(String string) {
        TextComponent message = new TextComponent(ChatColor.translateAlternateColorCodes((char)'&', (String)string));
        ProxyServer.getInstance().getPlayers().stream().filter(player -> player.hasPermission("modl.staff")).forEach(player -> player.sendMessage((BaseComponent)message));
    }

    @Override
    public void disconnect(UUID uuid, String message) {
        ProxiedPlayer player = ProxyServer.getInstance().getPlayer(uuid);
        if (player != null && player.isConnected()) {
            player.disconnect((BaseComponent)new TextComponent(ChatColor.translateAlternateColorCodes((char)'&', (String)message)));
        }
    }

    @Override
    public void sendMessage(UUID uuid, String message) {
        ProxiedPlayer player = ProxyServer.getInstance().getPlayer(uuid);
        if (player != null && player.isConnected()) {
            String formattedMessage = message.replace("\\n", "\n").replace("\\\\n", "\n");
            player.sendMessage(formattedMessage);
        }
    }

    @Override
    public void sendJsonMessage(UUID uuid, String jsonMessage) {
        ProxiedPlayer player = ProxyServer.getInstance().getPlayer(uuid);
        if (player != null && player.isConnected()) {
            player.sendMessage(ComponentSerializer.parse((String)jsonMessage));
        }
    }

    @Override
    public boolean isOnline(UUID uuid) {
        ProxiedPlayer player = ProxyServer.getInstance().getPlayer(uuid);
        return player != null && player.isConnected();
    }

    @Override
    @NotNull
    public CommandManager<?, ?, ?, ?, ?, ?> getCommandManager() {
        return this.commandManager;
    }

    @Override
    public AbstractPlayer getAbstractPlayer(UUID uuid, boolean queryMojang) {
        ProxiedPlayer player = ProxyServer.getInstance().getPlayer(uuid);
        if (player != null) {
            String ipAddress = null;
            if (player.getSocketAddress() instanceof InetSocketAddress) {
                ipAddress = ((InetSocketAddress)player.getSocketAddress()).getAddress().getHostAddress();
            }
            return new AbstractPlayer(uuid, player.getName(), player.isConnected(), ipAddress);
        }
        return null;
    }

    @Override
    public AbstractPlayer getAbstractPlayer(String username, boolean queryMojang) {
        ProxiedPlayer player = ProxyServer.getInstance().getPlayer(username);
        if (player != null) {
            String ipAddress = null;
            if (player.getSocketAddress() instanceof InetSocketAddress) {
                ipAddress = ((InetSocketAddress)player.getSocketAddress()).getAddress().getHostAddress();
            }
            return new AbstractPlayer(player.getUniqueId(), player.getName(), player.isConnected(), ipAddress);
        }
        return null;
    }

    @Override
    public CirrusPlayerWrapper getPlayerWrapper(UUID uuid) {
        return null;
    }

    @Override
    public Collection<AbstractPlayer> getOnlinePlayers() {
        return ProxyServer.getInstance().getPlayers().stream().map(player -> {
            String ipAddress = null;
            if (player.getSocketAddress() instanceof InetSocketAddress) {
                ipAddress = ((InetSocketAddress)player.getSocketAddress()).getAddress().getHostAddress();
            }
            return new AbstractPlayer(player.getUniqueId(), player.getName(), player.isConnected(), ipAddress);
        }).collect(Collectors.toList());
    }

    @Override
    public AbstractPlayer getPlayer(UUID uuid) {
        return this.getAbstractPlayer(uuid, false);
    }

    @Override
    public int getMaxPlayers() {
        return ProxyServer.getInstance().getConfig().getPlayerLimit();
    }

    @Override
    public String getServerVersion() {
        return ProxyServer.getInstance().getVersion();
    }

    @Override
    public void runOnMainThread(Runnable task) {
        ProxyServer.getInstance().getScheduler().schedule(ProxyServer.getInstance().getPluginManager().getPlugin("modl"), task, 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void kickPlayer(AbstractPlayer player, String reason) {
        ProxiedPlayer bungeePlayer = ProxyServer.getInstance().getPlayer(player.getUuid());
        if (bungeePlayer != null && bungeePlayer.isConnected()) {
            String formattedReason = reason.replace("\\n", "\n").replace("\\\\n", "\n");
            bungeePlayer.disconnect((BaseComponent)new TextComponent(formattedReason));
        }
    }

    @Override
    public String getServerName() {
        return "bungee-proxy";
    }

    public Logger getLogger() {
        return this.logger;
    }

    @Generated
    public BungeePlatform(BungeeCommandManager commandManager, Logger logger) {
        this.commandManager = commandManager;
        this.logger = logger;
    }
}

