/*
 * Decompiled with CFR 0.152.
 */
package gg.modl.minecraft.bungee;

import co.aikar.commands.BungeeCommandManager;
import gg.modl.minecraft.bungee.BungeeCommandRegister;
import gg.modl.minecraft.bungee.BungeeListener;
import gg.modl.minecraft.bungee.BungeePlatform;
import gg.modl.minecraft.core.HttpManager;
import gg.modl.minecraft.core.PluginLoader;
import gg.modl.minecraft.core.service.ChatMessageCache;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import lombok.Generated;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public class BungeePlugin
extends Plugin {
    private Configuration configuration;
    private PluginLoader loader;

    public synchronized void onEnable() {
        this.loadConfig();
        this.createLocaleFiles();
        String apiUrl = this.configuration.getString("api.url");
        if ("https://yourserver.modl.gg".equals(apiUrl)) {
            this.getLogger().severe("===============================================");
            this.getLogger().severe("MODL CONFIGURATION ERROR");
            this.getLogger().severe("===============================================");
            this.getLogger().severe("You must configure your API URL in config.yml!");
            this.getLogger().severe("Please set 'api.url' to your actual MODL panel URL.");
            this.getLogger().severe("Example: https://yourserver.modl.gg");
            this.getLogger().severe("Plugin will now disable itself.");
            this.getLogger().severe("===============================================");
            return;
        }
        HttpManager httpManager = new HttpManager(this.configuration.getString("api.key"), apiUrl, this.configuration.getBoolean("api.debug", false));
        BungeeCommandManager commandManager = new BungeeCommandManager(this);
        BungeePlatform platform = new BungeePlatform(commandManager, this.getLogger());
        ChatMessageCache chatMessageCache = new ChatMessageCache();
        int syncPollingRate = Math.max(1, this.configuration.getInt("sync.polling_rate", 2));
        this.loader = new PluginLoader(platform, new BungeeCommandRegister(commandManager), this.getDataFolder().toPath(), chatMessageCache, httpManager, syncPollingRate);
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new BungeeListener(platform, this.loader.getCache(), this.loader.getHttpClient(), chatMessageCache, this.loader.getSyncService(), httpManager.getPanelUrl(), this.loader.getLocaleManager()));
    }

    public synchronized void onDisable() {
        if (this.loader != null) {
            this.loader.shutdown();
        }
    }

    private void loadConfig() {
        File file;
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdir();
        }
        if (!(file = new File(this.getDataFolder(), "config.yml")).exists()) {
            try {
                file.createNewFile();
                Configuration defaultConfig = new Configuration();
                defaultConfig.set("api.key", (Object)"your-api-key-here");
                defaultConfig.set("api.url", (Object)"https://yourserver.modl.gg");
                defaultConfig.set("server.name", (Object)"Server 1");
                defaultConfig.set("server.query_mojang", (Object)false);
                defaultConfig.set("sync.polling_rate", (Object)2);
                defaultConfig.set("api.debug", (Object)false);
                ConfigurationProvider.getProvider(YamlConfiguration.class).save(defaultConfig, file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            this.configuration = ConfigurationProvider.getProvider(YamlConfiguration.class).load(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createLocaleFiles() {
        block11: {
            try {
                File enUsFile;
                File localeDir = new File(this.getDataFolder(), "locale");
                if (!localeDir.exists()) {
                    localeDir.mkdirs();
                    this.getLogger().info("Created locale directory at: " + localeDir.getPath());
                }
                if ((enUsFile = new File(localeDir, "en_US.yml")).exists()) break block11;
                try (InputStream defaultLocale = this.getResourceAsStream("locale/en_US.yml");){
                    if (defaultLocale != null) {
                        Files.copy(defaultLocale, enUsFile.toPath(), new CopyOption[0]);
                        this.getLogger().info("Created default locale file at: " + enUsFile.getPath());
                    } else {
                        this.getLogger().warning("Default locale resource not found in JAR");
                    }
                }
            }
            catch (IOException e) {
                this.getLogger().severe("Failed to create locale files: " + e.getMessage());
            }
        }
    }

    @Generated
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public PluginLoader getLoader() {
        return this.loader;
    }
}

