/*
 * Decompiled with CFR 0.152.
 */
package gg.modl.minecraft.core;

import co.aikar.commands.CommandManager;
import gg.modl.minecraft.api.AbstractPlayer;
import gg.modl.minecraft.api.Account;
import gg.modl.minecraft.api.http.ModlHttpClient;
import gg.modl.minecraft.api.http.request.PlayerNameRequest;
import gg.modl.minecraft.api.http.response.PlayerNameResponse;
import gg.modl.minecraft.core.HttpManager;
import gg.modl.minecraft.core.Platform;
import gg.modl.minecraft.core.PlatformCommandRegister;
import gg.modl.minecraft.core.impl.cache.Cache;
import gg.modl.minecraft.core.impl.cache.LoginCache;
import gg.modl.minecraft.core.impl.commands.ModlReloadCommand;
import gg.modl.minecraft.core.impl.commands.PlayerLookupCommand;
import gg.modl.minecraft.core.impl.commands.TicketCommands;
import gg.modl.minecraft.core.impl.commands.player.IAmMutedCommand;
import gg.modl.minecraft.core.impl.commands.punishments.BanCommand;
import gg.modl.minecraft.core.impl.commands.punishments.BlacklistCommand;
import gg.modl.minecraft.core.impl.commands.punishments.KickCommand;
import gg.modl.minecraft.core.impl.commands.punishments.MuteCommand;
import gg.modl.minecraft.core.impl.commands.punishments.PardonCommand;
import gg.modl.minecraft.core.impl.commands.punishments.PunishCommand;
import gg.modl.minecraft.core.impl.commands.punishments.WarnCommand;
import gg.modl.minecraft.core.locale.LocaleManager;
import gg.modl.minecraft.core.service.ChatMessageCache;
import gg.modl.minecraft.core.sync.SyncService;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.logging.Logger;
import lombok.Generated;

public class PluginLoader {
    private final ModlHttpClient httpClient;
    private final Cache cache;
    private final SyncService syncService;
    private final ChatMessageCache chatMessageCache;
    private final LocaleManager localeManager;
    private final LoginCache loginCache;

    public PluginLoader(Platform platform, PlatformCommandRegister commandRegister, Path dataDirectory, ChatMessageCache chatMessageCache) {
        throw new UnsupportedOperationException("This constructor is deprecated. Use the HttpManager overload instead.");
    }

    public PluginLoader(Platform platform, PlatformCommandRegister commandRegister, Path dataDirectory, ChatMessageCache chatMessageCache, HttpManager httpManager, int syncPollingRateSeconds) {
        this.chatMessageCache = chatMessageCache;
        this.cache = new Cache();
        this.loginCache = new LoginCache();
        this.httpClient = httpManager.getHttpClient();
        this.localeManager = new LocaleManager();
        Logger logger = Logger.getLogger("MODL-" + platform.getClass().getSimpleName());
        Path localeFile = dataDirectory.resolve("locale").resolve("en_US.yml");
        if (Files.exists(localeFile, new LinkOption[0])) {
            logger.info("Loading locale from external file: " + String.valueOf(localeFile));
            this.localeManager.loadFromFile(localeFile);
        }
        this.syncService = new SyncService(platform, this.httpClient, this.cache, logger, this.localeManager, httpManager.getApiUrl(), httpManager.getApiKey(), syncPollingRateSeconds);
        logger.info("MODL Configuration:");
        logger.info("  API URL: " + httpManager.getApiUrl());
        logger.info("  API Key: " + (String)(httpManager.getApiKey().length() > 8 ? httpManager.getApiKey().substring(0, 8) + "..." : "***"));
        logger.info("  Debug Mode: " + httpManager.isDebugHttp());
        this.syncService.start();
        CommandManager<?, ?, ?, ?, ?, ?> commandManager = platform.getCommandManager();
        commandManager.enableUnstableAPI("help");
        commandManager.getCommandContexts().registerContext(AbstractPlayer.class, c -> PluginLoader.fetchPlayer(c.popFirstArg(), platform, this.httpClient));
        commandManager.getCommandContexts().registerContext(Account.class, c -> PluginLoader.fetchPlayer(c.popFirstArg(), this.httpClient));
        PlayerLookupCommand playerLookupCommand = new PlayerLookupCommand(httpManager.getHttpClient(), platform, this.cache, this.localeManager, httpManager.getPanelUrl());
        commandManager.registerCommand(playerLookupCommand);
        PunishCommand punishCommand = new PunishCommand(httpManager.getHttpClient(), platform, this.cache, this.localeManager);
        commandManager.registerCommand(punishCommand);
        commandManager.getCommandCompletions().registerCompletion("punishment-types", c -> punishCommand.getPunishmentTypeNames());
        punishCommand.initializePunishmentTypes();
        playerLookupCommand.initializePunishmentTypes();
        commandManager.registerCommand(new ModlReloadCommand(httpManager.getHttpClient(), platform, this.cache, this.localeManager, punishCommand, playerLookupCommand));
        commandManager.registerCommand(new BanCommand(httpManager.getHttpClient(), platform, this.cache, this.localeManager));
        commandManager.registerCommand(new MuteCommand(httpManager.getHttpClient(), platform, this.cache, this.localeManager));
        commandManager.registerCommand(new KickCommand(httpManager.getHttpClient(), platform, this.cache, this.localeManager));
        commandManager.registerCommand(new BlacklistCommand(httpManager.getHttpClient(), platform, this.cache, this.localeManager));
        commandManager.registerCommand(new PardonCommand(httpManager.getHttpClient(), platform, this.cache, this.localeManager));
        commandManager.registerCommand(new WarnCommand(httpManager.getHttpClient(), platform, this.cache, this.localeManager));
        commandManager.registerCommand(new IAmMutedCommand(platform, this.cache, this.localeManager));
        commandManager.registerCommand(new TicketCommands(platform, httpManager.getHttpClient(), httpManager.getPanelUrl(), this.localeManager, chatMessageCache));
    }

    public static AbstractPlayer fetchPlayer(String target, Platform platform, ModlHttpClient httpClient) {
        AbstractPlayer player = platform.getAbstractPlayer(target, false);
        if (player != null) {
            return player;
        }
        Account account = httpClient.getPlayer(new PlayerNameRequest(target)).join().getPlayer();
        if (account != null) {
            return new AbstractPlayer(account.getMinecraftUuid(), "test", false);
        }
        return null;
    }

    public static Account fetchPlayer(String target, ModlHttpClient httpClient) {
        try {
            PlayerNameResponse response = httpClient.getPlayer(new PlayerNameRequest(target)).join();
            if (response != null && response.isSuccess()) {
                return response.getPlayer();
            }
        }
        catch (Exception e) {
            System.err.println("[MODL] Error fetching player by name '" + target + "': " + e.getMessage());
        }
        return null;
    }

    public void shutdown() {
        if (this.syncService != null) {
            this.syncService.stop();
        }
        if (this.loginCache != null) {
            this.loginCache.shutdown();
        }
    }

    @Generated
    public ModlHttpClient getHttpClient() {
        return this.httpClient;
    }

    @Generated
    public Cache getCache() {
        return this.cache;
    }

    @Generated
    public SyncService getSyncService() {
        return this.syncService;
    }

    @Generated
    public ChatMessageCache getChatMessageCache() {
        return this.chatMessageCache;
    }

    @Generated
    public LocaleManager getLocaleManager() {
        return this.localeManager;
    }

    @Generated
    public LoginCache getLoginCache() {
        return this.loginCache;
    }
}

