/*
 * Decompiled with CFR 0.152.
 */
package gg.modl.minecraft.core.impl.cache;

import gg.modl.minecraft.api.Punishment;
import gg.modl.minecraft.api.SimplePunishment;
import gg.modl.minecraft.api.http.response.SyncResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;

public class Cache {
    private final Map<UUID, CachedPlayerData> cache = new ConcurrentHashMap<UUID, CachedPlayerData>();
    private final Map<UUID, StaffPermissions> staffPermissionsCache = new ConcurrentHashMap<UUID, StaffPermissions>();
    private final Map<UUID, List<PendingNotification>> pendingNotificationsCache = new ConcurrentHashMap<UUID, List<PendingNotification>>();

    public void cacheMute(UUID playerUuid, Punishment mute) {
        this.cache.computeIfAbsent(playerUuid, k -> new CachedPlayerData()).setMute(mute);
    }

    public void cacheMute(UUID playerUuid, SimplePunishment mute) {
        this.cache.computeIfAbsent(playerUuid, k -> new CachedPlayerData()).setSimpleMute(mute);
    }

    public void cacheBan(UUID playerUuid, Punishment ban) {
        this.cache.computeIfAbsent(playerUuid, k -> new CachedPlayerData()).setBan(ban);
    }

    public void cacheBan(UUID playerUuid, SimplePunishment ban) {
        this.cache.computeIfAbsent(playerUuid, k -> new CachedPlayerData()).setSimpleBan(ban);
    }

    public boolean isMuted(UUID playerUuid) {
        CachedPlayerData data = this.cache.get(playerUuid);
        if (data == null) {
            return false;
        }
        if (data.getSimpleMute() != null) {
            SimplePunishment mute = data.getSimpleMute();
            if (mute.isExpired()) {
                this.removeMute(playerUuid);
                return false;
            }
            return true;
        }
        if (data.getMute() != null) {
            Punishment mute = data.getMute();
            if (mute.getExpires() != null && mute.getExpires().before(new Date())) {
                this.removeMute(playerUuid);
                return false;
            }
            return true;
        }
        return false;
    }

    public Punishment getMute(UUID playerUuid) {
        CachedPlayerData data = this.cache.get(playerUuid);
        return data != null ? data.getMute() : null;
    }

    public void removeMute(UUID playerUuid) {
        CachedPlayerData data = this.cache.get(playerUuid);
        if (data != null) {
            data.setMute(null);
            data.setSimpleMute(null);
            if (data.isEmpty()) {
                this.cache.remove(playerUuid);
            }
        }
    }

    public boolean isBanned(UUID playerUuid) {
        CachedPlayerData data = this.cache.get(playerUuid);
        if (data == null) {
            return false;
        }
        if (data.getSimpleBan() != null) {
            SimplePunishment ban = data.getSimpleBan();
            if (ban.isExpired()) {
                this.removeBan(playerUuid);
                return false;
            }
            return true;
        }
        if (data.getBan() != null) {
            Punishment ban = data.getBan();
            if (ban.getExpires() != null && ban.getExpires().before(new Date())) {
                this.removeBan(playerUuid);
                return false;
            }
            return true;
        }
        return false;
    }

    public Punishment getBan(UUID playerUuid) {
        CachedPlayerData data = this.cache.get(playerUuid);
        return data != null ? data.getBan() : null;
    }

    public void removeBan(UUID playerUuid) {
        CachedPlayerData data = this.cache.get(playerUuid);
        if (data != null) {
            data.setBan(null);
            data.setSimpleBan(null);
            if (data.isEmpty()) {
                this.cache.remove(playerUuid);
            }
        }
    }

    public void removePlayer(UUID playerUuid) {
        this.cache.remove(playerUuid);
    }

    public void cacheStaffMember(UUID playerUuid, SyncResponse.ActiveStaffMember staffMember) {
        this.cache.computeIfAbsent(playerUuid, k -> new CachedPlayerData()).setStaffMember(staffMember);
    }

    public SyncResponse.ActiveStaffMember getStaffMember(UUID playerUuid) {
        CachedPlayerData data = this.cache.get(playerUuid);
        return data != null ? data.getStaffMember() : null;
    }

    public boolean isStaffMember(UUID playerUuid) {
        CachedPlayerData data = this.cache.get(playerUuid);
        return data != null && data.getStaffMember() != null;
    }

    public boolean hasPermission(UUID playerUuid, String permission) {
        StaffPermissions staffPerms = this.staffPermissionsCache.get(playerUuid);
        if (staffPerms != null) {
            return staffPerms.getPermissions().contains(permission);
        }
        SyncResponse.ActiveStaffMember staffMember = this.getStaffMember(playerUuid);
        return staffMember != null && staffMember.getPermissions().contains(permission);
    }

    public void cacheStaffPermissions(UUID playerUuid, String staffRole, List<String> permissions) {
        this.staffPermissionsCache.put(playerUuid, new StaffPermissions(staffRole, permissions));
    }

    public void clearStaffPermissions() {
        this.staffPermissionsCache.clear();
    }

    public boolean isStaffMemberByPermissions(UUID playerUuid) {
        return this.staffPermissionsCache.containsKey(playerUuid);
    }

    public void cacheNotification(UUID playerUuid, SyncResponse.PlayerNotification notification) {
        PendingNotification pending = new PendingNotification(notification.getId(), notification.getMessage(), notification.getType(), notification.getTimestamp(), System.currentTimeMillis(), notification.getData());
        this.pendingNotificationsCache.computeIfAbsent(playerUuid, k -> new ArrayList()).add(pending);
    }

    public List<PendingNotification> getPendingNotifications(UUID playerUuid) {
        return this.pendingNotificationsCache.getOrDefault(playerUuid, new ArrayList());
    }

    public boolean removeNotification(UUID playerUuid, String notificationId) {
        List<PendingNotification> notifications = this.pendingNotificationsCache.get(playerUuid);
        if (notifications != null) {
            boolean removed = notifications.removeIf(n -> n.getId().equals(notificationId));
            if (notifications.isEmpty()) {
                this.pendingNotificationsCache.remove(playerUuid);
            }
            return removed;
        }
        return false;
    }

    public List<PendingNotification> clearNotifications(UUID playerUuid) {
        return this.pendingNotificationsCache.remove(playerUuid);
    }

    public int getNotificationCount(UUID playerUuid) {
        List<PendingNotification> notifications = this.pendingNotificationsCache.get(playerUuid);
        return notifications != null ? notifications.size() : 0;
    }

    public boolean hasPendingNotifications(UUID playerUuid) {
        return this.getNotificationCount(playerUuid) > 0;
    }

    public void clear() {
        this.cache.clear();
        this.pendingNotificationsCache.clear();
    }

    public int size() {
        return this.cache.size();
    }

    public Map<UUID, CachedPlayerData> getCache() {
        return this.cache;
    }

    public int getStaffCount() {
        return this.staffPermissionsCache.size();
    }

    public int getCachedPlayerCount() {
        return this.cache.size();
    }

    public static class CachedPlayerData {
        private Punishment mute;
        private SimplePunishment simpleMute;
        private Punishment ban;
        private SimplePunishment simpleBan;
        private SyncResponse.ActiveStaffMember staffMember;

        public boolean isEmpty() {
            return this.mute == null && this.simpleMute == null && this.ban == null && this.simpleBan == null && this.staffMember == null;
        }

        @Generated
        public Punishment getMute() {
            return this.mute;
        }

        @Generated
        public SimplePunishment getSimpleMute() {
            return this.simpleMute;
        }

        @Generated
        public Punishment getBan() {
            return this.ban;
        }

        @Generated
        public SimplePunishment getSimpleBan() {
            return this.simpleBan;
        }

        @Generated
        public SyncResponse.ActiveStaffMember getStaffMember() {
            return this.staffMember;
        }

        @Generated
        public void setMute(Punishment mute) {
            this.mute = mute;
        }

        @Generated
        public void setSimpleMute(SimplePunishment simpleMute) {
            this.simpleMute = simpleMute;
        }

        @Generated
        public void setBan(Punishment ban) {
            this.ban = ban;
        }

        @Generated
        public void setSimpleBan(SimplePunishment simpleBan) {
            this.simpleBan = simpleBan;
        }

        @Generated
        public void setStaffMember(SyncResponse.ActiveStaffMember staffMember) {
            this.staffMember = staffMember;
        }
    }

    public static class StaffPermissions {
        private final String staffRole;
        private final List<String> permissions;

        public StaffPermissions(String staffRole, List<String> permissions) {
            this.staffRole = staffRole;
            this.permissions = permissions != null ? permissions : List.of();
        }

        @Generated
        public String getStaffRole() {
            return this.staffRole;
        }

        @Generated
        public List<String> getPermissions() {
            return this.permissions;
        }
    }

    public static class PendingNotification {
        private final String id;
        private final String message;
        private final String type;
        private final Long timestamp;
        private final long cachedTime;
        private final Map<String, Object> data;

        public PendingNotification(String id, String message, String type, Long timestamp, long cachedTime, Map<String, Object> data) {
            this.id = id;
            this.message = message;
            this.type = type;
            this.timestamp = timestamp;
            this.cachedTime = cachedTime;
            this.data = data != null ? new HashMap<String, Object>(data) : new HashMap();
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.cachedTime > 86400000L;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public Long getTimestamp() {
            return this.timestamp;
        }

        @Generated
        public long getCachedTime() {
            return this.cachedTime;
        }

        @Generated
        public Map<String, Object> getData() {
            return this.data;
        }
    }
}

