/*
 * Decompiled with CFR 0.152.
 */
package gg.modl.minecraft.core.impl.cache;

import com.google.gson.JsonObject;
import gg.modl.minecraft.api.http.response.PlayerLoginResponse;
import java.time.Instant;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import lombok.Generated;

public class LoginCache {
    private static final Logger logger = Logger.getLogger(LoginCache.class.getName());
    private final ConcurrentHashMap<UUID, CachedLoginResult> loginResultCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<UUID, PreLoginResult> preLoginResults = new ConcurrentHashMap();
    private final ScheduledExecutorService cleanupExecutor;
    private final int cacheExpirySeconds;

    public LoginCache() {
        this(30);
    }

    public LoginCache(int cacheExpirySeconds) {
        this.cacheExpirySeconds = cacheExpirySeconds;
        this.cleanupExecutor = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r, "modl-login-cache-cleanup");
            t.setDaemon(true);
            return t;
        });
        this.cleanupExecutor.scheduleAtFixedRate(this::cleanup, 30L, 30L, TimeUnit.SECONDS);
    }

    public CachedLoginResult getCachedLoginResult(UUID playerUuid) {
        CachedLoginResult cached = this.loginResultCache.get(playerUuid);
        if (cached != null && !cached.isExpired()) {
            logger.fine("Using cached login result for " + String.valueOf(playerUuid));
            return cached;
        }
        return null;
    }

    public void cacheLoginResult(UUID playerUuid, PlayerLoginResponse response, JsonObject ipInfo, String skinHash) {
        CachedLoginResult cached = new CachedLoginResult(response, ipInfo, skinHash, Instant.now());
        this.loginResultCache.put(playerUuid, cached);
        logger.fine("Cached login result for " + String.valueOf(playerUuid));
    }

    public void storePreLoginResult(UUID playerUuid, PreLoginResult result) {
        this.preLoginResults.put(playerUuid, result);
        logger.fine("Stored pre-login result for " + String.valueOf(playerUuid));
    }

    public PreLoginResult getAndRemovePreLoginResult(UUID playerUuid) {
        PreLoginResult result = this.preLoginResults.remove(playerUuid);
        if (result != null) {
            logger.fine("Retrieved pre-login result for " + String.valueOf(playerUuid));
        }
        return result;
    }

    private void cleanup() {
        int loginResultsBefore = this.loginResultCache.size();
        this.loginResultCache.entrySet().removeIf(entry -> ((CachedLoginResult)entry.getValue()).isExpired());
        int removedLoginResults = loginResultsBefore - this.loginResultCache.size();
        Instant cutoff = Instant.now().minusSeconds(60L);
        int preLoginResultsBefore = this.preLoginResults.size();
        this.preLoginResults.entrySet().removeIf(entry -> ((PreLoginResult)entry.getValue()).getTimestamp().isBefore(cutoff));
        int removedPreLoginResults = preLoginResultsBefore - this.preLoginResults.size();
        if (removedLoginResults > 0 || removedPreLoginResults > 0) {
            logger.fine(String.format("Cleaned up %d expired login results and %d old pre-login results", removedLoginResults, removedPreLoginResults));
        }
    }

    public void shutdown() {
        this.cleanupExecutor.shutdown();
        try {
            if (!this.cleanupExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.cleanupExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.cleanupExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
        this.loginResultCache.clear();
        this.preLoginResults.clear();
        logger.info("Login cache shutdown complete");
    }

    @Generated
    public LoginCache(ScheduledExecutorService cleanupExecutor, int cacheExpirySeconds) {
        this.cleanupExecutor = cleanupExecutor;
        this.cacheExpirySeconds = cacheExpirySeconds;
    }

    public static class CachedLoginResult {
        private final PlayerLoginResponse response;
        private final JsonObject ipInfo;
        private final String skinHash;
        private final Instant timestamp;
        private final int expirySeconds;

        public CachedLoginResult(PlayerLoginResponse response, JsonObject ipInfo, String skinHash, Instant timestamp) {
            this.response = response;
            this.ipInfo = ipInfo;
            this.skinHash = skinHash;
            this.timestamp = timestamp;
            this.expirySeconds = 30;
        }

        public boolean isExpired() {
            return Instant.now().isAfter(this.timestamp.plusSeconds(this.expirySeconds));
        }

        @Generated
        public PlayerLoginResponse getResponse() {
            return this.response;
        }

        @Generated
        public JsonObject getIpInfo() {
            return this.ipInfo;
        }

        @Generated
        public String getSkinHash() {
            return this.skinHash;
        }

        @Generated
        public Instant getTimestamp() {
            return this.timestamp;
        }

        @Generated
        public int getExpirySeconds() {
            return this.expirySeconds;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CachedLoginResult)) {
                return false;
            }
            CachedLoginResult other = (CachedLoginResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getExpirySeconds() != other.getExpirySeconds()) {
                return false;
            }
            PlayerLoginResponse this$response = this.getResponse();
            PlayerLoginResponse other$response = other.getResponse();
            if (this$response == null ? other$response != null : !((Object)this$response).equals(other$response)) {
                return false;
            }
            JsonObject this$ipInfo = this.getIpInfo();
            JsonObject other$ipInfo = other.getIpInfo();
            if (this$ipInfo == null ? other$ipInfo != null : !((Object)this$ipInfo).equals(other$ipInfo)) {
                return false;
            }
            String this$skinHash = this.getSkinHash();
            String other$skinHash = other.getSkinHash();
            if (this$skinHash == null ? other$skinHash != null : !this$skinHash.equals(other$skinHash)) {
                return false;
            }
            Instant this$timestamp = this.getTimestamp();
            Instant other$timestamp = other.getTimestamp();
            return !(this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CachedLoginResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getExpirySeconds();
            PlayerLoginResponse $response = this.getResponse();
            result = result * 59 + ($response == null ? 43 : ((Object)$response).hashCode());
            JsonObject $ipInfo = this.getIpInfo();
            result = result * 59 + ($ipInfo == null ? 43 : ((Object)$ipInfo).hashCode());
            String $skinHash = this.getSkinHash();
            result = result * 59 + ($skinHash == null ? 43 : $skinHash.hashCode());
            Instant $timestamp = this.getTimestamp();
            result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LoginCache.CachedLoginResult(response=" + String.valueOf(this.getResponse()) + ", ipInfo=" + String.valueOf(this.getIpInfo()) + ", skinHash=" + this.getSkinHash() + ", timestamp=" + String.valueOf(this.getTimestamp()) + ", expirySeconds=" + this.getExpirySeconds() + ")";
        }
    }

    public static class PreLoginResult {
        private final PlayerLoginResponse response;
        private final JsonObject ipInfo;
        private final String skinHash;
        private final Instant timestamp;
        private final Exception error;

        public PreLoginResult(PlayerLoginResponse response, JsonObject ipInfo, String skinHash) {
            this.response = response;
            this.ipInfo = ipInfo;
            this.skinHash = skinHash;
            this.timestamp = Instant.now();
            this.error = null;
        }

        public PreLoginResult(Exception error) {
            this.response = null;
            this.ipInfo = null;
            this.skinHash = null;
            this.timestamp = Instant.now();
            this.error = error;
        }

        public boolean hasError() {
            return this.error != null;
        }

        public boolean isSuccess() {
            return this.error == null && this.response != null;
        }

        @Generated
        public PlayerLoginResponse getResponse() {
            return this.response;
        }

        @Generated
        public JsonObject getIpInfo() {
            return this.ipInfo;
        }

        @Generated
        public String getSkinHash() {
            return this.skinHash;
        }

        @Generated
        public Instant getTimestamp() {
            return this.timestamp;
        }

        @Generated
        public Exception getError() {
            return this.error;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PreLoginResult)) {
                return false;
            }
            PreLoginResult other = (PreLoginResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            PlayerLoginResponse this$response = this.getResponse();
            PlayerLoginResponse other$response = other.getResponse();
            if (this$response == null ? other$response != null : !((Object)this$response).equals(other$response)) {
                return false;
            }
            JsonObject this$ipInfo = this.getIpInfo();
            JsonObject other$ipInfo = other.getIpInfo();
            if (this$ipInfo == null ? other$ipInfo != null : !((Object)this$ipInfo).equals(other$ipInfo)) {
                return false;
            }
            String this$skinHash = this.getSkinHash();
            String other$skinHash = other.getSkinHash();
            if (this$skinHash == null ? other$skinHash != null : !this$skinHash.equals(other$skinHash)) {
                return false;
            }
            Instant this$timestamp = this.getTimestamp();
            Instant other$timestamp = other.getTimestamp();
            if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
                return false;
            }
            Exception this$error = this.getError();
            Exception other$error = other.getError();
            return !(this$error == null ? other$error != null : !this$error.equals(other$error));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PreLoginResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            PlayerLoginResponse $response = this.getResponse();
            result = result * 59 + ($response == null ? 43 : ((Object)$response).hashCode());
            JsonObject $ipInfo = this.getIpInfo();
            result = result * 59 + ($ipInfo == null ? 43 : ((Object)$ipInfo).hashCode());
            String $skinHash = this.getSkinHash();
            result = result * 59 + ($skinHash == null ? 43 : $skinHash.hashCode());
            Instant $timestamp = this.getTimestamp();
            result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
            Exception $error = this.getError();
            result = result * 59 + ($error == null ? 43 : $error.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LoginCache.PreLoginResult(response=" + String.valueOf(this.getResponse()) + ", ipInfo=" + String.valueOf(this.getIpInfo()) + ", skinHash=" + this.getSkinHash() + ", timestamp=" + String.valueOf(this.getTimestamp()) + ", error=" + String.valueOf(this.getError()) + ")";
        }
    }
}

