/*
 * Decompiled with CFR 0.152.
 */
package gg.modl.minecraft.core.impl.commands;

import co.aikar.commands.BaseCommand;
import co.aikar.commands.CommandIssuer;
import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.Default;
import co.aikar.commands.annotation.Description;
import co.aikar.commands.annotation.Subcommand;
import co.aikar.commands.annotation.Syntax;
import gg.modl.minecraft.api.http.ModlHttpClient;
import gg.modl.minecraft.api.http.PanelUnavailableException;
import gg.modl.minecraft.api.http.response.StaffPermissionsResponse;
import gg.modl.minecraft.core.Platform;
import gg.modl.minecraft.core.impl.cache.Cache;
import gg.modl.minecraft.core.impl.commands.PlayerLookupCommand;
import gg.modl.minecraft.core.impl.commands.punishments.PunishCommand;
import gg.modl.minecraft.core.locale.LocaleManager;
import gg.modl.minecraft.core.util.PermissionUtil;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;

@CommandAlias(value="modl")
public class ModlReloadCommand
extends BaseCommand {
    private final ModlHttpClient httpClient;
    private final Platform platform;
    private final Cache cache;
    private final LocaleManager localeManager;
    private final PunishCommand punishCommand;
    private final PlayerLookupCommand playerLookupCommand;

    @Default
    @Description(value="Show available MODL commands")
    public void showHelp(CommandIssuer sender) {
        this.displayHelp(sender);
    }

    @Subcommand(value="help")
    @Description(value="Show available MODL commands")
    public void help(CommandIssuer sender) {
        this.displayHelp(sender);
    }

    private void displayHelp(CommandIssuer sender) {
        sender.sendMessage("\u00a76=== MODL Commands ===");
        sender.sendMessage("");
        sender.sendMessage("\u00a7e\u00a7lPunishment Commands:");
        sender.sendMessage("\u00a77/punish <player> <type> [reason]\u00a7f - Issue a punishment");
        sender.sendMessage("\u00a77/ban <player> [duration] [reason]\u00a7f - Ban a player");
        sender.sendMessage("\u00a77/mute <player> [duration] [reason]\u00a7f - Mute a player");
        sender.sendMessage("\u00a77/kick <player> [reason]\u00a7f - Kick a player");
        sender.sendMessage("\u00a77/blacklist <player> [reason]\u00a7f - Blacklist a player");
        sender.sendMessage("\u00a77/pardon <player> [type]\u00a7f - Remove a punishment");
        sender.sendMessage("\u00a77/unban <player>\u00a7f - Unban a player");
        sender.sendMessage("\u00a77/unmute <player>\u00a7f - Unmute a player");
        sender.sendMessage("");
        sender.sendMessage("\u00a7e\u00a7lInformation Commands:");
        sender.sendMessage("\u00a77/lookup <player>\u00a7f - View player information");
        sender.sendMessage("\u00a77/modl status\u00a7f - Show plugin status");
        sender.sendMessage("");
        sender.sendMessage("\u00a7e\u00a7lPlayer Commands:");
        sender.sendMessage("\u00a77/iammuted <player>\u00a7f - Tell someone you are muted");
        sender.sendMessage("\u00a77/report <player> <reason>\u00a7f - Report a player");
        sender.sendMessage("\u00a77/chatreport <messages> <reason>\u00a7f - Report chat messages");
        sender.sendMessage("\u00a77/apply\u00a7f - Apply for staff");
        sender.sendMessage("\u00a77/bugreport <description>\u00a7f - Report a bug");
        sender.sendMessage("\u00a77/support <message>\u00a7f - Contact support");
        sender.sendMessage("");
        sender.sendMessage("\u00a7e\u00a7lAdmin Commands:");
        sender.sendMessage("\u00a77/modl status\u00a7f - Check plugin status");
        sender.sendMessage("\u00a77/modl reload [component]\u00a7f - Reload plugin data");
        sender.sendMessage("\u00a77  Components: all, punishment-types, staff-permissions, locale");
        sender.sendMessage("");
        sender.sendMessage("\u00a76========================");
    }

    @Subcommand(value="reload")
    @Description(value="Reload all MODL data including punishment types, staff permissions, and locale files")
    @Syntax(value="reload [component]")
    public void reload(CommandIssuer sender, @Default(value="all") String component) {
        if (!PermissionUtil.hasAnyPermission(sender, this.cache, "admin.settings.view", "admin.settings.modify", "admin.reload")) {
            sender.sendMessage(this.localeManager.getMessage("general.no_permission"));
            return;
        }
        String validComponents = "all, punishment-types, staff-permissions, locale";
        switch (component.toLowerCase()) {
            case "all": {
                this.reloadAll(sender);
                break;
            }
            case "punishment-types": 
            case "punishments": 
            case "types": {
                this.reloadPunishmentTypes(sender);
                break;
            }
            case "staff-permissions": 
            case "staff": 
            case "permissions": {
                this.reloadStaffPermissions(sender);
                break;
            }
            case "locale": 
            case "locales": 
            case "messages": {
                this.reloadLocale(sender);
                break;
            }
            default: {
                sender.sendMessage(this.localeManager.getMessage("reload.invalid_component", Map.of("component", component, "valid", validComponents)));
            }
        }
    }

    @Subcommand(value="status")
    @Description(value="Show MODL plugin status and loaded data")
    public void status(CommandIssuer sender) {
        if (!PermissionUtil.hasAnyPermission(sender, this.cache, "admin.settings.view", "admin.status")) {
            sender.sendMessage(this.localeManager.getMessage("general.no_permission"));
            return;
        }
        sender.sendMessage("\u00a76=== MODL Plugin Status ===");
        int punishmentTypeCount = this.punishCommand.getPunishmentTypeNames().size();
        sender.sendMessage("\u00a7ePunishment Types: \u00a7f" + punishmentTypeCount + " loaded");
        int staffCount = this.cache.getStaffCount();
        sender.sendMessage("\u00a7eStaff Permissions: \u00a7f" + staffCount + " staff members cached");
        int onlinePlayersWithCache = this.cache.getCachedPlayerCount();
        sender.sendMessage("\u00a7eCached Players: \u00a7f" + onlinePlayersWithCache + " players with punishment data");
        String localeFile = this.localeManager.getCurrentLocale();
        sender.sendMessage("\u00a7eLocale: \u00a7f" + localeFile);
        sender.sendMessage("\u00a76========================");
    }

    private void reloadAll(CommandIssuer sender) {
        sender.sendMessage("\u00a76[MODL] \u00a7eStarting full reload...");
        AtomicInteger completed = new AtomicInteger(0);
        AtomicInteger total = new AtomicInteger(3);
        this.reloadPunishmentTypesAsync(sender, () -> {
            if (completed.incrementAndGet() == total.get()) {
                sender.sendMessage("\u00a76[MODL] \u00a7aFull reload completed successfully!");
            }
        });
        this.reloadStaffPermissionsAsync(sender, () -> {
            if (completed.incrementAndGet() == total.get()) {
                sender.sendMessage("\u00a76[MODL] \u00a7aFull reload completed successfully!");
            }
        });
        this.reloadLocaleSync(sender);
        if (completed.incrementAndGet() == total.get()) {
            sender.sendMessage("\u00a76[MODL] \u00a7aFull reload completed successfully!");
        }
    }

    private void reloadPunishmentTypes(CommandIssuer sender) {
        sender.sendMessage("\u00a76[MODL] \u00a7eReloading punishment types...");
        this.reloadPunishmentTypesAsync(sender, () -> sender.sendMessage("\u00a76[MODL] \u00a7aPunishment types reload completed!"));
    }

    private void reloadStaffPermissions(CommandIssuer sender) {
        sender.sendMessage("\u00a76[MODL] \u00a7eReloading staff permissions...");
        this.reloadStaffPermissionsAsync(sender, () -> sender.sendMessage("\u00a76[MODL] \u00a7aStaff permissions reload completed!"));
    }

    private void reloadLocale(CommandIssuer sender) {
        sender.sendMessage("\u00a76[MODL] \u00a7eReloading locale files...");
        this.reloadLocaleSync(sender);
        sender.sendMessage("\u00a76[MODL] \u00a7aLocale reload completed!");
    }

    private void reloadPunishmentTypesAsync(CommandIssuer sender, Runnable onComplete) {
        ((CompletableFuture)CompletableFuture.allOf(this.reloadPunishCommandTypes(sender), this.reloadPlayerLookupTypes(sender)).thenRun(() -> {
            sender.sendMessage("\u00a7aPunishment types reloaded successfully");
            if (onComplete != null) {
                onComplete.run();
            }
        })).exceptionally(throwable -> {
            if (throwable.getCause() instanceof PanelUnavailableException) {
                sender.sendMessage(this.localeManager.getMessage("api_errors.panel_restarting"));
            } else {
                sender.sendMessage("\u00a7cFailed to reload punishment types: " + throwable.getMessage());
            }
            if (onComplete != null) {
                onComplete.run();
            }
            return null;
        });
    }

    private CompletableFuture<Void> reloadPunishCommandTypes(CommandIssuer sender) {
        return this.httpClient.getPunishmentTypes().thenAccept(response -> {
            if (response.isSuccess()) {
                this.punishCommand.updatePunishmentTypesCache(response.getData());
                sender.sendMessage("\u00a77- Punish command types: \u00a7a" + this.punishCommand.getPunishmentTypeNames().size() + " loaded");
            } else {
                sender.sendMessage("\u00a77- Punish command types: \u00a7cFailed (Status: " + response.getStatus() + ")");
            }
        });
    }

    private CompletableFuture<Void> reloadPlayerLookupTypes(CommandIssuer sender) {
        return this.httpClient.getPunishmentTypes().thenAccept(response -> {
            if (response.isSuccess()) {
                this.playerLookupCommand.updatePunishmentTypesCache(response.getData());
                sender.sendMessage("\u00a77- Player lookup types: \u00a7a" + response.getData().size() + " loaded");
            } else {
                sender.sendMessage("\u00a77- Player lookup types: \u00a7cFailed (Status: " + response.getStatus() + ")");
            }
        });
    }

    private void reloadStaffPermissionsAsync(CommandIssuer sender, Runnable onComplete) {
        ((CompletableFuture)this.httpClient.getStaffPermissions().thenAccept(response -> {
            this.cache.clearStaffPermissions();
            int loadedCount = 0;
            for (StaffPermissionsResponse.StaffMember staffMember : response.getData().getStaff()) {
                if (staffMember.getMinecraftUuid() == null) continue;
                try {
                    UUID uuid = UUID.fromString(staffMember.getMinecraftUuid());
                    this.cache.cacheStaffPermissions(uuid, staffMember.getStaffRole(), staffMember.getPermissions());
                    ++loadedCount;
                }
                catch (IllegalArgumentException e) {
                    sender.sendMessage("\u00a77- Invalid UUID for staff member " + staffMember.getStaffUsername() + ": " + staffMember.getMinecraftUuid());
                }
            }
            sender.sendMessage("\u00a7aStaff permissions reloaded: " + loadedCount + " staff members");
            if (onComplete != null) {
                onComplete.run();
            }
        })).exceptionally(throwable -> {
            if (throwable.getCause() instanceof PanelUnavailableException) {
                sender.sendMessage(this.localeManager.getMessage("api_errors.panel_restarting"));
            } else {
                sender.sendMessage("\u00a7cFailed to reload staff permissions: " + throwable.getMessage());
            }
            if (onComplete != null) {
                onComplete.run();
            }
            return null;
        });
    }

    private void reloadLocaleSync(CommandIssuer sender) {
        try {
            this.localeManager.reloadLocale();
            sender.sendMessage("\u00a7aLocale files reloaded successfully");
        }
        catch (Exception e) {
            sender.sendMessage("\u00a7cFailed to reload locale: " + e.getMessage());
        }
    }

    @Generated
    public ModlReloadCommand(ModlHttpClient httpClient, Platform platform, Cache cache, LocaleManager localeManager, PunishCommand punishCommand, PlayerLookupCommand playerLookupCommand) {
        this.httpClient = httpClient;
        this.platform = platform;
        this.cache = cache;
        this.localeManager = localeManager;
        this.punishCommand = punishCommand;
        this.playerLookupCommand = playerLookupCommand;
    }
}

