/*
 * Decompiled with CFR 0.152.
 */
package gg.modl.minecraft.core.impl.commands;

import co.aikar.commands.BaseCommand;
import co.aikar.commands.CommandIssuer;
import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.CommandCompletion;
import co.aikar.commands.annotation.Description;
import co.aikar.commands.annotation.Name;
import co.aikar.commands.annotation.Syntax;
import gg.modl.minecraft.api.Account;
import gg.modl.minecraft.api.Note;
import gg.modl.minecraft.api.http.ModlHttpClient;
import gg.modl.minecraft.api.http.PanelUnavailableException;
import gg.modl.minecraft.api.http.request.PlayerLookupRequest;
import gg.modl.minecraft.api.http.response.LinkedAccountsResponse;
import gg.modl.minecraft.api.http.response.PlayerLookupResponse;
import gg.modl.minecraft.api.http.response.PunishmentTypesResponse;
import gg.modl.minecraft.core.Platform;
import gg.modl.minecraft.core.impl.cache.Cache;
import gg.modl.minecraft.core.locale.LocaleManager;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;

public class PlayerLookupCommand
extends BaseCommand {
    private final ModlHttpClient httpClient;
    private final Platform platform;
    private final Cache cache;
    private final LocaleManager localeManager;
    private final String panelUrl;
    private final Map<String, String> punishmentTypeNames = new ConcurrentHashMap<String, String>();
    private boolean punishmentTypesLoaded = false;

    public void initializePunishmentTypes() {
        ((CompletableFuture)this.httpClient.getPunishmentTypes().thenAccept(response -> {
            if (response.isSuccess()) {
                response.getData().forEach(pt -> {
                    this.punishmentTypeNames.put(String.valueOf(pt.getId()), pt.getName());
                    this.punishmentTypeNames.put(String.valueOf(pt.getOrdinal()), pt.getName());
                });
                this.punishmentTypesLoaded = true;
                this.platform.runOnMainThread(() -> System.out.println("[MODL] Loaded " + response.getData().size() + " punishment types for lookup display"));
            } else {
                this.platform.runOnMainThread(() -> System.err.println("[MODL] Failed to load punishment types for lookup display: " + response.getStatus()));
            }
        })).exceptionally(throwable -> {
            if (throwable.getCause() instanceof PanelUnavailableException) {
                this.platform.runOnMainThread(() -> System.err.println("[MODL] Panel restarting, cannot load punishment types: " + throwable.getMessage()));
            } else {
                this.platform.runOnMainThread(() -> System.err.println("[MODL] Error loading punishment types for lookup display: " + throwable.getMessage()));
            }
            return null;
        });
    }

    public void updatePunishmentTypesCache(List<PunishmentTypesResponse.PunishmentTypeData> allTypes) {
        this.punishmentTypeNames.clear();
        allTypes.forEach(pt -> {
            this.punishmentTypeNames.put(String.valueOf(pt.getId()), pt.getName());
            this.punishmentTypeNames.put(String.valueOf(pt.getOrdinal()), pt.getName());
        });
        this.punishmentTypesLoaded = true;
    }

    @CommandCompletion(value="@players")
    @CommandAlias(value="lookup|look|check|info")
    @Syntax(value="<player>")
    @Description(value="Look up detailed information about a player (online or offline)")
    public void lookup(CommandIssuer sender, @Name(value="player") String playerQuery) {
        UUID senderUuid;
        boolean isStaffMember;
        if (sender.isPlayer() && !(isStaffMember = this.cache.isStaffMemberByPermissions(senderUuid = sender.getUniqueId()))) {
            sender.sendMessage(this.localeManager.getMessage("player_lookup.permission_denied"));
            return;
        }
        sender.sendMessage(this.localeManager.getMessage("player_lookup.looking_up", Map.of("player", playerQuery)));
        PlayerLookupRequest request = new PlayerLookupRequest(playerQuery);
        CompletableFuture<PlayerLookupResponse> future = this.httpClient.lookupPlayer(request);
        ((CompletableFuture)future.thenAccept(response -> {
            if (response.isSuccess() && response.getData() != null) {
                UUID playerUuid = UUID.fromString(response.getData().getMinecraftUuid());
                ((CompletableFuture)this.httpClient.getLinkedAccounts(playerUuid).thenAccept(linkedResponse -> this.displayPlayerInfo(sender, response.getData(), (LinkedAccountsResponse)linkedResponse))).exceptionally(linkedThrowable -> {
                    if (linkedThrowable.getCause() instanceof PanelUnavailableException) {
                        sender.sendMessage(this.localeManager.getMessage("api_errors.panel_restarting"));
                    } else {
                        this.displayPlayerInfo(sender, response.getData(), null);
                    }
                    return null;
                });
            } else {
                sender.sendMessage(this.localeManager.getMessage("player_lookup.not_found", Map.of("player", playerQuery)));
            }
        })).exceptionally(throwable -> {
            if (throwable.getCause() instanceof PanelUnavailableException) {
                sender.sendMessage(this.localeManager.getMessage("api_errors.panel_restarting"));
            } else {
                sender.sendMessage(this.localeManager.getMessage("player_lookup.error", Map.of("error", throwable.getMessage())));
            }
            return null;
        });
    }

    private void displayPlayerInfo(CommandIssuer sender, PlayerLookupResponse.PlayerData data, LinkedAccountsResponse linkedResponse) {
        sender.sendMessage(this.localeManager.getMessage("player_lookup.header"));
        sender.sendMessage(this.localeManager.getMessage("player_lookup.title", Map.of("username", data.getCurrentUsername())));
        sender.sendMessage(this.localeManager.getMessage("player_lookup.header"));
        sender.sendMessage(this.localeManager.getMessage("player_lookup.uuid", Map.of("uuid", data.getMinecraftUuid())));
        UUID playerUuid = UUID.fromString(data.getMinecraftUuid());
        boolean isBanned = this.cache.isBanned(playerUuid);
        boolean isMuted = this.cache.isMuted(playerUuid);
        if (!(isBanned && isMuted || data.getRecentPunishments() == null)) {
            for (PlayerLookupResponse.RecentPunishment punishment : data.getRecentPunishments()) {
                String type;
                if (!punishment.isActive() || (type = punishment.getType()) == null) continue;
                String typeName = this.getPunishmentTypeName(type).toLowerCase();
                if (!isBanned && (typeName.contains("ban") || typeName.equals("blacklist"))) {
                    isBanned = true;
                }
                if (isMuted || !typeName.contains("mute") && !typeName.equals("silence")) continue;
                isMuted = true;
            }
        }
        String bannedStatus = isBanned ? "&cYes" : "&aNo";
        String mutedStatus = isMuted ? "&cYes" : "&aNo";
        sender.sendMessage(this.localeManager.getMessage("player_lookup.currently_banned", Map.of("status", bannedStatus)));
        sender.sendMessage(this.localeManager.getMessage("player_lookup.currently_muted", Map.of("status", mutedStatus)));
        sender.sendMessage(this.localeManager.getMessage("player_lookup.staff_notes_header"));
        boolean hasNotes = false;
        if (linkedResponse != null && linkedResponse.getLinkedAccounts() != null) {
            block1: for (Account account : linkedResponse.getLinkedAccounts()) {
                if (account.getNotes() == null || account.getNotes().isEmpty()) continue;
                hasNotes = true;
                int noteCount = 0;
                for (Note note : account.getNotes()) {
                    if (noteCount >= 3) break block1;
                    sender.sendMessage(this.localeManager.getMessage("player_lookup.staff_note_format", Map.of("text", note.getText(), "issuer", note.getIssuerName())));
                    ++noteCount;
                }
            }
        }
        if (!hasNotes) {
            sender.sendMessage(this.localeManager.getMessage("player_lookup.no_staff_notes"));
        }
        int totalPunishments = 0;
        if (data.getPunishmentStats() != null) {
            totalPunishments = data.getPunishmentStats().getTotalPunishments();
        }
        sender.sendMessage(this.localeManager.getMessage("player_lookup.total_punishments", Map.of("count", String.valueOf(totalPunishments))));
        sender.sendMessage(this.localeManager.getMessage("player_lookup.linked_accounts_header"));
        if (linkedResponse != null && linkedResponse.getLinkedAccounts() != null && !linkedResponse.getLinkedAccounts().isEmpty()) {
            int accountCount = 0;
            for (Account account : linkedResponse.getLinkedAccounts()) {
                if (accountCount >= 5) break;
                String currentName = account.getUsernames() != null && !account.getUsernames().isEmpty() ? account.getUsernames().get(account.getUsernames().size() - 1).getUsername() : "Unknown";
                boolean accountBanned = this.cache.isBanned(account.getMinecraftUuid());
                boolean accountMuted = this.cache.isMuted(account.getMinecraftUuid());
                String status = accountBanned && accountMuted ? this.localeManager.getMessage("player_lookup.status.banned_and_muted") : (accountBanned ? this.localeManager.getMessage("player_lookup.status.banned") : (accountMuted ? this.localeManager.getMessage("player_lookup.status.muted") : this.localeManager.getMessage("player_lookup.status.no_punishments")));
                sender.sendMessage(this.localeManager.getMessage("player_lookup.linked_account_format", Map.of("username", currentName, "status", status)));
                ++accountCount;
            }
            if (linkedResponse.getLinkedAccounts().size() > 5) {
                sender.sendMessage(this.localeManager.getMessage("player_lookup.linked_account_more", Map.of("count", String.valueOf(linkedResponse.getLinkedAccounts().size() - 5))));
            }
        } else {
            sender.sendMessage(this.localeManager.getMessage("player_lookup.no_linked_accounts"));
        }
        int totalTickets = 0;
        if (data.getRecentTickets() != null) {
            totalTickets = data.getRecentTickets().size();
        }
        sender.sendMessage(this.localeManager.getMessage("player_lookup.total_tickets", Map.of("count", String.valueOf(totalTickets))));
        sender.sendMessage("");
        if (data.getMinecraftUuid() != null) {
            String profileUrl = this.panelUrl + "/panel?player=" + data.getMinecraftUuid();
            String profileMessage = String.format("{\"text\":\"\",\"extra\":[{\"text\":\"\ud83d\udccb \",\"color\":\"gold\"},{\"text\":\"View Full Profile\",\"color\":\"aqua\",\"underlined\":true,\"clickEvent\":{\"action\":\"open_url\",\"value\":\"%s\"},\"hoverEvent\":{\"action\":\"show_text\",\"value\":\"Click to view %s's profile\"}}]}", profileUrl, data.getCurrentUsername());
            if (sender.isPlayer()) {
                UUID senderUuid = sender.getUniqueId();
                this.platform.runOnMainThread(() -> this.platform.sendJsonMessage(senderUuid, profileMessage));
            } else {
                sender.sendMessage(this.localeManager.getMessage("player_lookup.profile_fallback", Map.of("url", profileUrl)));
            }
        }
        sender.sendMessage(this.localeManager.getMessage("player_lookup.footer"));
    }

    private String formatDate(String isoDate) {
        try {
            Date date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(isoDate);
            return new SimpleDateFormat("MMM dd, yyyy HH:mm").format(date);
        }
        catch (Exception e) {
            return isoDate;
        }
    }

    private String getStatusColor(String status) {
        if (status == null) {
            return "&7";
        }
        switch (status.toLowerCase()) {
            case "low": {
                return "&a";
            }
            case "medium": {
                return "&e";
            }
            case "habitual": {
                return "&c";
            }
        }
        return "&7";
    }

    private String getPunishmentTypeColor(String type) {
        if (type == null) {
            return "&7";
        }
        String lower = type.toLowerCase();
        if (lower.contains("ban")) {
            return "&4";
        }
        if (lower.contains("mute")) {
            return "&6";
        }
        if (lower.contains("kick")) {
            return "&e";
        }
        if (lower.contains("warn")) {
            return "&c";
        }
        return "&7";
    }

    private String getTicketStatusColor(String status) {
        if (status == null) {
            return "&7";
        }
        switch (status.toLowerCase()) {
            case "open": {
                return "&a";
            }
            case "pending": {
                return "&e";
            }
            case "closed": {
                return "&8";
            }
            case "resolved": {
                return "&2";
            }
        }
        return "&7";
    }

    private String getPunishmentTypeName(String typeId) {
        block17: {
            if (typeId == null) {
                return "Unknown";
            }
            String name = this.punishmentTypeNames.get(typeId);
            if (name != null) {
                return name;
            }
            try {
                int id = Integer.parseInt(typeId);
                switch (id) {
                    case 1: {
                        return "Ban";
                    }
                    case 2: {
                        return "Mute";
                    }
                    case 3: {
                        return "Kick";
                    }
                    case 4: {
                        return "Warning";
                    }
                    case 5: {
                        return "Blacklist";
                    }
                    case 6: {
                        return "Silence";
                    }
                }
            }
            catch (NumberFormatException ignored) {
                String lower = typeId.toLowerCase();
                if (lower.contains("ban")) {
                    return "Ban";
                }
                if (lower.contains("mute")) {
                    return "Mute";
                }
                if (lower.contains("kick")) {
                    return "Kick";
                }
                if (lower.contains("warn")) {
                    return "Warning";
                }
                if (lower.contains("blacklist")) {
                    return "Blacklist";
                }
                if (!lower.contains("silence")) break block17;
                return "Silence";
            }
        }
        return typeId;
    }

    @Generated
    public PlayerLookupCommand(ModlHttpClient httpClient, Platform platform, Cache cache, LocaleManager localeManager, String panelUrl) {
        this.httpClient = httpClient;
        this.platform = platform;
        this.cache = cache;
        this.localeManager = localeManager;
        this.panelUrl = panelUrl;
    }
}

