/*
 * Decompiled with CFR 0.152.
 */
package gg.modl.minecraft.core.impl.commands;

import co.aikar.commands.BaseCommand;
import co.aikar.commands.CommandIssuer;
import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.CommandCompletion;
import co.aikar.commands.annotation.Description;
import co.aikar.commands.annotation.Syntax;
import gg.modl.minecraft.api.AbstractPlayer;
import gg.modl.minecraft.api.http.ModlHttpClient;
import gg.modl.minecraft.api.http.PanelUnavailableException;
import gg.modl.minecraft.api.http.request.CreateTicketRequest;
import gg.modl.minecraft.api.http.response.CreateTicketResponse;
import gg.modl.minecraft.core.Platform;
import gg.modl.minecraft.core.locale.LocaleManager;
import gg.modl.minecraft.core.service.ChatMessageCache;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;

public class TicketCommands
extends BaseCommand {
    private final Platform platform;
    private final ModlHttpClient httpClient;
    private final String panelUrl;
    private final LocaleManager localeManager;
    private final ChatMessageCache chatMessageCache;

    @CommandAlias(value="report")
    @CommandCompletion(value="@players")
    @Description(value="Report a player with a reason")
    @Syntax(value="<player> <reason...>")
    public void report(CommandIssuer sender, AbstractPlayer targetPlayer, String reason) {
        AbstractPlayer reporter = this.platform.getAbstractPlayer(sender.getUniqueId(), false);
        if (targetPlayer.username().equalsIgnoreCase(reporter.username())) {
            sender.sendMessage(this.localeManager.getMessage("messages.cannot_report_self"));
            return;
        }
        CreateTicketRequest request = new CreateTicketRequest(reporter.uuid().toString(), reporter.username(), "player", "Player Report: " + targetPlayer.username(), "Reported player: " + targetPlayer.username() + "\nReason: " + reason, targetPlayer.uuid().toString(), targetPlayer.username(), null, List.of("report"), "normal");
        this.submitFinishedTicket(sender, request, "Report");
    }

    @CommandAlias(value="chatreport")
    @CommandCompletion(value="@players")
    @Description(value="Report a player for chat violations (automatically includes recent chat logs)")
    @Syntax(value="<player>")
    public void chatReport(CommandIssuer sender, AbstractPlayer targetPlayer) {
        AbstractPlayer reporter = this.platform.getAbstractPlayer(sender.getUniqueId(), false);
        if (targetPlayer.username().equalsIgnoreCase(reporter.username())) {
            sender.sendMessage(this.localeManager.getMessage("messages.cannot_report_self"));
            return;
        }
        List<String> chatLogs = this.chatMessageCache.getRecentMessages(reporter.uuid().toString(), 30);
        if (chatLogs.isEmpty()) {
            sender.sendMessage(this.localeManager.getMessage("messages.no_chat_logs_available", Map.of("player", targetPlayer.username())));
            return;
        }
        CreateTicketRequest request = new CreateTicketRequest(reporter.uuid().toString(), reporter.username(), "chat", "Chat Report: " + targetPlayer.username(), "Chat violation report for: " + targetPlayer.username() + "\nAutomatic chat log capture included.", targetPlayer.uuid().toString(), targetPlayer.username(), chatLogs, List.of(), "normal");
        this.submitFinishedTicket(sender, request, "Chat report");
    }

    @CommandAlias(value="apply")
    @Description(value="Submit a staff application")
    public void staffApplication(CommandIssuer sender) {
        AbstractPlayer applicant = this.platform.getAbstractPlayer(sender.getUniqueId(), false);
        CreateTicketRequest request = new CreateTicketRequest(applicant.uuid().toString(), applicant.username(), "staff", "Application: " + applicant.username(), null, null, null, null, List.of(), "normal");
        this.submitUnfinishedTicket(sender, request, "Staff application");
    }

    @CommandAlias(value="bugreport")
    @Description(value="Report a bug")
    @Syntax(value="<description...>")
    public void bugReport(CommandIssuer sender, String description) {
        AbstractPlayer reporter = this.platform.getAbstractPlayer(sender.getUniqueId(), false);
        CreateTicketRequest request = new CreateTicketRequest(reporter.uuid().toString(), reporter.username(), "bug", "Bug Report: " + reporter.username(), description, null, null, null, List.of(), "normal");
        this.submitUnfinishedTicket(sender, request, "Bug report");
    }

    @CommandAlias(value="support")
    @Description(value="Request support")
    @Syntax(value="<description...>")
    public void supportRequest(CommandIssuer sender, String description) {
        AbstractPlayer requester = this.platform.getAbstractPlayer(sender.getUniqueId(), false);
        CreateTicketRequest request = new CreateTicketRequest(requester.uuid().toString(), requester.username(), "support", "Support Request: " + requester.username(), description, null, null, null, List.of(), "normal");
        this.submitUnfinishedTicket(sender, request, "Support request");
    }

    private void submitFinishedTicket(CommandIssuer sender, CreateTicketRequest request, String ticketType) {
        sender.sendMessage(this.localeManager.getMessage("messages.submitting", Map.of("type", ticketType.toLowerCase())));
        CompletableFuture<CreateTicketResponse> future = this.httpClient.createTicket(request);
        ((CompletableFuture)future.thenAccept(response -> {
            if (response.isSuccess() && response.getTicketId() != null) {
                sender.sendMessage(this.localeManager.getMessage("messages.success", Map.of("type", ticketType)));
                sender.sendMessage(this.localeManager.getMessage("messages.ticket_id", Map.of("ticketId", response.getTicketId())));
                String ticketUrl = this.panelUrl + "/ticket/" + response.getTicketId();
                this.sendClickableTicketMessage(sender, this.localeManager.getMessage("messages.view_ticket_label"), ticketUrl, response.getTicketId());
                sender.sendMessage(this.localeManager.getMessage("messages.evidence_note"));
            } else {
                String error = response.getMessage() != null ? response.getMessage() : this.localeManager.getMessage("messages.unknown_error");
                sender.sendMessage(this.localeManager.getMessage("messages.failed_submit", Map.of("type", ticketType.toLowerCase(), "error", error)));
                sender.sendMessage(this.localeManager.getMessage("messages.try_again"));
            }
        })).exceptionally(throwable -> {
            if (throwable.getCause() instanceof PanelUnavailableException) {
                sender.sendMessage(this.localeManager.getMessage("api_errors.panel_restarting"));
            } else {
                sender.sendMessage(this.localeManager.getMessage("messages.failed_submit", Map.of("type", ticketType.toLowerCase(), "error", throwable.getMessage())));
                sender.sendMessage(this.localeManager.getMessage("messages.try_again"));
            }
            return null;
        });
    }

    private void submitUnfinishedTicket(CommandIssuer sender, CreateTicketRequest request, String ticketType) {
        sender.sendMessage(this.localeManager.getMessage("messages.creating", Map.of("type", ticketType.toLowerCase())));
        CompletableFuture<CreateTicketResponse> future = this.httpClient.createUnfinishedTicket(request);
        ((CompletableFuture)future.thenAccept(response -> {
            if (response.isSuccess() && response.getTicketId() != null) {
                sender.sendMessage(this.localeManager.getMessage("messages.created", Map.of("type", ticketType)));
                sender.sendMessage(this.localeManager.getMessage("messages.ticket_id", Map.of("ticketId", response.getTicketId())));
                String formUrl = this.panelUrl + "/ticket/" + response.getTicketId();
                this.sendClickableTicketMessage(sender, this.localeManager.getMessage("messages.complete_form_label", Map.of("type", ticketType.toLowerCase())), formUrl, response.getTicketId());
            } else {
                String error = response.getMessage() != null ? response.getMessage() : this.localeManager.getMessage("messages.unknown_error");
                sender.sendMessage(this.localeManager.getMessage("messages.failed_create", Map.of("type", ticketType.toLowerCase(), "error", error)));
                sender.sendMessage(this.localeManager.getMessage("messages.try_again"));
            }
        })).exceptionally(throwable -> {
            if (throwable.getCause() instanceof PanelUnavailableException) {
                sender.sendMessage(this.localeManager.getMessage("api_errors.panel_restarting"));
            } else {
                sender.sendMessage(this.localeManager.getMessage("messages.failed_create", Map.of("type", ticketType.toLowerCase(), "error", throwable.getMessage())));
                sender.sendMessage(this.localeManager.getMessage("messages.try_again"));
            }
            return null;
        });
    }

    private void sendClickableTicketMessage(CommandIssuer sender, String message, String ticketUrl, String ticketId) {
        if (sender.isPlayer()) {
            String clickableMessage = String.format("{\"text\":\"\",\"extra\":[{\"text\":\"\ud83d\udccb \",\"color\":\"gold\"},{\"text\":\"%s: \",\"color\":\"gray\"},{\"text\":\"[Click to view]\",\"color\":\"aqua\",\"underlined\":true,\"clickEvent\":{\"action\":\"open_url\",\"value\":\"%s\"},\"hoverEvent\":{\"action\":\"show_text\",\"value\":\"Click to view ticket %s\"}}]}", message, ticketUrl, ticketId);
            UUID senderUuid = sender.getUniqueId();
            this.platform.runOnMainThread(() -> this.platform.sendJsonMessage(senderUuid, clickableMessage));
        } else {
            sender.sendMessage(this.localeManager.getMessage("messages.console_ticket_url", Map.of("message", message, "url", ticketUrl)));
        }
    }

    @Generated
    public TicketCommands(Platform platform, ModlHttpClient httpClient, String panelUrl, LocaleManager localeManager, ChatMessageCache chatMessageCache) {
        this.platform = platform;
        this.httpClient = httpClient;
        this.panelUrl = panelUrl;
        this.localeManager = localeManager;
        this.chatMessageCache = chatMessageCache;
    }
}

