/*
 * Decompiled with CFR 0.152.
 */
package gg.modl.minecraft.core.impl.commands.player;

import co.aikar.commands.BaseCommand;
import co.aikar.commands.CommandIssuer;
import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.CommandCompletion;
import co.aikar.commands.annotation.Description;
import co.aikar.commands.annotation.Name;
import co.aikar.commands.annotation.Optional;
import co.aikar.commands.annotation.Syntax;
import gg.modl.minecraft.api.AbstractPlayer;
import gg.modl.minecraft.core.Platform;
import gg.modl.minecraft.core.impl.cache.Cache;
import gg.modl.minecraft.core.locale.LocaleManager;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public class IAmMutedCommand
extends BaseCommand {
    private final Platform platform;
    private final Cache cache;
    private final LocaleManager localeManager;
    private static final ConcurrentHashMap<UUID, Long> cooldowns = new ConcurrentHashMap();
    private static final long COOLDOWN_DURATION = TimeUnit.MINUTES.toMillis(5L);

    @CommandCompletion(value="@players")
    @CommandAlias(value="iammuted|iam")
    @Syntax(value="<player> [message]")
    @Description(value="Send a message to another player informing them you are muted (only usable if you are actually muted)")
    public void iAmMuted(CommandIssuer sender, @Name(value="player") AbstractPlayer targetPlayer, @Optional @Name(value="message") String customMessage) {
        if (!sender.isPlayer()) {
            sender.sendMessage(this.localeManager.getMessage("iammuted.only_players"));
            return;
        }
        UUID senderUuid = sender.getUniqueId();
        if (!this.cache.isMuted(senderUuid)) {
            sender.sendMessage(this.localeManager.getMessage("iammuted.not_muted"));
            return;
        }
        Long lastUsed = cooldowns.get(senderUuid);
        long currentTime = System.currentTimeMillis();
        if (lastUsed != null && currentTime - lastUsed < COOLDOWN_DURATION) {
            long remainingTime = COOLDOWN_DURATION - (currentTime - lastUsed);
            long remainingMinutes = TimeUnit.MILLISECONDS.toMinutes(remainingTime);
            long remainingSeconds = TimeUnit.MILLISECONDS.toSeconds(remainingTime) % 60L;
            sender.sendMessage(this.localeManager.getMessage("iammuted.cooldown_message", Map.of("minutes", String.valueOf(remainingMinutes), "seconds", String.valueOf(remainingSeconds))));
            return;
        }
        if (targetPlayer == null) {
            sender.sendMessage(this.localeManager.getMessage("iammuted.player_not_found"));
            return;
        }
        if (!targetPlayer.isOnline()) {
            sender.sendMessage(this.localeManager.getMessage("iammuted.player_not_online"));
            return;
        }
        AbstractPlayer senderPlayer = this.platform.getAbstractPlayer(senderUuid, false);
        if (targetPlayer.uuid().equals(senderUuid)) {
            sender.sendMessage(this.localeManager.getMessage("iammuted.cannot_message_self"));
            return;
        }
        String baseMessage = this.localeManager.getMessage("iammuted.notification_to_target", Map.of("sender", senderPlayer.username()));
        Object fullMessage = customMessage != null && !customMessage.trim().isEmpty() ? baseMessage + "\n" + this.localeManager.getMessage("iammuted.custom_message_prefix") + customMessage.trim() : baseMessage;
        UUID targetUuid = targetPlayer.uuid();
        this.platform.sendMessage(targetUuid, (String)fullMessage);
        sender.sendMessage(this.localeManager.getMessage("iammuted.success_message", Map.of("target", targetPlayer.username())));
        cooldowns.put(senderUuid, currentTime);
        this.cleanupOldCooldowns();
    }

    private void cleanupOldCooldowns() {
        long currentTime = System.currentTimeMillis();
        cooldowns.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > COOLDOWN_DURATION * 2L);
    }

    @Generated
    public IAmMutedCommand(Platform platform, Cache cache, LocaleManager localeManager) {
        this.platform = platform;
        this.cache = cache;
        this.localeManager = localeManager;
    }
}

