/*
 * Decompiled with CFR 0.152.
 */
package gg.modl.minecraft.core.impl.commands.punishments;

import co.aikar.commands.BaseCommand;
import co.aikar.commands.CommandIssuer;
import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.CommandCompletion;
import co.aikar.commands.annotation.Default;
import co.aikar.commands.annotation.Name;
import co.aikar.commands.annotation.Syntax;
import com.google.gson.JsonObject;
import gg.modl.minecraft.api.Account;
import gg.modl.minecraft.api.http.ModlHttpClient;
import gg.modl.minecraft.api.http.PanelUnavailableException;
import gg.modl.minecraft.api.http.request.CreatePunishmentRequest;
import gg.modl.minecraft.core.Platform;
import gg.modl.minecraft.core.impl.cache.Cache;
import gg.modl.minecraft.core.locale.LocaleManager;
import gg.modl.minecraft.core.util.PermissionUtil;
import gg.modl.minecraft.core.util.TimeUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;

public class BanCommand
extends BaseCommand {
    private final ModlHttpClient httpClient;
    private final Platform platform;
    private final Cache cache;
    private final LocaleManager localeManager;

    @CommandCompletion(value="@players")
    @CommandAlias(value="ban")
    @Syntax(value="<target> [duration] [reason...] [-silent] [-alt-blocking] [-stat-wipe]")
    public void ban(CommandIssuer sender, @Name(value="target") Account target, @Default(value="") String args) {
        if (target == null) {
            sender.sendMessage(this.localeManager.getPunishmentMessage("general.player_not_found", Map.of()));
            return;
        }
        if (!PermissionUtil.hasPermission(sender, this.cache, "punishment.apply.manual-ban")) {
            sender.sendMessage(this.localeManager.getPunishmentMessage("general.no_permission_punishment", Map.of("type", "ban")));
            return;
        }
        BanArgs banArgs = this.parseArguments(args);
        String issuerName = sender.isPlayer() ? this.platform.getAbstractPlayer(sender.getUniqueId(), false).username() : "Console";
        JsonObject data = new JsonObject();
        data.addProperty("reason", banArgs.reason.isEmpty() ? "No reason specified" : banArgs.reason);
        data.addProperty("silent", banArgs.silent);
        data.addProperty("altBlocking", banArgs.altBlocking);
        data.addProperty("wipeAfterExpiry", banArgs.statWipe);
        if (banArgs.duration > 0L) {
            data.addProperty("duration", banArgs.duration);
        }
        CreatePunishmentRequest request = new CreatePunishmentRequest(target.getMinecraftUuid().toString(), issuerName, 2, banArgs.reason.isEmpty() ? "No reason specified" : banArgs.reason, banArgs.duration, data, new ArrayList<String>(), new ArrayList<String>());
        boolean silentBan = banArgs.silent;
        String durationStr = banArgs.duration > 0L ? TimeUtil.formatTimeMillis(banArgs.duration) : "permanent";
        CompletableFuture<Void> future = this.httpClient.createPunishment(request);
        ((CompletableFuture)future.thenAccept(response -> {
            String targetName = target.getUsernames().get(0).getUsername();
            sender.sendMessage(this.localeManager.punishment().type("ban").target(targetName).duration(banArgs.duration).get("general.punishment_issued"));
            String staffMessage = this.localeManager.punishment().issuer(issuerName).type("ban").target(targetName).get("general.staff_notification");
            this.platform.staffBroadcast(staffMessage);
        })).exceptionally(throwable -> {
            if (throwable.getCause() instanceof PanelUnavailableException) {
                sender.sendMessage(this.localeManager.getMessage("api_errors.panel_restarting"));
            } else {
                sender.sendMessage(this.localeManager.getPunishmentMessage("general.punishment_error", Map.of("error", throwable.getMessage())));
            }
            return null;
        });
    }

    private BanArgs parseArguments(String args) {
        String[] arguments = args.split(" ");
        BanArgs result = new BanArgs();
        StringBuilder reasonBuilder = new StringBuilder();
        for (int i = 0; i < arguments.length; ++i) {
            String arg = arguments[i];
            if (arg.equalsIgnoreCase("-silent") || arg.equalsIgnoreCase("-s")) {
                result.silent = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-alt-blocking") || arg.equalsIgnoreCase("-ab")) {
                result.altBlocking = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-stat-wipe") || arg.equalsIgnoreCase("-sw")) {
                result.statWipe = true;
                continue;
            }
            long duration = TimeUtil.getDuration(arg);
            if (duration != -1L && result.duration == 0L) {
                result.duration = duration;
                continue;
            }
            if (reasonBuilder.length() > 0) {
                reasonBuilder.append(" ");
            }
            reasonBuilder.append(arg);
        }
        result.reason = reasonBuilder.toString().trim();
        return result;
    }

    private String getPublicNotificationMessage(String targetName, long duration) {
        boolean isTemporary = duration > 0L;
        Map<String, String> variables = Map.of("target", targetName, "duration", this.localeManager.formatDuration(duration));
        String messagePath = isTemporary ? "public_notification.temporary" : "public_notification.permanent";
        return this.localeManager.getPunishmentTypeMessage(2, messagePath, variables);
    }

    @Generated
    public BanCommand(ModlHttpClient httpClient, Platform platform, Cache cache, LocaleManager localeManager) {
        this.httpClient = httpClient;
        this.platform = platform;
        this.cache = cache;
        this.localeManager = localeManager;
    }

    private static class BanArgs {
        String reason = "";
        long duration = 0L;
        boolean silent = false;
        boolean altBlocking = false;
        boolean statWipe = false;

        private BanArgs() {
        }
    }
}

