/*
 * Decompiled with CFR 0.152.
 */
package gg.modl.minecraft.core.impl.commands.punishments;

import co.aikar.commands.BaseCommand;
import co.aikar.commands.CommandIssuer;
import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.CommandCompletion;
import co.aikar.commands.annotation.Default;
import co.aikar.commands.annotation.Name;
import co.aikar.commands.annotation.Syntax;
import com.google.gson.JsonObject;
import gg.modl.minecraft.api.Account;
import gg.modl.minecraft.api.http.ModlHttpClient;
import gg.modl.minecraft.api.http.PanelUnavailableException;
import gg.modl.minecraft.api.http.request.CreatePunishmentRequest;
import gg.modl.minecraft.core.Platform;
import gg.modl.minecraft.core.impl.cache.Cache;
import gg.modl.minecraft.core.locale.LocaleManager;
import gg.modl.minecraft.core.util.PermissionUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;

public class BlacklistCommand
extends BaseCommand {
    private final ModlHttpClient httpClient;
    private final Platform platform;
    private final Cache cache;
    private final LocaleManager localeManager;

    @CommandCompletion(value="@players")
    @CommandAlias(value="blacklist")
    @Syntax(value="<target> [reason...] [-silent] [-alt-blocking] [-stat-wipe]")
    public void blacklist(CommandIssuer sender, @Name(value="target") Account target, @Default(value="") String args) {
        if (target == null) {
            sender.sendMessage(this.localeManager.getPunishmentMessage("general.player_not_found", Map.of()));
            return;
        }
        if (!PermissionUtil.hasPermission(sender, this.cache, "punishment.apply.blacklist")) {
            sender.sendMessage(this.localeManager.getPunishmentMessage("general.no_permission_punishment", Map.of("type", "blacklist")));
            return;
        }
        BlacklistArgs blacklistArgs = this.parseArguments(args);
        String issuerName = sender.isPlayer() ? this.platform.getAbstractPlayer(sender.getUniqueId(), false).username() : "Console";
        JsonObject data = new JsonObject();
        data.addProperty("reason", blacklistArgs.reason.isEmpty() ? "No reason specified" : blacklistArgs.reason);
        data.addProperty("silent", blacklistArgs.silent);
        data.addProperty("altBlocking", blacklistArgs.altBlocking);
        data.addProperty("wipeAfterExpiry", blacklistArgs.statWipe);
        CreatePunishmentRequest request = new CreatePunishmentRequest(target.getMinecraftUuid().toString(), issuerName, 5, blacklistArgs.reason.isEmpty() ? "No reason specified" : blacklistArgs.reason, 0L, data, new ArrayList<String>(), new ArrayList<String>());
        boolean silentBlacklist = blacklistArgs.silent;
        CompletableFuture<Void> future = this.httpClient.createPunishment(request);
        ((CompletableFuture)future.thenAccept(response -> {
            String targetName = target.getUsernames().get(0).getUsername();
            sender.sendMessage(this.localeManager.punishment().type("blacklist").target(targetName).get("general.punishment_issued"));
            String staffMessage = this.localeManager.punishment().issuer(issuerName).type("blacklist").target(targetName).get("general.staff_notification");
            this.platform.staffBroadcast(staffMessage);
        })).exceptionally(throwable -> {
            if (throwable.getCause() instanceof PanelUnavailableException) {
                sender.sendMessage(this.localeManager.getMessage("api_errors.panel_restarting"));
            } else {
                sender.sendMessage(this.localeManager.getPunishmentMessage("general.punishment_error", Map.of("error", throwable.getMessage())));
            }
            return null;
        });
    }

    private BlacklistArgs parseArguments(String args) {
        String[] arguments = args.split(" ");
        BlacklistArgs result = new BlacklistArgs();
        StringBuilder reasonBuilder = new StringBuilder();
        for (String arg : arguments) {
            if (arg.equalsIgnoreCase("-silent") || arg.equalsIgnoreCase("-s")) {
                result.silent = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-alt-blocking") || arg.equalsIgnoreCase("-ab")) {
                result.altBlocking = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-stat-wipe") || arg.equalsIgnoreCase("-sw")) {
                result.statWipe = true;
                continue;
            }
            if (reasonBuilder.length() > 0) {
                reasonBuilder.append(" ");
            }
            reasonBuilder.append(arg);
        }
        result.reason = reasonBuilder.toString().trim();
        return result;
    }

    private String getPublicNotificationMessage(String targetName) {
        Map<String, String> variables = Map.of("target", targetName);
        return this.localeManager.getPunishmentTypeMessage(5, "public_notification", variables);
    }

    @Generated
    public BlacklistCommand(ModlHttpClient httpClient, Platform platform, Cache cache, LocaleManager localeManager) {
        this.httpClient = httpClient;
        this.platform = platform;
        this.cache = cache;
        this.localeManager = localeManager;
    }

    private static class BlacklistArgs {
        String reason = "";
        boolean silent = false;
        boolean altBlocking = false;
        boolean statWipe = false;

        private BlacklistArgs() {
        }
    }
}

