/*
 * Decompiled with CFR 0.152.
 */
package gg.modl.minecraft.core.impl.commands.punishments;

import co.aikar.commands.BaseCommand;
import co.aikar.commands.CommandIssuer;
import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.CommandCompletion;
import co.aikar.commands.annotation.Default;
import co.aikar.commands.annotation.Name;
import co.aikar.commands.annotation.Syntax;
import com.google.gson.JsonObject;
import gg.modl.minecraft.api.Account;
import gg.modl.minecraft.api.http.ModlHttpClient;
import gg.modl.minecraft.api.http.PanelUnavailableException;
import gg.modl.minecraft.api.http.request.CreatePunishmentRequest;
import gg.modl.minecraft.core.Platform;
import gg.modl.minecraft.core.impl.cache.Cache;
import gg.modl.minecraft.core.locale.LocaleManager;
import gg.modl.minecraft.core.util.PermissionUtil;
import gg.modl.minecraft.core.util.TimeUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;

public class MuteCommand
extends BaseCommand {
    private final ModlHttpClient httpClient;
    private final Platform platform;
    private final Cache cache;
    private final LocaleManager localeManager;

    @CommandCompletion(value="@players")
    @CommandAlias(value="mute")
    @Syntax(value="<target> [duration] [reason...] [-silent]")
    public void mute(CommandIssuer sender, @Name(value="target") Account target, @Default(value="") String args) {
        if (target == null) {
            sender.sendMessage(this.localeManager.getPunishmentMessage("general.player_not_found", Map.of()));
            return;
        }
        if (!PermissionUtil.hasPermission(sender, this.cache, "punishment.apply.manual-mute")) {
            sender.sendMessage(this.localeManager.getPunishmentMessage("general.no_permission_punishment", Map.of("type", "mute")));
            return;
        }
        MuteArgs muteArgs = this.parseArguments(args);
        String issuerName = sender.isPlayer() ? this.platform.getAbstractPlayer(sender.getUniqueId(), false).username() : "Console";
        JsonObject data = new JsonObject();
        data.addProperty("reason", muteArgs.reason.isEmpty() ? "No reason specified" : muteArgs.reason);
        data.addProperty("silent", muteArgs.silent);
        if (muteArgs.duration > 0L) {
            data.addProperty("duration", muteArgs.duration);
        }
        CreatePunishmentRequest request = new CreatePunishmentRequest(target.getMinecraftUuid().toString(), issuerName, 1, muteArgs.reason.isEmpty() ? "No reason specified" : muteArgs.reason, muteArgs.duration, data, new ArrayList<String>(), new ArrayList<String>());
        boolean silentMute = muteArgs.silent;
        String durationStr = muteArgs.duration > 0L ? TimeUtil.formatTimeMillis(muteArgs.duration) : "permanent";
        CompletableFuture<Void> future = this.httpClient.createPunishment(request);
        ((CompletableFuture)future.thenAccept(response -> {
            String targetName = target.getUsernames().get(0).getUsername();
            sender.sendMessage(this.localeManager.punishment().type("mute").target(targetName).duration(muteArgs.duration).get("general.punishment_issued"));
            String staffMessage = this.localeManager.punishment().issuer(issuerName).type("mute").target(targetName).get("general.staff_notification");
            this.platform.staffBroadcast(staffMessage);
        })).exceptionally(throwable -> {
            if (throwable.getCause() instanceof PanelUnavailableException) {
                sender.sendMessage(this.localeManager.getMessage("api_errors.panel_restarting"));
            } else {
                sender.sendMessage(this.localeManager.getPunishmentMessage("general.punishment_error", Map.of("error", throwable.getMessage())));
            }
            return null;
        });
    }

    private MuteArgs parseArguments(String args) {
        String[] arguments = args.split(" ");
        MuteArgs result = new MuteArgs();
        StringBuilder reasonBuilder = new StringBuilder();
        for (int i = 0; i < arguments.length; ++i) {
            String arg = arguments[i];
            if (arg.equalsIgnoreCase("-silent") || arg.equalsIgnoreCase("-s")) {
                result.silent = true;
                continue;
            }
            long duration = TimeUtil.getDuration(arg);
            if (duration != -1L && result.duration == 0L) {
                result.duration = duration;
                continue;
            }
            if (reasonBuilder.length() > 0) {
                reasonBuilder.append(" ");
            }
            reasonBuilder.append(arg);
        }
        result.reason = reasonBuilder.toString().trim();
        return result;
    }

    private String getPublicNotificationMessage(String targetName, long duration) {
        boolean isTemporary = duration > 0L;
        Map<String, String> variables = Map.of("target", targetName, "duration", this.localeManager.formatDuration(duration));
        String messagePath = isTemporary ? "public_notification.temporary" : "public_notification.permanent";
        return this.localeManager.getPunishmentTypeMessage(1, messagePath, variables);
    }

    @Generated
    public MuteCommand(ModlHttpClient httpClient, Platform platform, Cache cache, LocaleManager localeManager) {
        this.httpClient = httpClient;
        this.platform = platform;
        this.cache = cache;
        this.localeManager = localeManager;
    }

    private static class MuteArgs {
        String reason = "";
        long duration = 0L;
        boolean silent = false;

        private MuteArgs() {
        }
    }
}

