/*
 * Decompiled with CFR 0.152.
 */
package gg.modl.minecraft.core.impl.commands.punishments;

import co.aikar.commands.BaseCommand;
import co.aikar.commands.CommandIssuer;
import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.CommandCompletion;
import co.aikar.commands.annotation.Default;
import co.aikar.commands.annotation.Description;
import co.aikar.commands.annotation.Name;
import co.aikar.commands.annotation.Syntax;
import gg.modl.minecraft.api.AbstractPlayer;
import gg.modl.minecraft.api.http.ModlHttpClient;
import gg.modl.minecraft.api.http.PanelUnavailableException;
import gg.modl.minecraft.api.http.request.PardonPlayerRequest;
import gg.modl.minecraft.api.http.request.PardonPunishmentRequest;
import gg.modl.minecraft.core.Platform;
import gg.modl.minecraft.core.impl.cache.Cache;
import gg.modl.minecraft.core.locale.LocaleManager;
import gg.modl.minecraft.core.util.PermissionUtil;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;

public class PardonCommand
extends BaseCommand {
    private final ModlHttpClient httpClient;
    private final Platform platform;
    private final Cache cache;
    private final LocaleManager localeManager;

    @CommandCompletion(value="@players")
    @CommandAlias(value="pardon")
    @Syntax(value="<player/punishment_id> [reason...]")
    @Description(value="Pardon a player's ban/mute by player name or punishment ID")
    public void pardon(CommandIssuer sender, @Name(value="target") String target, @Default(value="") String reason) {
        if (!PermissionUtil.hasPermission(sender, this.cache, "punishment.modify")) {
            sender.sendMessage(this.localeManager.getPunishmentMessage("general.no_permission_punishment", Map.of("type", "pardon")));
            return;
        }
        String issuerName = sender.isPlayer() ? this.platform.getAbstractPlayer(sender.getUniqueId(), false).username() : "Console";
        this.tryPunishmentIdThenPlayerName(sender, target, issuerName, reason, null);
    }

    @CommandAlias(value="unban")
    @Syntax(value="<player/punishment_id> [reason...]")
    @Description(value="Unban a player by name or punishment ID")
    public void unban(CommandIssuer sender, @Name(value="target") String target, @Default(value="") String reason) {
        if (!PermissionUtil.hasPermission(sender, this.cache, "punishment.modify")) {
            sender.sendMessage(this.localeManager.getPunishmentMessage("general.no_permission_punishment", Map.of("type", "unban")));
            return;
        }
        String issuerName = sender.isPlayer() ? this.platform.getAbstractPlayer(sender.getUniqueId(), false).username() : "Console";
        this.tryPunishmentIdThenPlayerName(sender, target, issuerName, reason, "ban");
    }

    @CommandAlias(value="unmute")
    @Syntax(value="<player/punishment_id> [reason...]")
    @Description(value="Unmute a player by name or punishment ID")
    public void unmute(CommandIssuer sender, @Name(value="target") String target, @Default(value="") String reason) {
        if (!PermissionUtil.hasPermission(sender, this.cache, "punishment.modify")) {
            sender.sendMessage(this.localeManager.getPunishmentMessage("general.no_permission_punishment", Map.of("type", "unmute")));
            return;
        }
        String issuerName = sender.isPlayer() ? this.platform.getAbstractPlayer(sender.getUniqueId(), false).username() : "Console";
        this.tryPunishmentIdThenPlayerName(sender, target, issuerName, reason, "mute");
    }

    private void pardonByPunishmentId(CommandIssuer sender, String punishmentId, String issuerName, String reason) {
        sender.sendMessage(this.localeManager.getMessage("pardon.processing_id", Map.of("id", punishmentId)));
        PardonPunishmentRequest request = new PardonPunishmentRequest(punishmentId, issuerName, reason.isEmpty() ? null : reason, null);
        CompletableFuture<Void> future = this.httpClient.pardonPunishment(request);
        ((CompletableFuture)future.thenAccept(response -> {
            sender.sendMessage(this.localeManager.getMessage("pardon.success_id", Map.of("id", punishmentId)));
            String staffMessage = this.localeManager.getMessage("pardon.staff_notification_id", Map.of("issuer", issuerName, "id", punishmentId));
            this.platform.staffBroadcast(staffMessage);
        })).exceptionally(throwable -> {
            if (throwable.getCause() instanceof PanelUnavailableException) {
                sender.sendMessage(this.localeManager.getMessage("api_errors.panel_restarting"));
            } else {
                sender.sendMessage(this.localeManager.getMessage("pardon.error", Map.of("error", throwable.getMessage())));
            }
            return null;
        });
    }

    private void pardonByPlayerName(CommandIssuer sender, String playerName, String issuerName, String reason, String expectedType) {
        sender.sendMessage(this.localeManager.getMessage("pardon.processing_player", Map.of("player", playerName)));
        String typeToPardon = expectedType != null ? expectedType : "ban";
        this.pardonSpecificType(sender, playerName, issuerName, reason, typeToPardon);
    }

    private void pardonSpecificType(CommandIssuer sender, String playerName, String issuerName, String reason, String type) {
        PardonPlayerRequest request = new PardonPlayerRequest(playerName, issuerName, type, reason.isEmpty() ? null : reason);
        CompletableFuture<Void> future = this.httpClient.pardonPlayer(request);
        ((CompletableFuture)future.thenAccept(response -> {
            sender.sendMessage(this.localeManager.getMessage("pardon.success_player", Map.of("player", playerName, "type", type)));
            String staffMessage = this.localeManager.getMessage("pardon.staff_notification_player", Map.of("issuer", issuerName, "player", playerName, "type", type));
            this.platform.staffBroadcast(staffMessage);
            this.invalidatePlayerCache(playerName, type);
        })).exceptionally(throwable -> {
            if (throwable.getCause() instanceof PanelUnavailableException) {
                sender.sendMessage(this.localeManager.getMessage("api_errors.panel_restarting"));
            } else {
                sender.sendMessage(this.localeManager.getMessage("pardon.error_player", Map.of("player", playerName, "type", type, "error", throwable.getMessage())));
            }
            return null;
        });
    }

    private void pardonByPunishmentIdWithTypeCheck(CommandIssuer sender, String punishmentId, String issuerName, String reason, String expectedType) {
        sender.sendMessage(this.localeManager.getMessage("pardon.processing_id", Map.of("id", punishmentId)));
        PardonPunishmentRequest request = new PardonPunishmentRequest(punishmentId, issuerName, reason.isEmpty() ? null : reason, expectedType);
        CompletableFuture<Void> future = this.httpClient.pardonPunishment(request);
        ((CompletableFuture)future.thenAccept(response -> {
            sender.sendMessage(this.localeManager.getMessage("pardon.success_id", Map.of("id", punishmentId)));
            String staffMessage = this.localeManager.getMessage("pardon.staff_notification_id", Map.of("issuer", issuerName, "id", punishmentId));
            this.platform.staffBroadcast(staffMessage);
        })).exceptionally(throwable -> {
            if (throwable.getCause() instanceof PanelUnavailableException) {
                sender.sendMessage(this.localeManager.getMessage("api_errors.panel_restarting"));
            } else {
                String errorMessage = throwable.getMessage();
                if (errorMessage != null && errorMessage.toLowerCase().contains("type")) {
                    if ("ban".equals(expectedType)) {
                        sender.sendMessage(this.localeManager.getMessage("pardon.error_wrong_type_ban", Map.of("id", punishmentId)));
                    } else if ("mute".equals(expectedType)) {
                        sender.sendMessage(this.localeManager.getMessage("pardon.error_wrong_type_mute", Map.of("id", punishmentId)));
                    } else {
                        sender.sendMessage(this.localeManager.getMessage("pardon.error", Map.of("error", errorMessage)));
                    }
                } else {
                    sender.sendMessage(this.localeManager.getMessage("pardon.error", Map.of("error", errorMessage)));
                }
            }
            return null;
        });
    }

    private void tryPunishmentIdThenPlayerName(CommandIssuer sender, String target, String issuerName, String reason, String expectedType) {
        if (expectedType != null) {
            this.tryPunishmentIdWithFallback(sender, target, issuerName, reason, expectedType);
        } else {
            this.tryPunishmentIdWithFallback(sender, target, issuerName, reason, null);
        }
    }

    private void tryPunishmentIdWithFallback(CommandIssuer sender, String target, String issuerName, String reason, String expectedType) {
        PardonPunishmentRequest request = new PardonPunishmentRequest(target, issuerName, reason.isEmpty() ? null : reason, expectedType);
        CompletableFuture<Void> future = this.httpClient.pardonPunishment(request);
        ((CompletableFuture)future.thenAccept(response -> {
            sender.sendMessage(this.localeManager.getMessage("pardon.success_id", Map.of("id", target)));
            String staffMessage = this.localeManager.getMessage("pardon.staff_notification_id", Map.of("issuer", issuerName, "id", target));
            this.platform.staffBroadcast(staffMessage);
            this.cache.clear();
        })).exceptionally(throwable -> {
            if (throwable.getCause() instanceof PanelUnavailableException) {
                sender.sendMessage(this.localeManager.getMessage("api_errors.panel_restarting"));
            } else {
                String errorMessage = throwable.getMessage();
                if (errorMessage != null && (errorMessage.contains("No player found with punishment ID") || errorMessage.contains("Punishment with ID") || errorMessage.contains("not found") || errorMessage.contains("404"))) {
                    if (expectedType != null) {
                        this.pardonByPlayerName(sender, target, issuerName, reason, expectedType);
                    } else {
                        this.pardonByPlayerName(sender, target, issuerName, reason, null);
                    }
                } else if (errorMessage.toLowerCase().contains("type")) {
                    if ("ban".equals(expectedType)) {
                        sender.sendMessage(this.localeManager.getMessage("pardon.error_wrong_type_ban", Map.of("id", target)));
                    } else if ("mute".equals(expectedType)) {
                        sender.sendMessage(this.localeManager.getMessage("pardon.error_wrong_type_mute", Map.of("id", target)));
                    } else {
                        sender.sendMessage(this.localeManager.getMessage("pardon.error", Map.of("error", errorMessage)));
                    }
                } else {
                    sender.sendMessage(this.localeManager.getMessage("pardon.error", Map.of("error", errorMessage)));
                }
            }
            return null;
        });
    }

    private boolean isPunishmentId(String target) {
        return target.length() == 8 && target.matches("^[A-F0-9]+$");
    }

    private void invalidatePlayerCache(String playerName, String type) {
        try {
            AbstractPlayer player = this.platform.getAbstractPlayer(playerName, false);
            if (player != null) {
                if ("ban".equals(type)) {
                    this.cache.removeBan(player.uuid());
                } else if ("mute".equals(type)) {
                    this.cache.removeMute(player.uuid());
                } else {
                    this.cache.removeBan(player.uuid());
                    this.cache.removeMute(player.uuid());
                }
            }
        }
        catch (Exception e) {
            this.cache.clear();
        }
    }

    @Generated
    public PardonCommand(ModlHttpClient httpClient, Platform platform, Cache cache, LocaleManager localeManager) {
        this.httpClient = httpClient;
        this.platform = platform;
        this.cache = cache;
        this.localeManager = localeManager;
    }
}

