/*
 * Decompiled with CFR 0.152.
 */
package gg.modl.minecraft.core.impl.commands.punishments;

import co.aikar.commands.BaseCommand;
import co.aikar.commands.CommandIssuer;
import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.CommandCompletion;
import co.aikar.commands.annotation.Description;
import co.aikar.commands.annotation.Name;
import co.aikar.commands.annotation.Syntax;
import gg.modl.minecraft.api.Account;
import gg.modl.minecraft.api.Punishment;
import gg.modl.minecraft.api.http.ModlHttpClient;
import gg.modl.minecraft.api.http.PanelUnavailableException;
import gg.modl.minecraft.api.http.request.PunishmentCreateRequest;
import gg.modl.minecraft.api.http.response.PunishmentCreateResponse;
import gg.modl.minecraft.api.http.response.PunishmentTypesResponse;
import gg.modl.minecraft.api.http.response.StaffPermissionsResponse;
import gg.modl.minecraft.core.Platform;
import gg.modl.minecraft.core.impl.cache.Cache;
import gg.modl.minecraft.core.locale.LocaleManager;
import gg.modl.minecraft.core.util.PermissionUtil;
import gg.modl.minecraft.core.util.WebPlayer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import lombok.Generated;

public class PunishCommand
extends BaseCommand {
    private final ModlHttpClient httpClient;
    private final Platform platform;
    private final Cache cache;
    private final LocaleManager localeManager;
    private volatile List<PunishmentTypesResponse.PunishmentTypeData> cachedPunishmentTypes = new ArrayList<PunishmentTypesResponse.PunishmentTypeData>();
    private volatile boolean cacheInitialized = false;
    private static final Set<String> VALID_SEVERITIES = Set.of("low", "regular", "severe");

    @CommandCompletion(value="@players @punishment-types")
    @CommandAlias(value="punish")
    @Syntax(value="<target> <type> [reason...] [-lenient|regular|severe] [-ab (alt block)] [-s (silent)] [-sw (stat-wipe)]")
    @Description(value="Issue a punishment to a player. Multi-word punishment types like 'Chat Abuse' are supported without quotes.")
    public void punish(CommandIssuer sender, @Name(value="target") Account target, @Name(value="args") String[] args) {
        String calculatedOffenseLevel;
        if (target == null) {
            sender.sendMessage(this.localeManager.getPunishmentMessage("general.player_not_found", Map.of()));
            return;
        }
        if (args == null || args.length == 0) {
            sender.sendMessage(this.localeManager.getPunishmentMessage("general.invalid_syntax", Map.of()));
            return;
        }
        if (!this.cacheInitialized || this.cachedPunishmentTypes.isEmpty()) {
            sender.sendMessage(this.localeManager.getPunishmentMessage("general.punishment_types_not_loaded", Map.of()));
            return;
        }
        List<PunishmentTypesResponse.PunishmentTypeData> punishmentTypes = this.cachedPunishmentTypes;
        ParsedCommand parsed = this.parsePunishmentTypeAndArgs(args, punishmentTypes);
        if (parsed == null) {
            String availableTypes = punishmentTypes.stream().map(PunishmentTypesResponse.PunishmentTypeData::getName).collect(Collectors.joining(", "));
            sender.sendMessage(this.localeManager.getPunishmentMessage("general.invalid_punishment_type", Map.of("types", availableTypes)));
            return;
        }
        PunishmentTypesResponse.PunishmentTypeData punishmentType = parsed.punishmentType;
        String punishmentPermission = PermissionUtil.formatPunishmentPermission(punishmentType.getName());
        if (!PermissionUtil.hasPermission(sender, this.cache, punishmentPermission)) {
            sender.sendMessage(this.localeManager.getPunishmentMessage("general.no_permission_punishment", Map.of("type", punishmentType.getName())));
            return;
        }
        PunishmentArgs punishmentArgs = this.parseArguments(parsed.remainingArgs);
        if (punishmentArgs.severity != null && !VALID_SEVERITIES.contains(punishmentArgs.severity)) {
            sender.sendMessage(this.localeManager.getMessage("punishment_commands.invalid_severity"));
            return;
        }
        String validationError = this.validatePunishmentCompatibility(punishmentArgs, punishmentType);
        if (validationError != null) {
            sender.sendMessage(validationError);
            return;
        }
        if (punishmentArgs.severity == null) {
            punishmentArgs.severity = "regular";
        }
        punishmentArgs.offenseLevel = calculatedOffenseLevel = this.calculateOffenseLevel(target, punishmentType);
        String issuerName = sender.isPlayer() ? this.platform.getAbstractPlayer(sender.getUniqueId(), false).username() : "Console";
        Map<String, Object> data = this.buildPunishmentData(punishmentArgs, punishmentType, target);
        ArrayList<String> notes = new ArrayList<String>();
        if (!punishmentArgs.reason.isEmpty()) {
            notes.add(punishmentArgs.reason);
        }
        PunishmentCreateRequest request = new PunishmentCreateRequest(target.getMinecraftUuid().toString(), issuerName, punishmentType.getOrdinal(), punishmentArgs.reason.isEmpty() ? "No reason specified" : punishmentArgs.reason, punishmentArgs.duration > 0L ? Long.valueOf(punishmentArgs.duration) : null, data, notes, new ArrayList<String>(), punishmentArgs.severity, punishmentArgs.offenseLevel);
        String punishmentTypeName = punishmentType.getName();
        boolean silentPunishment = punishmentArgs.silent;
        CompletableFuture<PunishmentCreateResponse> future = this.httpClient.createPunishmentWithResponse(request);
        ((CompletableFuture)future.thenAccept(response -> {
            if (response.isSuccess()) {
                String targetName = target.getUsernames().get(0).getUsername();
                sender.sendMessage(this.localeManager.punishment().type(punishmentTypeName).target(targetName).punishmentId(response.getPunishmentId()).get("general.punishment_issued"));
                String staffMessage = this.localeManager.punishment().issuer(issuerName).type(punishmentTypeName).target(targetName).punishmentId(response.getPunishmentId()).get("general.staff_notification");
                this.platform.staffBroadcast(staffMessage);
            } else {
                sender.sendMessage(this.localeManager.getPunishmentMessage("general.punishment_error", Map.of("error", response.getMessage())));
            }
        })).exceptionally(throwable -> {
            if (throwable.getCause() instanceof PanelUnavailableException) {
                sender.sendMessage(this.localeManager.getMessage("api_errors.panel_restarting"));
            } else {
                sender.sendMessage(this.localeManager.getPunishmentMessage("general.punishment_error", Map.of("error", throwable.getMessage())));
            }
            return null;
        });
    }

    public void initializePunishmentTypes() {
        ((CompletableFuture)this.httpClient.getPunishmentTypes().thenAccept(response -> {
            if (response.isSuccess()) {
                this.cachedPunishmentTypes = response.getData().stream().filter(pt -> pt.getOrdinal() > 5).collect(Collectors.toList());
                this.cacheInitialized = true;
                this.platform.runOnMainThread(() -> System.out.println("[MODL] Loaded " + this.cachedPunishmentTypes.size() + " punishment types from API"));
            } else {
                this.platform.runOnMainThread(() -> System.err.println("[MODL] Failed to load punishment types from API: " + response.getStatus()));
            }
        })).exceptionally(throwable -> {
            if (throwable.getCause() instanceof PanelUnavailableException) {
                this.platform.runOnMainThread(() -> System.err.println("[MODL] Panel restarting, cannot load punishment types: " + throwable.getMessage()));
            } else {
                this.platform.runOnMainThread(() -> System.err.println("[MODL] Error loading punishment types: " + throwable.getMessage()));
            }
            return null;
        });
        this.loadStaffPermissions();
    }

    private void loadStaffPermissions() {
        ((CompletableFuture)this.httpClient.getStaffPermissions().thenAccept(response -> {
            this.cache.clearStaffPermissions();
            for (StaffPermissionsResponse.StaffMember staffMember : response.getData().getStaff()) {
                if (staffMember.getMinecraftUuid() == null) continue;
                try {
                    UUID uuid = UUID.fromString(staffMember.getMinecraftUuid());
                    this.cache.cacheStaffPermissions(uuid, staffMember.getStaffRole(), staffMember.getPermissions());
                }
                catch (IllegalArgumentException e) {
                    this.platform.runOnMainThread(() -> System.out.println("[MODL] Invalid UUID for staff member " + staffMember.getStaffUsername() + ": " + staffMember.getMinecraftUuid()));
                }
            }
            this.platform.runOnMainThread(() -> System.out.println("[MODL] Loaded permissions for " + response.getData().getStaff().size() + " staff members"));
        })).exceptionally(throwable -> {
            if (throwable.getCause() instanceof PanelUnavailableException) {
                this.platform.runOnMainThread(() -> System.err.println("[MODL] Panel restarting, cannot load staff permissions: " + throwable.getMessage()));
            } else {
                this.platform.runOnMainThread(() -> System.err.println("[MODL] Error loading staff permissions: " + throwable.getMessage()));
            }
            return null;
        });
    }

    public List<String> getPunishmentTypeNames() {
        return this.cachedPunishmentTypes.stream().map(PunishmentTypesResponse.PunishmentTypeData::getName).collect(Collectors.toList());
    }

    public void updatePunishmentTypesCache(List<PunishmentTypesResponse.PunishmentTypeData> allTypes) {
        this.cachedPunishmentTypes = allTypes.stream().filter(pt -> pt.getOrdinal() > 5).collect(Collectors.toList());
        this.cacheInitialized = true;
    }

    private String getPublicNotificationMessage(String punishmentTypeName, String targetName, long duration, int ordinal, String reason) {
        PunishmentTypesResponse.PunishmentTypeData punishmentType = this.cachedPunishmentTypes.stream().filter(pt -> pt.getOrdinal() == ordinal).findFirst().orElse(null);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("target", targetName);
        variables.put("duration", this.localeManager.formatDuration(duration));
        variables.put("reason", reason != null ? reason : "No reason specified");
        variables.put("description", punishmentType != null ? punishmentType.getName() : punishmentTypeName);
        variables.put("appeal_url", this.localeManager.getMessage("config.appeal_url"));
        return this.localeManager.getPublicNotificationMessage(ordinal, variables);
    }

    private String getBasicPunishmentCategory(String punishmentTypeName) {
        String lower = punishmentTypeName.toLowerCase();
        if (lower.contains("kick")) {
            return "kick";
        }
        if (lower.contains("mute")) {
            return "mute";
        }
        if (lower.contains("ban")) {
            return "ban";
        }
        if (lower.contains("blacklist")) {
            return "blacklist";
        }
        return "ban";
    }

    private PunishmentArgs parseArguments(String args) {
        String[] arguments = args.split(" ");
        PunishmentArgs result = new PunishmentArgs();
        StringBuilder reasonBuilder = new StringBuilder();
        for (int i = 0; i < arguments.length; ++i) {
            String arg = arguments[i];
            if (arg.equalsIgnoreCase("-severity") && i + 1 < arguments.length) {
                String severityInput;
                switch (severityInput = arguments[++i].toLowerCase()) {
                    case "lenient": {
                        result.severity = "low";
                        break;
                    }
                    case "normal": 
                    case "regular": {
                        result.severity = "regular";
                        break;
                    }
                    case "aggravated": 
                    case "severe": {
                        result.severity = "severe";
                        break;
                    }
                    default: {
                        result.severity = severityInput;
                        break;
                    }
                }
                continue;
            }
            if (arg.equalsIgnoreCase("-lenient")) {
                result.severity = "low";
                continue;
            }
            if (arg.equalsIgnoreCase("-regular") || arg.equalsIgnoreCase("-normal")) {
                result.severity = "regular";
                continue;
            }
            if (arg.equalsIgnoreCase("-severe")) {
                result.severity = "severe";
                continue;
            }
            if (arg.equalsIgnoreCase("-alt-blocking") || arg.equalsIgnoreCase("-ab")) {
                result.altBlocking = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-silent") || arg.equalsIgnoreCase("-s")) {
                result.silent = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-stat-wipe") || arg.equalsIgnoreCase("-sw")) {
                result.statWipe = true;
                continue;
            }
            if (reasonBuilder.length() > 0) {
                reasonBuilder.append(" ");
            }
            reasonBuilder.append(arg);
        }
        result.reason = reasonBuilder.toString().trim();
        return result;
    }

    private Map<String, Object> buildPunishmentData(PunishmentArgs args, PunishmentTypesResponse.PunishmentTypeData punishmentType, Account target) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("duration", 0L);
        if (Boolean.TRUE.equals(punishmentType.getPermanentUntilUsernameChange())) {
            String currentUsername = target.getUsernames() != null && !target.getUsernames().isEmpty() ? target.getUsernames().get(target.getUsernames().size() - 1).getUsername() : "Unknown";
            data.put("blockedName", currentUsername);
        } else {
            data.put("blockedName", null);
        }
        if (Boolean.TRUE.equals(punishmentType.getPermanentUntilSkinChange())) {
            String currentSkinHash = null;
            try {
                WebPlayer webPlayer = WebPlayer.getSync(target.getMinecraftUuid());
                if (webPlayer != null && webPlayer.valid()) {
                    currentSkinHash = webPlayer.skin();
                }
            }
            catch (Exception e) {
                System.err.println("Failed to get skin hash for " + target.getUsernames().get(0).getUsername() + ": " + e.getMessage());
            }
            data.put("blockedSkin", currentSkinHash);
        } else {
            data.put("blockedSkin", null);
        }
        data.put("linkedBanId", null);
        data.put("linkedBanExpiry", null);
        data.put("chatLog", null);
        data.put("altBlocking", false);
        data.put("wipeAfterExpiry", false);
        data.put("silent", args.silent);
        long calculatedDuration = this.calculateDuration(args, punishmentType);
        if (calculatedDuration > 0L) {
            data.put("duration", calculatedDuration);
        }
        if (Boolean.TRUE.equals(punishmentType.getCanBeAltBlocking()) && args.altBlocking) {
            data.put("altBlocking", true);
        }
        if (Boolean.TRUE.equals(punishmentType.getCanBeStatWiping()) && args.statWipe) {
            data.put("wipeAfterExpiry", true);
        }
        return data;
    }

    private long calculateDuration(PunishmentArgs args, PunishmentTypesResponse.PunishmentTypeData punishmentType) {
        if (args.duration > 0L) {
            return args.duration;
        }
        return 0L;
    }

    private String validatePunishmentCompatibility(PunishmentArgs args, PunishmentTypesResponse.PunishmentTypeData punishmentType) {
        if (Boolean.TRUE.equals(punishmentType.getSingleSeverityPunishment()) && args.severity != null) {
            return this.localeManager.getPunishmentMessage("validation.single_severity_error", Map.of("type", punishmentType.getName()));
        }
        if (Boolean.TRUE.equals(punishmentType.getPermanentUntilSkinChange()) && args.severity != null) {
            return this.localeManager.getPunishmentMessage("validation.permanent_skin_change_error", Map.of("type", punishmentType.getName()));
        }
        if (Boolean.TRUE.equals(punishmentType.getPermanentUntilUsernameChange()) && args.severity != null) {
            return this.localeManager.getPunishmentMessage("validation.permanent_username_change_error", Map.of("type", punishmentType.getName()));
        }
        if (args.altBlocking && !Boolean.TRUE.equals(punishmentType.getCanBeAltBlocking())) {
            return this.localeManager.getPunishmentMessage("validation.alt_blocking_not_supported", Map.of("type", punishmentType.getName()));
        }
        if (args.statWipe && !Boolean.TRUE.equals(punishmentType.getCanBeStatWiping())) {
            return this.localeManager.getPunishmentMessage("validation.stat_wiping_not_supported", Map.of("type", punishmentType.getName()));
        }
        return null;
    }

    private String calculateOffenseLevel(Account target, PunishmentTypesResponse.PunishmentTypeData punishmentType) {
        PlayerStatus status = this.calculatePlayerStatus(target, punishmentType.getCategory());
        switch (status.ordinal()) {
            case 0: {
                return "low";
            }
            case 1: {
                return "medium";
            }
            case 2: {
                return "habitual";
            }
        }
        return "low";
    }

    private PlayerStatus calculatePlayerStatus(Account target, String category) {
        int totalPoints = 0;
        for (Punishment punishment : target.getPunishments()) {
            if (!this.isActivePunishment(punishment)) continue;
            totalPoints += this.getPunishmentPoints(punishment);
        }
        if ("Social".equalsIgnoreCase(category)) {
            if (totalPoints >= 8) {
                return PlayerStatus.HABITUAL;
            }
            if (totalPoints >= 4) {
                return PlayerStatus.MEDIUM;
            }
            return PlayerStatus.LOW;
        }
        if (totalPoints >= 10) {
            return PlayerStatus.HABITUAL;
        }
        if (totalPoints >= 5) {
            return PlayerStatus.MEDIUM;
        }
        return PlayerStatus.LOW;
    }

    private boolean isActivePunishment(Object punishment) {
        return true;
    }

    private int getPunishmentPoints(Object punishment) {
        return 1;
    }

    private String getWarningMessage(String punishmentTypeName, String username) {
        return this.localeManager.getMessage("punishment_commands.warning_message", Map.of("username", username, "punishment_type", punishmentTypeName.toLowerCase()));
    }

    private ParsedCommand parsePunishmentTypeAndArgs(String[] args, List<PunishmentTypesResponse.PunishmentTypeData> punishmentTypes) {
        for (int i = Math.min(args.length, 4); i >= 1; --i) {
            String potentialType = String.join((CharSequence)" ", Arrays.copyOfRange(args, 0, i));
            Optional<PunishmentTypesResponse.PunishmentTypeData> matchedType = punishmentTypes.stream().filter(pt -> pt.getName().equalsIgnoreCase(potentialType)).findFirst();
            if (!matchedType.isPresent()) continue;
            String remainingArgs = "";
            if (i < args.length) {
                remainingArgs = String.join((CharSequence)" ", Arrays.copyOfRange(args, i, args.length));
            }
            return new ParsedCommand(matchedType.get(), remainingArgs);
        }
        return null;
    }

    @Generated
    public PunishCommand(ModlHttpClient httpClient, Platform platform, Cache cache, LocaleManager localeManager) {
        this.httpClient = httpClient;
        this.platform = platform;
        this.cache = cache;
        this.localeManager = localeManager;
    }

    private static class ParsedCommand {
        PunishmentTypesResponse.PunishmentTypeData punishmentType;
        String remainingArgs;

        ParsedCommand(PunishmentTypesResponse.PunishmentTypeData punishmentType, String remainingArgs) {
            this.punishmentType = punishmentType;
            this.remainingArgs = remainingArgs;
        }
    }

    private static class PunishmentArgs {
        String severity = null;
        String offenseLevel = null;
        String reason = "";
        long duration = 0L;
        boolean altBlocking = false;
        boolean silent = false;
        boolean statWipe = false;

        private PunishmentArgs() {
        }
    }

    private static enum PlayerStatus {
        LOW,
        MEDIUM,
        HABITUAL;

    }
}

