/*
 * Decompiled with CFR 0.152.
 */
package gg.modl.minecraft.core.impl.commands.punishments;

import co.aikar.commands.BaseCommand;
import co.aikar.commands.CommandIssuer;
import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.CommandCompletion;
import co.aikar.commands.annotation.Default;
import co.aikar.commands.annotation.Name;
import co.aikar.commands.annotation.Syntax;
import gg.modl.minecraft.api.AbstractPlayer;
import gg.modl.minecraft.api.Account;
import gg.modl.minecraft.api.http.ModlHttpClient;
import gg.modl.minecraft.api.http.PanelUnavailableException;
import gg.modl.minecraft.api.http.request.CreatePlayerNoteRequest;
import gg.modl.minecraft.core.Platform;
import gg.modl.minecraft.core.impl.cache.Cache;
import gg.modl.minecraft.core.locale.LocaleManager;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;

public class WarnCommand
extends BaseCommand {
    private final ModlHttpClient httpClient;
    private final Platform platform;
    private final Cache cache;
    private final LocaleManager localeManager;

    @CommandCompletion(value="@players")
    @CommandAlias(value="warn")
    @Syntax(value="<target> <reason...> [-silent]")
    public void warn(CommandIssuer sender, @Name(value="target") Account target, @Default(value="") String args) {
        if (target == null) {
            sender.sendMessage(this.localeManager.getPunishmentMessage("general.player_not_found", Map.of()));
            return;
        }
        WarnArgs warnArgs = this.parseArguments(args);
        if (warnArgs.reason.isEmpty()) {
            sender.sendMessage(this.localeManager.getPunishmentMessage("general.invalid_syntax", Map.of()));
            return;
        }
        String issuerName = sender.isPlayer() ? this.platform.getAbstractPlayer(sender.getUniqueId(), false).username() : "Console";
        String noteText = String.format("WARNING: %s (by %s)", warnArgs.reason, issuerName);
        CreatePlayerNoteRequest noteRequest = new CreatePlayerNoteRequest(target.getMinecraftUuid().toString(), issuerName, noteText);
        CompletableFuture<Void> future = this.httpClient.createPlayerNote(noteRequest);
        ((CompletableFuture)future.thenAccept(response -> {
            String targetName = target.getUsernames().get(0).getUsername();
            AbstractPlayer targetPlayer = this.platform.getAbstractPlayer(target.getMinecraftUuid(), false);
            if (targetPlayer != null && targetPlayer.isOnline()) {
                String warningMessage = this.localeManager.getMessage("warn.player_message", Map.of("issuer", issuerName, "reason", warnArgs.reason));
                this.platform.sendMessage(target.getMinecraftUuid(), warningMessage);
            }
            sender.sendMessage(this.localeManager.getMessage("warn.success", Map.of("target", targetName, "reason", warnArgs.reason)));
            if (!warnArgs.silent) {
                String staffMessage = this.localeManager.getMessage("warn.staff_notification", Map.of("issuer", issuerName, "target", targetName, "reason", warnArgs.reason));
                this.platform.staffBroadcast(staffMessage);
            }
        })).exceptionally(throwable -> {
            if (throwable.getCause() instanceof PanelUnavailableException) {
                sender.sendMessage(this.localeManager.getMessage("api_errors.panel_restarting"));
            } else {
                sender.sendMessage(this.localeManager.getMessage("warn.error", Map.of("error", throwable.getMessage())));
            }
            return null;
        });
    }

    private WarnArgs parseArguments(String args) {
        String[] arguments = args.split(" ");
        WarnArgs result = new WarnArgs();
        StringBuilder reasonBuilder = new StringBuilder();
        for (String arg : arguments) {
            if (arg.equalsIgnoreCase("-silent") || arg.equalsIgnoreCase("-s")) {
                result.silent = true;
                continue;
            }
            if (reasonBuilder.length() > 0) {
                reasonBuilder.append(" ");
            }
            reasonBuilder.append(arg);
        }
        result.reason = reasonBuilder.toString().trim();
        return result;
    }

    @Generated
    public WarnCommand(ModlHttpClient httpClient, Platform platform, Cache cache, LocaleManager localeManager) {
        this.httpClient = httpClient;
        this.platform = platform;
        this.cache = cache;
        this.localeManager = localeManager;
    }

    private static class WarnArgs {
        String reason = "";
        boolean silent = false;

        private WarnArgs() {
        }
    }
}

