/*
 * Decompiled with CFR 0.152.
 */
package gg.modl.minecraft.core.impl.http;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import gg.modl.minecraft.api.http.ModlHttpClient;
import gg.modl.minecraft.api.http.PanelUnavailableException;
import gg.modl.minecraft.api.http.request.CreatePlayerNoteRequest;
import gg.modl.minecraft.api.http.request.CreatePunishmentRequest;
import gg.modl.minecraft.api.http.request.CreateTicketRequest;
import gg.modl.minecraft.api.http.request.NotificationAcknowledgeRequest;
import gg.modl.minecraft.api.http.request.PardonPlayerRequest;
import gg.modl.minecraft.api.http.request.PardonPunishmentRequest;
import gg.modl.minecraft.api.http.request.PlayerDisconnectRequest;
import gg.modl.minecraft.api.http.request.PlayerGetRequest;
import gg.modl.minecraft.api.http.request.PlayerLoginRequest;
import gg.modl.minecraft.api.http.request.PlayerLookupRequest;
import gg.modl.minecraft.api.http.request.PlayerNameRequest;
import gg.modl.minecraft.api.http.request.PlayerNoteCreateRequest;
import gg.modl.minecraft.api.http.request.PunishmentAcknowledgeRequest;
import gg.modl.minecraft.api.http.request.PunishmentCreateRequest;
import gg.modl.minecraft.api.http.request.SyncRequest;
import gg.modl.minecraft.api.http.response.CreateTicketResponse;
import gg.modl.minecraft.api.http.response.LinkedAccountsResponse;
import gg.modl.minecraft.api.http.response.PlayerGetResponse;
import gg.modl.minecraft.api.http.response.PlayerLoginResponse;
import gg.modl.minecraft.api.http.response.PlayerLookupResponse;
import gg.modl.minecraft.api.http.response.PlayerNameResponse;
import gg.modl.minecraft.api.http.response.PlayerNoteCreateResponse;
import gg.modl.minecraft.api.http.response.PlayerProfileResponse;
import gg.modl.minecraft.api.http.response.PunishmentCreateResponse;
import gg.modl.minecraft.api.http.response.PunishmentTypesResponse;
import gg.modl.minecraft.api.http.response.StaffPermissionsResponse;
import gg.modl.minecraft.api.http.response.SyncResponse;
import gg.modl.minecraft.core.util.CircuitBreaker;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.Instant;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class ModlHttpClientImpl
implements ModlHttpClient {
    @NotNull
    private final String baseUrl;
    @NotNull
    private final String apiKey;
    @NotNull
    private final HttpClient httpClient;
    @NotNull
    private final Gson gson;
    @NotNull
    private final Logger logger;
    private final boolean debugMode;
    @NotNull
    private final CircuitBreaker circuitBreaker;

    public ModlHttpClientImpl(@NotNull String baseUrl, @NotNull String apiKey) {
        this(baseUrl, apiKey, false);
    }

    public ModlHttpClientImpl(@NotNull String baseUrl, @NotNull String apiKey, boolean debugMode) {
        this.baseUrl = baseUrl;
        this.apiKey = apiKey;
        this.debugMode = debugMode;
        this.circuitBreaker = new CircuitBreaker("modl-panel");
        ThreadFactory httpThreadFactory = r -> {
            Thread t = new Thread(r, "modl-http-client");
            t.setDaemon(true);
            t.setPriority(5);
            return t;
        };
        this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).executor(Executors.newCachedThreadPool(httpThreadFactory)).followRedirects(HttpClient.Redirect.NORMAL).build();
        this.gson = new Gson();
        this.logger = Logger.getLogger(ModlHttpClientImpl.class.getName());
    }

    @Override
    @NotNull
    public CompletableFuture<PlayerProfileResponse> getPlayerProfile(@NotNull UUID uuid) {
        return this.sendAsync(HttpRequest.newBuilder().uri(URI.create(this.baseUrl + "/minecraft/player/" + String.valueOf(uuid))).header("X-API-Key", this.apiKey).build(), PlayerProfileResponse.class);
    }

    @Override
    @NotNull
    public CompletableFuture<LinkedAccountsResponse> getLinkedAccounts(@NotNull UUID uuid) {
        return this.sendAsync(HttpRequest.newBuilder().uri(URI.create(this.baseUrl + "/minecraft/player/" + String.valueOf(uuid) + "/linked-accounts")).header("X-API-Key", this.apiKey).build(), LinkedAccountsResponse.class);
    }

    @Override
    @NotNull
    public CompletableFuture<PlayerLoginResponse> playerLogin(@NotNull PlayerLoginRequest request) {
        String requestBody = this.gson.toJson(request);
        if (this.debugMode) {
            this.logger.info(String.format("Player login request body: %s", requestBody));
        }
        return this.sendAsync(HttpRequest.newBuilder().uri(URI.create(this.baseUrl + "/minecraft/player/login")).header("X-API-Key", this.apiKey).header("Content-Type", "application/json").timeout(Duration.ofSeconds(15L)).POST(HttpRequest.BodyPublishers.ofString(requestBody)).build(), PlayerLoginResponse.class, "LOGIN");
    }

    @Override
    @NotNull
    public CompletableFuture<Void> playerDisconnect(@NotNull PlayerDisconnectRequest request) {
        return this.sendAsync(HttpRequest.newBuilder().uri(URI.create(this.baseUrl + "/minecraft/player/disconnect")).header("X-API-Key", this.apiKey).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(this.gson.toJson(request))).build(), Void.class);
    }

    @Override
    @NotNull
    public CompletableFuture<CreateTicketResponse> createTicket(@NotNull CreateTicketRequest request) {
        return this.sendAsync(HttpRequest.newBuilder().uri(URI.create(this.baseUrl + "/public/tickets")).header("X-Ticket-API-Key", this.apiKey).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(this.gson.toJson(request))).build(), CreateTicketResponse.class);
    }

    @Override
    @NotNull
    public CompletableFuture<CreateTicketResponse> createUnfinishedTicket(@NotNull CreateTicketRequest request) {
        String requestBody = this.gson.toJson(request);
        String url = this.baseUrl + "/public/tickets/unfinished";
        if (this.debugMode) {
            this.logger.info(String.format("Create unfinished ticket request URL: %s", url));
            this.logger.info(String.format("Create unfinished ticket request body: %s", requestBody));
        }
        return this.sendAsync(HttpRequest.newBuilder().uri(URI.create(url)).header("Content-Type", "application/json").header("X-API-Key", this.apiKey).POST(HttpRequest.BodyPublishers.ofString(requestBody)).build(), CreateTicketResponse.class, "CREATE_UNFINISHED_TICKET");
    }

    @Override
    @NotNull
    public CompletableFuture<Void> createPunishment(@NotNull CreatePunishmentRequest request) {
        return this.sendAsync(HttpRequest.newBuilder().uri(URI.create(this.baseUrl + "/minecraft/punishment/create")).header("X-API-Key", this.apiKey).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(this.gson.toJson(request))).build(), Void.class);
    }

    @Override
    @NotNull
    public CompletableFuture<Void> createPlayerNote(@NotNull CreatePlayerNoteRequest request) {
        return this.sendAsync(HttpRequest.newBuilder().uri(URI.create(this.baseUrl + "/minecraft/player/note/create")).header("X-API-Key", this.apiKey).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(this.gson.toJson(request))).build(), Void.class);
    }

    @Override
    @NotNull
    public CompletableFuture<PunishmentCreateResponse> createPunishmentWithResponse(@NotNull PunishmentCreateRequest request) {
        return this.sendAsync(HttpRequest.newBuilder().uri(URI.create(this.baseUrl + "/minecraft/punishment/dynamic")).header("X-API-Key", this.apiKey).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(this.gson.toJson(request))).build(), PunishmentCreateResponse.class);
    }

    @Override
    @NotNull
    public CompletableFuture<PlayerGetResponse> getPlayer(@NotNull PlayerGetRequest request) {
        return this.sendAsync(HttpRequest.newBuilder().uri(URI.create(this.baseUrl + "/minecraft/player?minecraftUuid=" + request.getMinecraftUuid())).header("X-API-Key", this.apiKey).GET().build(), PlayerGetResponse.class);
    }

    @Override
    @NotNull
    public CompletableFuture<PlayerNameResponse> getPlayer(@NotNull PlayerNameRequest request) {
        return this.sendAsync(HttpRequest.newBuilder().uri(URI.create(this.baseUrl + "/minecraft/player-name?username=" + request.getMinecraftUsername())).header("X-API-Key", this.apiKey).GET().build(), PlayerNameResponse.class);
    }

    @Override
    @NotNull
    public CompletableFuture<PlayerNoteCreateResponse> createPlayerNoteWithResponse(@NotNull PlayerNoteCreateRequest request) {
        return this.sendAsync(HttpRequest.newBuilder().uri(URI.create(this.baseUrl + "/minecraft/player/" + request.getTargetUuid() + "/notes")).header("X-API-Key", this.apiKey).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(this.gson.toJson(request))).build(), PlayerNoteCreateResponse.class);
    }

    @Override
    @NotNull
    public CompletableFuture<SyncResponse> sync(@NotNull SyncRequest request) {
        String requestBody = this.gson.toJson(request);
        if (this.debugMode) {
            this.logger.info(String.format("Sync request body: %s", requestBody));
        }
        return this.sendAsync(HttpRequest.newBuilder().uri(URI.create(this.baseUrl + "/minecraft/sync")).header("X-API-Key", this.apiKey).header("Content-Type", "application/json").timeout(Duration.ofSeconds(20L)).POST(HttpRequest.BodyPublishers.ofString(requestBody)).build(), SyncResponse.class, "SYNC");
    }

    @Override
    @NotNull
    public CompletableFuture<Void> acknowledgePunishment(@NotNull PunishmentAcknowledgeRequest request) {
        return this.sendAsync(HttpRequest.newBuilder().uri(URI.create(this.baseUrl + "/minecraft/punishment/acknowledge")).header("X-API-Key", this.apiKey).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(this.gson.toJson(request))).build(), Void.class);
    }

    @Override
    @NotNull
    public CompletableFuture<Void> acknowledgeNotifications(@NotNull NotificationAcknowledgeRequest request) {
        return this.sendAsync(HttpRequest.newBuilder().uri(URI.create(this.baseUrl + "/minecraft/notification/acknowledge")).header("X-API-Key", this.apiKey).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(this.gson.toJson(request))).build(), Void.class);
    }

    private <T> CompletableFuture<T> sendAsync(HttpRequest request, Class<T> responseType) {
        return this.sendAsync(request, responseType, null);
    }

    private <T> CompletableFuture<T> sendAsync(HttpRequest request, Class<T> responseType, String operation) {
        Instant startTime = Instant.now();
        String requestId = this.generateRequestId();
        if (!this.circuitBreaker.allowRequest()) {
            this.logger.warning(String.format("[REQ-%s] Circuit breaker is OPEN - blocking request to %s", requestId, request.uri()));
            return CompletableFuture.failedFuture(new PanelUnavailableException(503, request.uri().getPath(), "Panel is temporarily unavailable (circuit breaker open)"));
        }
        if (this.debugMode) {
            this.logger.info(String.format("[REQ-%s] %s %s", requestId, request.method(), request.uri()));
            this.logger.info(String.format("[REQ-%s] Headers: %s", requestId, request.headers().map()));
            request.bodyPublisher().ifPresent(body -> this.logger.info(String.format("[REQ-%s] Body present: %s", requestId, body.getClass().getSimpleName())));
        }
        return ((CompletableFuture)this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(response -> {
            String errorMessage;
            Duration duration = Duration.between(startTime, Instant.now());
            if (this.debugMode) {
                this.logger.info(String.format("[RES-%s] Status: %d (took %dms)", requestId, response.statusCode(), duration.toMillis()));
                this.logger.info(String.format("[RES-%s] Headers: %s", requestId, response.headers().map()));
                String body = (String)response.body();
                if (body != null && !body.isEmpty()) {
                    if ("LOGIN".equals(operation) || body.length() <= 1000) {
                        this.logger.info(String.format("[RES-%s] Body: %s", requestId, body));
                    } else {
                        this.logger.info(String.format("[RES-%s] Body: %s... (truncated, %d chars total)", requestId, body.substring(0, 1000), body.length()));
                    }
                }
            }
            if (response.statusCode() >= 200 && response.statusCode() < 300) {
                this.circuitBreaker.recordSuccess();
                if (responseType == Void.class) {
                    return null;
                }
                try {
                    Object result = this.gson.fromJson((String)response.body(), responseType);
                    if (this.debugMode) {
                        this.logger.info(String.format("[REQ-%s] Successfully parsed response to %s", requestId, responseType.getSimpleName()));
                    }
                    return result;
                }
                catch (Exception e) {
                    this.logger.severe(String.format("[REQ-%s] Failed to parse response: %s", requestId, e.getMessage()));
                    throw new RuntimeException("Failed to parse response: " + e.getMessage(), e);
                }
            }
            try {
                JsonObject errorResponse = this.gson.fromJson((String)response.body(), JsonObject.class);
                errorMessage = errorResponse != null && errorResponse.has("message") ? errorResponse.get("message").getAsString() : String.format("Request failed with status code %d: %s", response.statusCode(), response.body());
            }
            catch (Exception e) {
                errorMessage = String.format("Request failed with status code %d: %s", response.statusCode(), response.body());
            }
            this.circuitBreaker.recordFailure();
            if (response.statusCode() == 502) {
                this.logger.warning(String.format("[REQ-%s] Panel returned 502 (Bad Gateway) - likely restarting. Endpoint: %s", requestId, request.uri().getPath()));
                throw new PanelUnavailableException(502, request.uri().getPath(), "Panel is temporarily unavailable (502 Bad Gateway)");
            }
            if (response.statusCode() == 401 || response.statusCode() == 403) {
                this.logger.severe(String.format("[REQ-%s] Authentication failed - check API key", requestId));
            } else if (response.statusCode() == 404) {
                this.logger.severe(String.format("[REQ-%s] Endpoint not found - check API URL", requestId));
            }
            this.logger.warning(String.format("[REQ-%s] %s", requestId, errorMessage));
            throw new RuntimeException(errorMessage);
        })).exceptionally(throwable -> {
            Duration duration = Duration.between(startTime, Instant.now());
            this.logger.severe(String.format("[REQ-%s] Request failed after %dms: %s", requestId, duration.toMillis(), throwable.getMessage()));
            if (!(throwable instanceof PanelUnavailableException)) {
                this.circuitBreaker.recordFailure();
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException("HTTP request failed", (Throwable)throwable);
        });
    }

    @Override
    @NotNull
    public CompletableFuture<PunishmentTypesResponse> getPunishmentTypes() {
        return this.sendAsync(HttpRequest.newBuilder().uri(URI.create(this.baseUrl + "/minecraft/punishment-types")).header("X-API-Key", this.apiKey).GET().build(), PunishmentTypesResponse.class);
    }

    @Override
    public CompletableFuture<StaffPermissionsResponse> getStaffPermissions() {
        return this.sendAsync(HttpRequest.newBuilder().uri(URI.create(this.baseUrl + "/minecraft/staff-permissions")).header("X-API-Key", this.apiKey).GET().build(), StaffPermissionsResponse.class);
    }

    @Override
    public CompletableFuture<PlayerLookupResponse> lookupPlayer(@NotNull PlayerLookupRequest request) {
        return this.sendAsync(HttpRequest.newBuilder().uri(URI.create(this.baseUrl + "/minecraft/player-lookup")).header("X-API-Key", this.apiKey).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(this.gson.toJson(request))).build(), PlayerLookupResponse.class);
    }

    @Override
    public CompletableFuture<Void> pardonPunishment(@NotNull PardonPunishmentRequest request) {
        return this.sendAsync(HttpRequest.newBuilder().uri(URI.create(this.baseUrl + "/minecraft/punishment/" + request.getPunishmentId() + "/pardon")).header("X-API-Key", this.apiKey).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(this.gson.toJson(request))).build(), Void.class);
    }

    @Override
    public CompletableFuture<Void> pardonPlayer(@NotNull PardonPlayerRequest request) {
        return this.sendAsync(HttpRequest.newBuilder().uri(URI.create(this.baseUrl + "/minecraft/player/pardon")).header("X-API-Key", this.apiKey).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(this.gson.toJson(request))).build(), Void.class);
    }

    private String generateRequestId() {
        return String.valueOf(System.nanoTime() % 1000000L);
    }
}

