/*
 * Decompiled with CFR 0.152.
 */
package gg.modl.minecraft.core.impl.menus;

import dev.simplix.cirrus.item.CirrusItem;
import dev.simplix.cirrus.menus.SimpleMenu;
import dev.simplix.cirrus.model.Click;
import dev.simplix.protocolize.api.chat.ChatElement;
import dev.simplix.protocolize.data.ItemType;
import dev.simplix.protocolize.data.inventory.InventoryType;
import gg.modl.minecraft.api.AbstractPlayer;
import gg.modl.minecraft.api.http.ModlHttpClient;
import gg.modl.minecraft.api.http.request.CreateTicketRequest;
import gg.modl.minecraft.api.http.response.CreateTicketResponse;
import gg.modl.minecraft.core.Platform;
import gg.modl.minecraft.core.locale.LocaleManager;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class ReportMenu
extends SimpleMenu {
    private final AbstractPlayer hero;
    private final AbstractPlayer villain;
    private final String data;
    private final ModlHttpClient httpClient;
    private final LocaleManager locale;
    private final Platform platform;
    private final String panelUrl;

    public ReportMenu(AbstractPlayer hero, AbstractPlayer villain, String data, ModlHttpClient httpClient, LocaleManager locale, Platform platform, String panelUrl) {
        this.hero = hero;
        this.villain = villain;
        this.data = data;
        this.httpClient = httpClient;
        this.locale = locale;
        this.platform = platform;
        this.panelUrl = panelUrl;
        this.title(locale.getMessage("report_gui.title", Map.of("$villain", villain.username())));
        this.type(InventoryType.GENERIC_9X3);
        this.buildMenu();
    }

    private void buildMenu() {
        this.createCategoryItem("chat_violation", "chat_report");
        this.createCategoryItem("username", "username_report");
        this.createCategoryItem("skin", "skin_report");
        this.createCategoryItem("content", "content_report");
        this.createCategoryItem("team_griefing", "team_report");
        this.createCategoryItem("game_rules", "game_report");
        this.createCategoryItem("cheating", "cheating_report");
        LocaleManager.ReportCategory closeButton = this.locale.getCloseButton();
        List<ChatElement<?>> closeLore = closeButton.getLore().stream().map(ChatElement::ofLegacyText).collect(Collectors.toList());
        this.set(CirrusItem.of(ItemType.valueOf((String)closeButton.getItemType()), ChatElement.ofLegacyText((String)closeButton.getName()), closeLore).slot(closeButton.getSlot()).actionHandler("close"));
    }

    private void createCategoryItem(String categoryName, String actionHandler) {
        LocaleManager.ReportCategory category = this.locale.getReportCategory(categoryName, this.villain.username());
        List<ChatElement<?>> lore = category.getLore().stream().map(ChatElement::ofLegacyText).collect(Collectors.toList());
        this.set(CirrusItem.of(ItemType.valueOf((String)category.getItemType()), ChatElement.ofLegacyText((String)category.getName()), lore).slot(category.getSlot()).actionHandler(actionHandler));
    }

    @Override
    protected void registerActionHandlers() {
        this.registerActionHandler("chat_report", (Click click) -> {
            click.clickedMenu().close();
            LocaleManager.ReportCategory category = this.locale.getReportCategory("chat_violation", this.villain.username());
            this.submitReport(category.getReportType(), category.getSubject());
        });
        this.registerActionHandler("username_report", (Click click) -> {
            click.clickedMenu().close();
            LocaleManager.ReportCategory category = this.locale.getReportCategory("username", this.villain.username());
            this.submitReport(category.getReportType(), category.getSubject());
        });
        this.registerActionHandler("skin_report", (Click click) -> {
            click.clickedMenu().close();
            LocaleManager.ReportCategory category = this.locale.getReportCategory("skin", this.villain.username());
            this.submitReport(category.getReportType(), category.getSubject());
        });
        this.registerActionHandler("content_report", (Click click) -> {
            click.clickedMenu().close();
            LocaleManager.ReportCategory category = this.locale.getReportCategory("content", this.villain.username());
            this.submitReport(category.getReportType(), category.getSubject());
        });
        this.registerActionHandler("team_report", (Click click) -> {
            click.clickedMenu().close();
            LocaleManager.ReportCategory category = this.locale.getReportCategory("team_griefing", this.villain.username());
            this.submitReport(category.getReportType(), category.getSubject());
        });
        this.registerActionHandler("game_report", (Click click) -> {
            click.clickedMenu().close();
            LocaleManager.ReportCategory category = this.locale.getReportCategory("game_rules", this.villain.username());
            this.submitReport(category.getReportType(), category.getSubject());
        });
        this.registerActionHandler("cheating_report", (Click click) -> {
            click.clickedMenu().close();
            LocaleManager.ReportCategory category = this.locale.getReportCategory("cheating", this.villain.username());
            this.submitReport(category.getReportType(), category.getSubject());
        });
        this.registerActionHandler("close", (Click click) -> click.clickedMenu().close());
    }

    private void submitReport(String type, String subject) {
        CreateTicketRequest request = new CreateTicketRequest(this.hero.uuid().toString(), this.hero.username(), type, subject + ": " + this.villain.username(), this.data != null ? this.data : this.locale.getMessage("messages.no_details", Map.of()), this.villain.uuid().toString(), this.villain.username(), null, List.of(), "normal");
        this.sendMessage(this.locale.getMessage("messages.submitting", Map.of("type", "report")));
        CompletableFuture<CreateTicketResponse> future = this.httpClient.createTicket(request);
        ((CompletableFuture)future.thenAccept(response -> {
            if (response.isSuccess() && response.getTicketId() != null) {
                this.sendMessage(this.locale.getMessage("messages.success", Map.of("type", "Report")));
                this.sendMessage(this.locale.getMessage("messages.ticket_id", Map.of("ticketId", response.getTicketId())));
                String ticketUrl = this.panelUrl + "/tickets/" + response.getTicketId();
                this.sendMessage(this.locale.getMessage("messages.view_ticket", Map.of("url", ticketUrl)));
                this.sendMessage(this.locale.getMessage("messages.evidence_note"));
            } else {
                String error = response.getMessage() != null ? response.getMessage() : this.locale.getMessage("messages.unknown_error");
                this.sendMessage(this.locale.getMessage("messages.failed_submit", Map.of("type", "report", "error", error)));
            }
        })).exceptionally(throwable -> {
            this.sendMessage(this.locale.getMessage("messages.failed_submit", Map.of("type", "report", "error", throwable.getMessage())));
            return null;
        });
    }

    private void sendMessage(String message) {
        this.platform.sendMessage(this.hero.uuid(), message);
    }
}

