/*
 * Decompiled with CFR 0.152.
 */
package gg.modl.minecraft.core.locale;

import gg.modl.minecraft.api.SimplePunishment;
import gg.modl.minecraft.core.util.PunishmentMessages;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.yaml.snakeyaml.Yaml;

public class LocaleManager {
    private Map<String, Object> messages;
    private final String currentLocale;

    public LocaleManager(String locale) {
        this.currentLocale = locale;
        this.messages = new HashMap<String, Object>();
        this.loadLocale(locale);
    }

    public LocaleManager() {
        this("en_US");
    }

    private void loadLocale(String locale) {
        try {
            String resourcePath = "/locale/" + locale + ".yml";
            InputStream resourceStream = this.getClass().getResourceAsStream(resourcePath);
            if (resourceStream == null) {
                throw new RuntimeException("Locale file not found: " + resourcePath);
            }
            Yaml yaml = new Yaml();
            this.messages = (Map)yaml.load(resourceStream);
            resourceStream.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load locale: " + locale, e);
        }
    }

    public void loadFromFile(Path localeFile) {
        try {
            if (Files.exists(localeFile, new LinkOption[0])) {
                Yaml yaml = new Yaml();
                this.messages.putAll((Map)yaml.load(Files.newInputStream(localeFile, new OpenOption[0])));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load locale from file: " + String.valueOf(localeFile), e);
        }
    }

    public String getMessage(String path) {
        return this.getMessage(path, new HashMap<String, String>());
    }

    public String getMessage(String path, Map<String, String> placeholders) {
        Object value = this.getNestedValue(this.messages, path);
        if (value instanceof String) {
            String message = (String)value;
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                message = message.replace("{" + entry.getKey() + "}", entry.getValue());
            }
            return this.colorize(message);
        }
        return "&cMissing locale: " + path;
    }

    public List<String> getMessageList(String path) {
        return this.getMessageList(path, new HashMap<String, String>());
    }

    public List<String> getMessageList(String path, Map<String, String> placeholders) {
        Object value = this.getNestedValue(this.messages, path);
        if (value instanceof List) {
            List list = (List)value;
            return list.stream().map(line -> {
                for (Map.Entry entry : placeholders.entrySet()) {
                    line = line.replace("{" + (String)entry.getKey() + "}", (CharSequence)entry.getValue());
                }
                return this.colorize((String)line);
            }).toList();
        }
        return List.of("&cMissing locale list: " + path);
    }

    public String getItemType(String path) {
        Object value = this.getNestedValue(this.messages, path);
        return value instanceof String ? (String)value : "STONE";
    }

    public int getInteger(String path, int defaultValue) {
        Object value = this.getNestedValue(this.messages, path);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public String getPriority(String reportType) {
        return this.getMessage("priorities." + reportType, Map.of("type", reportType));
    }

    public ReportCategory getReportCategory(String categoryName, String targetPlayer) {
        Map<String, String> placeholders = Map.of("player", targetPlayer);
        String basePath = "report_gui.categories." + categoryName;
        return new ReportCategory(this.getItemType(basePath + ".item"), this.getInteger(basePath + ".slot", 0), this.getMessage(basePath + ".name", placeholders), this.getMessageList(basePath + ".lore", placeholders), this.getMessage(basePath + ".report_type"), this.getMessage(basePath + ".subject", placeholders));
    }

    public ReportCategory getCloseButton() {
        return new ReportCategory(this.getItemType("report_gui.close_button.item"), this.getInteger("report_gui.close_button.slot", 22), this.getMessage("report_gui.close_button.name"), this.getMessageList("report_gui.close_button.lore"), "close", "Close");
    }

    public List<String> getCategoryNames() {
        Object categoriesObj = this.getNestedValue(this.messages, "report_gui.categories");
        if (categoriesObj instanceof Map) {
            Map categories = (Map)categoriesObj;
            return categories.keySet().stream().sorted().toList();
        }
        return List.of();
    }

    public ReportCategory getBufferItem() {
        return new ReportCategory(this.getItemType("report_gui.buffer_item.item"), 0, this.getMessage("report_gui.buffer_item.name"), this.getMessageList("report_gui.buffer_item.lore"), "buffer", "Buffer");
    }

    public int calculateMenuSize(int categoryCount) {
        int minSlots = categoryCount + 1;
        int rows = (int)Math.ceil((double)minSlots / 9.0);
        rows = Math.max(3, Math.min(6, rows));
        return rows * 9;
    }

    private Object getNestedValue(Map<String, Object> map, String path) {
        String[] keys = path.split("\\.");
        Object current = map;
        for (String key : keys) {
            if (!(current instanceof Map)) {
                return null;
            }
            Map<String, Object> currentMap = current;
            current = currentMap.get(key);
        }
        return current;
    }

    private String colorize(String message) {
        return message.replace("&", "\u00a7");
    }

    public String getPunishmentMessage(String path, Map<String, String> variables) {
        HashMap<String, String> allVariables = new HashMap<String, String>(variables);
        allVariables.putIfAbsent("appeal_url", this.getMessage("config.appeal_url"));
        allVariables.putIfAbsent("default_reason", this.getMessage("config.default_reason"));
        return this.getMessage(path, allVariables);
    }

    public PunishmentMessageBuilder punishment() {
        return new PunishmentMessageBuilder(this);
    }

    public String getPunishmentTypeMessage(int ordinal, String messagePath, Map<String, String> variables) {
        String specificPath = "punishment_types.ordinal_" + ordinal + "." + messagePath;
        Object specificValue = this.getNestedValue(this.messages, specificPath);
        if (specificValue instanceof String) {
            return this.getMessage(specificPath, variables);
        }
        return this.getPunishmentMessage(messagePath, variables);
    }

    @Deprecated
    public String getPunishmentTypeMessage(String punishmentTypeName, String messagePath, Map<String, String> variables) {
        String normalizedTypeName = this.normalizeTypeName(punishmentTypeName);
        String specificPath = "punishment_types." + normalizedTypeName + "." + messagePath;
        Object specificValue = this.getNestedValue(this.messages, specificPath);
        if (specificValue instanceof String) {
            return this.getMessage(specificPath, variables);
        }
        return this.getPunishmentMessage(messagePath, variables);
    }

    public String getPublicNotificationMessage(int ordinal, Map<String, String> variables) {
        String path = "punishment_types.ordinal_" + ordinal + ".public_notification";
        Object value = this.getNestedValue(this.messages, path);
        if (value instanceof String) {
            return this.getMessage(path, variables);
        }
        return this.getDefaultPublicNotification(ordinal, variables);
    }

    public String getPublicNotificationMessage(int ordinal, String punishmentType, Map<String, String> variables) {
        String path = "punishment_types.ordinal_" + ordinal + ".public_notification";
        Object value = this.getNestedValue(this.messages, path);
        if (value instanceof String) {
            return this.getMessage(path, variables);
        }
        return this.getDefaultPublicNotificationByType(punishmentType, variables);
    }

    public String getPlayerNotificationMessage(int ordinal, Map<String, String> variables) {
        String path = "punishment_types.ordinal_" + ordinal + ".player_notification";
        Object value = this.getNestedValue(this.messages, path);
        if (value instanceof List) {
            List lines = (List)value;
            return lines.stream().map(line -> {
                for (Map.Entry entry : variables.entrySet()) {
                    line = line.replace("{" + (String)entry.getKey() + "}", (CharSequence)entry.getValue());
                }
                return this.colorize((String)line);
            }).collect(Collectors.joining("\n"));
        }
        if (value instanceof String) {
            return this.getMessage(path, variables);
        }
        return this.getDefaultPlayerNotification(ordinal, variables);
    }

    public String getPlayerNotificationMessage(int ordinal, String punishmentType, Map<String, String> variables) {
        String path = "punishment_types.ordinal_" + ordinal + ".player_notification";
        Object value = this.getNestedValue(this.messages, path);
        if (value instanceof List) {
            List lines = (List)value;
            return lines.stream().map(line -> {
                for (Map.Entry entry : variables.entrySet()) {
                    line = line.replace("{" + (String)entry.getKey() + "}", (CharSequence)entry.getValue());
                }
                return this.colorize((String)line);
            }).collect(Collectors.joining("\n"));
        }
        if (value instanceof String) {
            return this.getMessage(path, variables);
        }
        return this.getDefaultPlayerNotificationByType(punishmentType, variables);
    }

    public String getPlayerNotificationMessage(int ordinal, String punishmentType, Map<String, String> baseVariables, SimplePunishment punishment, PunishmentMessages.MessageContext context) {
        HashMap<String, String> variables = new HashMap<String, String>(baseVariables);
        variables.put("tense", this.getTenseForContext(context));
        variables.put("tense2", this.getTense2ForContext(context));
        variables.put("temp", punishment.isPermanent() ? "permanently" : "temporarily");
        variables.put("duration_formatted", this.getDurationFormatted(punishment, this.getPunishmentTypeName(punishmentType)));
        variables.put("mute_duration_formatted", this.getMuteDurationFormatted(punishment));
        return this.getPlayerNotificationMessage(ordinal, punishmentType, variables);
    }

    public List<String> getPlayerNotificationLines(int ordinal, Map<String, String> variables) {
        String path = "punishment_types.ordinal_" + ordinal + ".player_notification";
        Object value = this.getNestedValue(this.messages, path);
        if (value instanceof List) {
            List lines = (List)value;
            return lines.stream().map(line -> {
                for (Map.Entry entry : variables.entrySet()) {
                    line = line.replace("{" + (String)entry.getKey() + "}", (CharSequence)entry.getValue());
                }
                return this.colorize((String)line);
            }).collect(Collectors.toList());
        }
        if (value instanceof String) {
            return List.of(this.getMessage(path, variables));
        }
        return this.getDefaultPlayerNotificationLines(ordinal, variables);
    }

    private String getDefaultPlayerNotification(int ordinal, Map<String, String> variables) {
        String defaultPath = this.getDefaultPathForOrdinal(ordinal);
        Object value = this.getNestedValue(this.messages, defaultPath);
        if (value instanceof List) {
            List lines = (List)value;
            return lines.stream().map(line -> {
                for (Map.Entry entry : variables.entrySet()) {
                    line = line.replace("{" + (String)entry.getKey() + "}", (CharSequence)entry.getValue());
                }
                return this.colorize((String)line);
            }).collect(Collectors.joining("\n"));
        }
        if (value instanceof String) {
            return this.getMessage(defaultPath, variables);
        }
        return this.getMessage("punishments.player_notifications.default", variables);
    }

    private List<String> getDefaultPlayerNotificationLines(int ordinal, Map<String, String> variables) {
        String defaultPath = this.getDefaultPathForOrdinal(ordinal);
        Object value = this.getNestedValue(this.messages, defaultPath);
        if (value instanceof List) {
            List lines = (List)value;
            return lines.stream().map(line -> {
                for (Map.Entry entry : variables.entrySet()) {
                    line = line.replace("{" + (String)entry.getKey() + "}", (CharSequence)entry.getValue());
                }
                return this.colorize((String)line);
            }).collect(Collectors.toList());
        }
        if (value instanceof String) {
            return List.of(this.getMessage(defaultPath, variables));
        }
        return List.of(this.getMessage("punishments.player_notifications.default", variables));
    }

    private String getDefaultPublicNotification(int ordinal, Map<String, String> variables) {
        String defaultPath = this.getDefaultPublicPathForOrdinal(ordinal);
        return this.getMessage(defaultPath, variables);
    }

    private String getDefaultPublicNotificationByType(String punishmentType, Map<String, String> variables) {
        String defaultPath = this.getDefaultPublicPathForType(punishmentType);
        return this.getMessage(defaultPath, variables);
    }

    private String getDefaultPlayerNotificationByType(String punishmentType, Map<String, String> variables) {
        String defaultPath = this.getDefaultPlayerPathForType(punishmentType);
        Object value = this.getNestedValue(this.messages, defaultPath);
        if (value instanceof List) {
            List lines = (List)value;
            return lines.stream().map(line -> {
                for (Map.Entry entry : variables.entrySet()) {
                    line = line.replace("{" + (String)entry.getKey() + "}", (CharSequence)entry.getValue());
                }
                return this.colorize((String)line);
            }).collect(Collectors.joining("\n"));
        }
        if (value instanceof String) {
            return this.getMessage(defaultPath, variables);
        }
        return this.getMessage("punishments.player_notifications.default", variables);
    }

    private String getDefaultPathForOrdinal(int ordinal) {
        if (ordinal == 0) {
            return "punishments.player_notifications.kick_default";
        }
        if (ordinal == 1) {
            return "punishments.player_notifications.mute_default";
        }
        if (ordinal >= 2) {
            return "punishments.player_notifications.ban_default";
        }
        return "punishments.player_notifications.default";
    }

    private String getDefaultPublicPathForOrdinal(int ordinal) {
        if (ordinal == 0) {
            return "punishments.public_notifications.kick_default";
        }
        if (ordinal == 1) {
            return "punishments.public_notifications.mute_default";
        }
        if (ordinal >= 2) {
            return "punishments.public_notifications.ban_default";
        }
        return "punishments.public_notifications.default";
    }

    private String getDefaultPublicPathForType(String punishmentType) {
        if ("KICK".equalsIgnoreCase(punishmentType)) {
            return "punishments.public_notifications.kick_default";
        }
        if ("MUTE".equalsIgnoreCase(punishmentType)) {
            return "punishments.public_notifications.mute_default";
        }
        if ("BAN".equalsIgnoreCase(punishmentType)) {
            return "punishments.public_notifications.ban_default";
        }
        return "punishments.public_notifications.default";
    }

    private String getDefaultPlayerPathForType(String punishmentType) {
        if ("KICK".equalsIgnoreCase(punishmentType)) {
            return "punishments.player_notifications.kick_default";
        }
        if ("MUTE".equalsIgnoreCase(punishmentType)) {
            return "punishments.player_notifications.mute_default";
        }
        if ("BAN".equalsIgnoreCase(punishmentType)) {
            return "punishments.player_notifications.ban_default";
        }
        return "punishments.player_notifications.default";
    }

    private String getTenseForContext(PunishmentMessages.MessageContext context) {
        switch (context) {
            case SYNC: 
            case CHAT: {
                return "are";
            }
        }
        return "have been";
    }

    private String getTense2ForContext(PunishmentMessages.MessageContext context) {
        switch (context) {
            case SYNC: 
            case CHAT: {
                return "is";
            }
        }
        return "has been";
    }

    private String getDurationFormatted(SimplePunishment punishment, String punishmentType) {
        if (punishment.isPermanent()) {
            return "";
        }
        long timeLeft = punishment.getExpiration() - System.currentTimeMillis();
        if (timeLeft <= 0L) {
            return "";
        }
        String duration = PunishmentMessages.formatDuration(timeLeft);
        return "\n&7This " + punishmentType + " will expire in " + duration;
    }

    private String getMuteDurationFormatted(SimplePunishment punishment) {
        if (punishment.isPermanent()) {
            return "";
        }
        long timeLeft = punishment.getExpiration() - System.currentTimeMillis();
        if (timeLeft <= 0L) {
            return "";
        }
        String duration = PunishmentMessages.formatDuration(timeLeft);
        return " for " + duration;
    }

    private String getPunishmentTypeName(String punishmentType) {
        if (punishmentType == null) {
            return "punishment";
        }
        return punishmentType.toLowerCase();
    }

    public String formatDuration(long durationMs) {
        if (durationMs <= 0L) {
            return this.getMessage("config.duration_format.permanent");
        }
        long days = TimeUnit.MILLISECONDS.toDays(durationMs);
        long hours = TimeUnit.MILLISECONDS.toHours(durationMs) % 24L;
        long minutes = TimeUnit.MILLISECONDS.toMinutes(durationMs) % 60L;
        long seconds = TimeUnit.MILLISECONDS.toSeconds(durationMs) % 60L;
        StringBuilder duration = new StringBuilder();
        if (days > 0L) {
            duration.append(this.getMessage("config.duration_format.days", Map.of("days", String.valueOf(days))));
        }
        if (hours > 0L) {
            if (duration.length() > 0) {
                duration.append(" ");
            }
            duration.append(this.getMessage("config.duration_format.hours", Map.of("hours", String.valueOf(hours))));
        }
        if (minutes > 0L) {
            if (duration.length() > 0) {
                duration.append(" ");
            }
            duration.append(this.getMessage("config.duration_format.minutes", Map.of("minutes", String.valueOf(minutes))));
        }
        if (seconds > 0L && duration.length() == 0) {
            duration.append(this.getMessage("config.duration_format.seconds", Map.of("seconds", String.valueOf(seconds))));
        }
        return duration.toString();
    }

    public String formatExpiration(Date expiration) {
        String format = this.getMessage("config.date_format");
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            return dateFormat.format(expiration);
        }
        catch (Exception e) {
            return expiration.toString();
        }
    }

    private String normalizeTypeName(String typeName) {
        return typeName.toLowerCase().replace(" ", "_").replace("-", "_");
    }

    public String getCurrentLocale() {
        return this.currentLocale;
    }

    public void reloadLocale() {
        this.loadLocale(this.currentLocale);
    }

    @Generated
    public Map<String, Object> getMessages() {
        return this.messages;
    }

    public static class ReportCategory {
        private final String itemType;
        private final int slot;
        private final String name;
        private final List<String> lore;
        private final String reportType;
        private final String subject;

        public ReportCategory(String itemType, int slot, String name, List<String> lore, String reportType, String subject) {
            this.itemType = itemType;
            this.slot = slot;
            this.name = name;
            this.lore = lore;
            this.reportType = reportType;
            this.subject = subject;
        }

        @Generated
        public String getItemType() {
            return this.itemType;
        }

        @Generated
        public int getSlot() {
            return this.slot;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public List<String> getLore() {
            return this.lore;
        }

        @Generated
        public String getReportType() {
            return this.reportType;
        }

        @Generated
        public String getSubject() {
            return this.subject;
        }
    }

    public static class PunishmentMessageBuilder {
        private final LocaleManager localeManager;
        private final Map<String, String> variables;

        public PunishmentMessageBuilder(LocaleManager localeManager) {
            this.localeManager = localeManager;
            this.variables = new HashMap<String, String>();
        }

        public PunishmentMessageBuilder target(String target) {
            this.variables.put("target", target);
            return this;
        }

        public PunishmentMessageBuilder player(String player) {
            this.variables.put("player", player);
            return this;
        }

        public PunishmentMessageBuilder issuer(String issuer) {
            this.variables.put("issuer", issuer);
            return this;
        }

        public PunishmentMessageBuilder reason(String reason) {
            this.variables.put("reason", reason);
            return this;
        }

        public PunishmentMessageBuilder type(String type) {
            this.variables.put("type", type);
            this.variables.put("punishment_type", type);
            return this;
        }

        public PunishmentMessageBuilder duration(long durationMs) {
            this.variables.put("duration", this.localeManager.formatDuration(durationMs));
            return this;
        }

        public PunishmentMessageBuilder expiration(Date expiration) {
            this.variables.put("expiration", this.localeManager.formatExpiration(expiration));
            return this;
        }

        public PunishmentMessageBuilder punishmentId(String punishmentId) {
            this.variables.put("id", punishmentId);
            return this;
        }

        public PunishmentMessageBuilder server(String server) {
            this.variables.put("server", server);
            return this;
        }

        public PunishmentMessageBuilder variable(String key, String value) {
            this.variables.put(key, value);
            return this;
        }

        public String get(String path) {
            return this.localeManager.getPunishmentMessage(path, this.variables);
        }

        public String getForType(String punishmentTypeName, String path) {
            return this.localeManager.getPunishmentTypeMessage(punishmentTypeName, path, this.variables);
        }

        public String getForOrdinal(int ordinal, String path) {
            return this.localeManager.getPunishmentTypeMessage(ordinal, path, this.variables);
        }
    }
}

