/*
 * Decompiled with CFR 0.152.
 */
package gg.modl.minecraft.core.service;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import lombok.Generated;

public class ChatMessageCache {
    private final int maxMessagesPerServer;
    private final long maxMessageAge;
    private final Map<String, ConcurrentLinkedQueue<ChatMessage>> serverMessages = new ConcurrentHashMap<String, ConcurrentLinkedQueue<ChatMessage>>();
    private final Map<String, String> playerToServer = new ConcurrentHashMap<String, String>();

    public ChatMessageCache() {
        this(30, 300000L);
    }

    public void addMessage(String serverName, String playerUuid, String playerName, String message) {
        this.playerToServer.put(playerUuid, serverName);
        ConcurrentLinkedQueue messageQueue = this.serverMessages.computeIfAbsent(serverName, k -> new ConcurrentLinkedQueue());
        ChatMessage chatMessage = new ChatMessage(playerUuid, playerName, message, Instant.now(), serverName);
        messageQueue.offer(chatMessage);
        while (messageQueue.size() > this.maxMessagesPerServer) {
            messageQueue.poll();
        }
        this.cleanupOldMessages(messageQueue);
    }

    public List<String> getRecentMessages(String playerUuid, int count) {
        String serverName = this.playerToServer.get(playerUuid);
        if (serverName == null) {
            return Collections.emptyList();
        }
        return this.getRecentMessagesFromServer(serverName, count);
    }

    public List<String> getRecentMessagesFromServer(String serverName, int count) {
        ConcurrentLinkedQueue<ChatMessage> messageQueue = this.serverMessages.get(serverName);
        if (messageQueue == null || messageQueue.isEmpty()) {
            return Collections.emptyList();
        }
        this.cleanupOldMessages(messageQueue);
        ArrayList<ChatMessage> allMessages = new ArrayList<ChatMessage>(messageQueue);
        int startIndex = Math.max(0, allMessages.size() - count);
        List recentMessages = allMessages.subList(startIndex, allMessages.size());
        return recentMessages.stream().map(this::formatMessage).collect(Collectors.toList());
    }

    public List<String> getRecentMessagesFromPlayer(String playerUuid, int count) {
        String serverName = this.playerToServer.get(playerUuid);
        if (serverName == null) {
            return Collections.emptyList();
        }
        ConcurrentLinkedQueue<ChatMessage> messageQueue = this.serverMessages.get(serverName);
        if (messageQueue == null || messageQueue.isEmpty()) {
            return Collections.emptyList();
        }
        this.cleanupOldMessages(messageQueue);
        List playerMessages = messageQueue.stream().filter(msg -> msg.getPlayerUuid().equals(playerUuid)).collect(Collectors.toList());
        int startIndex = Math.max(0, playerMessages.size() - count);
        List recentMessages = playerMessages.subList(startIndex, playerMessages.size());
        return recentMessages.stream().map(this::formatMessage).collect(Collectors.toList());
    }

    public void removePlayer(String playerUuid) {
        this.playerToServer.remove(playerUuid);
    }

    public void clearServer(String serverName) {
        this.serverMessages.remove(serverName);
    }

    public void clearAll() {
        this.serverMessages.clear();
        this.playerToServer.clear();
    }

    public int getServerCacheSize(String serverName) {
        ConcurrentLinkedQueue<ChatMessage> messageQueue = this.serverMessages.get(serverName);
        return messageQueue != null ? messageQueue.size() : 0;
    }

    private String formatMessage(ChatMessage message) {
        String escapedMessage = this.escapeJsonString(message.getMessage());
        String escapedPlayerName = this.escapeJsonString(message.getPlayerName());
        String timestamp = message.getTimestamp().toString();
        return String.format("{\"username\":\"%s\",\"message\":\"%s\",\"timestamp\":\"%s\"}", escapedPlayerName, escapedMessage, timestamp);
    }

    private String escapeJsonString(String input) {
        if (input == null) {
            return "";
        }
        return input.replace("\\", "\\\\").replace("\"", "\\\"").replace("\b", "\\b").replace("\f", "\\f").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }

    private void cleanupOldMessages(ConcurrentLinkedQueue<ChatMessage> messageQueue) {
        Instant cutoff = Instant.now().minusMillis(this.maxMessageAge);
        messageQueue.removeIf(message -> message.getTimestamp().isBefore(cutoff));
    }

    @Generated
    public ChatMessageCache(int maxMessagesPerServer, long maxMessageAge) {
        this.maxMessagesPerServer = maxMessagesPerServer;
        this.maxMessageAge = maxMessageAge;
    }

    public static class ChatMessage {
        private final String playerUuid;
        private final String playerName;
        private final String message;
        private final Instant timestamp;
        private final String serverName;

        @Generated
        public ChatMessage(String playerUuid, String playerName, String message, Instant timestamp, String serverName) {
            this.playerUuid = playerUuid;
            this.playerName = playerName;
            this.message = message;
            this.timestamp = timestamp;
            this.serverName = serverName;
        }

        @Generated
        public String getPlayerUuid() {
            return this.playerUuid;
        }

        @Generated
        public String getPlayerName() {
            return this.playerName;
        }

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Generated
        public Instant getTimestamp() {
            return this.timestamp;
        }

        @Generated
        public String getServerName() {
            return this.serverName;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChatMessage)) {
                return false;
            }
            ChatMessage other = (ChatMessage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$playerUuid = this.getPlayerUuid();
            String other$playerUuid = other.getPlayerUuid();
            if (this$playerUuid == null ? other$playerUuid != null : !this$playerUuid.equals(other$playerUuid)) {
                return false;
            }
            String this$playerName = this.getPlayerName();
            String other$playerName = other.getPlayerName();
            if (this$playerName == null ? other$playerName != null : !this$playerName.equals(other$playerName)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            Instant this$timestamp = this.getTimestamp();
            Instant other$timestamp = other.getTimestamp();
            if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
                return false;
            }
            String this$serverName = this.getServerName();
            String other$serverName = other.getServerName();
            return !(this$serverName == null ? other$serverName != null : !this$serverName.equals(other$serverName));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ChatMessage;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $playerUuid = this.getPlayerUuid();
            result = result * 59 + ($playerUuid == null ? 43 : $playerUuid.hashCode());
            String $playerName = this.getPlayerName();
            result = result * 59 + ($playerName == null ? 43 : $playerName.hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            Instant $timestamp = this.getTimestamp();
            result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
            String $serverName = this.getServerName();
            result = result * 59 + ($serverName == null ? 43 : $serverName.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ChatMessageCache.ChatMessage(playerUuid=" + this.getPlayerUuid() + ", playerName=" + this.getPlayerName() + ", message=" + this.getMessage() + ", timestamp=" + String.valueOf(this.getTimestamp()) + ", serverName=" + this.getServerName() + ")";
        }
    }
}

