/*
 * Decompiled with CFR 0.152.
 */
package gg.modl.minecraft.core.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ArgumentParser {
    private static final Pattern DURATION_PATTERN = Pattern.compile("(\\d+)([smhdwMy])");

    public static long getDuration(String arguments) {
        if (arguments == null || arguments.trim().isEmpty()) {
            return -1L;
        }
        Matcher matcher = DURATION_PATTERN.matcher(arguments);
        long totalMillis = 0L;
        while (matcher.find()) {
            String unit;
            int amount = Integer.parseInt(matcher.group(1));
            switch (unit = matcher.group(2)) {
                case "s": {
                    totalMillis += (long)amount * 1000L;
                    break;
                }
                case "m": {
                    totalMillis += (long)(amount * 60) * 1000L;
                    break;
                }
                case "h": {
                    totalMillis += (long)(amount * 60 * 60) * 1000L;
                    break;
                }
                case "d": {
                    totalMillis += (long)(amount * 24 * 60 * 60) * 1000L;
                    break;
                }
                case "w": {
                    totalMillis += (long)(amount * 7 * 24 * 60 * 60) * 1000L;
                    break;
                }
                case "M": {
                    totalMillis += (long)amount * 30L * 24L * 60L * 60L * 1000L;
                    break;
                }
                case "y": {
                    totalMillis += (long)amount * 365L * 24L * 60L * 60L * 1000L;
                }
            }
        }
        return totalMillis > 0L ? totalMillis : -1L;
    }

    public static String getReason(String arguments) {
        if (arguments == null || arguments.trim().isEmpty()) {
            return "Unspecified";
        }
        String reason = arguments;
        reason = reason.replaceAll("\\d+[smhdwMy]", "");
        reason = reason.replaceAll("-[a-zA-Z]+", "");
        return (reason = reason.trim()).isEmpty() ? "Unspecified" : reason;
    }

    public static boolean isSilent(String arguments) {
        return arguments != null && arguments.contains("-s");
    }

    public static boolean isAltBlocking(String arguments) {
        return arguments != null && arguments.contains("-ab");
    }

    public static boolean isStatWiping(String arguments) {
        return arguments != null && arguments.contains("-sw");
    }

    public static boolean isChatLogging(String arguments) {
        return arguments != null && arguments.contains("-cl");
    }
}

