/*
 * Decompiled with CFR 0.152.
 */
package gg.modl.minecraft.core.util;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;

public class CircuitBreaker {
    private static final Logger logger = Logger.getLogger(CircuitBreaker.class.getName());
    private final String name;
    private final int failureThreshold;
    private final long timeoutMillis;
    private final long retryTimeoutMillis;
    private final AtomicReference<State> state = new AtomicReference<State>(State.CLOSED);
    private final AtomicInteger failureCount = new AtomicInteger(0);
    private final AtomicInteger successCount = new AtomicInteger(0);
    private final AtomicLong lastFailureTime = new AtomicLong(0L);
    private final AtomicLong nextRetryTime = new AtomicLong(0L);

    public CircuitBreaker(String name) {
        this(name, 5, 60000L, 30000L);
    }

    public CircuitBreaker(String name, int failureThreshold, long timeoutMillis, long retryTimeoutMillis) {
        this.name = name;
        this.failureThreshold = failureThreshold;
        this.timeoutMillis = timeoutMillis;
        this.retryTimeoutMillis = retryTimeoutMillis;
    }

    public boolean allowRequest() {
        State currentState = this.state.get();
        long currentTime = System.currentTimeMillis();
        switch (currentState.ordinal()) {
            case 0: {
                return true;
            }
            case 1: {
                if (currentTime >= this.nextRetryTime.get() && this.state.compareAndSet(State.OPEN, State.HALF_OPEN)) {
                    logger.info(String.format("Circuit breaker [%s] transitioning to HALF_OPEN", this.name));
                    return true;
                }
                return false;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    public void recordSuccess() {
        State currentState = this.state.get();
        if (currentState == State.HALF_OPEN) {
            if (this.state.compareAndSet(State.HALF_OPEN, State.CLOSED)) {
                this.reset();
                logger.info(String.format("Circuit breaker [%s] closed after successful request", this.name));
            }
        } else if (currentState == State.CLOSED) {
            int currentFailures = this.failureCount.get();
            if (currentFailures > 0) {
                this.failureCount.set(Math.max(0, currentFailures - 1));
            }
            this.successCount.incrementAndGet();
        }
    }

    public void recordFailure() {
        State currentState = this.state.get();
        long currentTime = System.currentTimeMillis();
        this.lastFailureTime.set(currentTime);
        int failures = this.failureCount.incrementAndGet();
        if (currentState == State.HALF_OPEN) {
            if (this.state.compareAndSet(State.HALF_OPEN, State.OPEN)) {
                this.nextRetryTime.set(currentTime + this.retryTimeoutMillis);
                logger.warning(String.format("Circuit breaker [%s] opened again after failed retry", this.name));
            }
        } else if (currentState == State.CLOSED && failures >= this.failureThreshold && this.state.compareAndSet(State.CLOSED, State.OPEN)) {
            this.nextRetryTime.set(currentTime + this.timeoutMillis);
            logger.warning(String.format("Circuit breaker [%s] opened after %d failures", this.name, failures));
        }
    }

    public void reset() {
        this.state.set(State.CLOSED);
        this.failureCount.set(0);
        this.successCount.set(0);
        this.lastFailureTime.set(0L);
        this.nextRetryTime.set(0L);
    }

    public State getState() {
        return this.state.get();
    }

    public int getFailureCount() {
        return this.failureCount.get();
    }

    public int getSuccessCount() {
        return this.successCount.get();
    }

    public boolean isOpen() {
        return this.state.get() == State.OPEN;
    }

    public String getStatus() {
        State currentState = this.state.get();
        long currentTime = System.currentTimeMillis();
        long timeSinceLastFailure = this.lastFailureTime.get() > 0L ? currentTime - this.lastFailureTime.get() : -1L;
        long timeUntilRetry = this.nextRetryTime.get() > currentTime ? this.nextRetryTime.get() - currentTime : 0L;
        return String.format("CircuitBreaker[%s] State=%s, Failures=%d, Successes=%d, TimeSinceLastFailure=%dms, TimeUntilRetry=%dms", new Object[]{this.name, currentState, this.failureCount.get(), this.successCount.get(), timeSinceLastFailure, timeUntilRetry});
    }

    public static enum State {
        CLOSED,
        OPEN,
        HALF_OPEN;

    }
}

