/*
 * Decompiled with CFR 0.152.
 */
package gg.modl.minecraft.core.util;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import lombok.Generated;

public class IpApiClient {
    private static final Logger logger = Logger.getLogger(IpApiClient.class.getName());
    private static final String IP_API_URL = "http://ip-api.com/json/%s?fields=status,message,countryCode,regionName,city,as,proxy,hosting";
    private static final Gson gson = new Gson();

    public static CompletableFuture<JsonObject> getIpInfo(String ipAddress) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                if (IpApiClient.isPrivateIp(ipAddress)) {
                    logger.fine("Skipping IP lookup for private/local IP: " + ipAddress);
                    return IpApiClient.createLocalIpInfo();
                }
                String urlString = String.format(IP_API_URL, ipAddress);
                URL url = new URL(urlString);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                connection.setRequestProperty("User-Agent", "modl-minecraft/1.0");
                int responseCode = connection.getResponseCode();
                if (responseCode == 200) {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    StringBuilder response = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        response.append(line);
                    }
                    reader.close();
                    JsonObject jsonResponse = gson.fromJson(response.toString(), JsonObject.class);
                    if (jsonResponse.has("status") && "success".equals(jsonResponse.get("status").getAsString())) {
                        logger.fine("Successfully retrieved IP info for " + ipAddress);
                        return jsonResponse;
                    }
                    String message = jsonResponse.has("message") ? jsonResponse.get("message").getAsString() : "Unknown error";
                    logger.warning("IP API returned error for " + ipAddress + ": " + message);
                    return null;
                }
                logger.warning("IP API request failed with code " + responseCode + " for IP " + ipAddress);
                return null;
            }
            catch (Exception e) {
                logger.warning("Failed to get IP info for " + ipAddress + ": " + e.getMessage());
                return null;
            }
        }).exceptionally(throwable -> {
            logger.warning("IP lookup failed for " + ipAddress + ": " + throwable.getMessage());
            return null;
        });
    }

    private static boolean isPrivateIp(String ipAddress) {
        if (ipAddress == null || ipAddress.isEmpty()) {
            return true;
        }
        return ipAddress.startsWith("127.") || ipAddress.startsWith("192.168.") || ipAddress.startsWith("10.") || ipAddress.startsWith("172.") || ipAddress.equals("0:0:0:0:0:0:0:1") || ipAddress.equals("::1") || ipAddress.startsWith("fe80:") || ipAddress.startsWith("fc00:") || ipAddress.startsWith("fd00:");
    }

    private static JsonObject createLocalIpInfo() {
        JsonObject localInfo = new JsonObject();
        localInfo.addProperty("status", "success");
        localInfo.addProperty("countryCode", "XX");
        localInfo.addProperty("regionName", "Local");
        localInfo.addProperty("city", "Local");
        localInfo.addProperty("as", "Private Network");
        localInfo.addProperty("proxy", false);
        localInfo.addProperty("hosting", false);
        return localInfo;
    }

    public static class IpInfo {
        private String status;
        private String message;
        private String countryCode;
        private String regionName;
        private String city;
        private String as;
        private boolean proxy;
        private boolean hosting;

        public static IpInfo fromJson(JsonObject json) {
            return gson.fromJson((JsonElement)json, IpInfo.class);
        }

        @Generated
        public IpInfo() {
        }

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Generated
        public String getCountryCode() {
            return this.countryCode;
        }

        @Generated
        public String getRegionName() {
            return this.regionName;
        }

        @Generated
        public String getCity() {
            return this.city;
        }

        @Generated
        public String getAs() {
            return this.as;
        }

        @Generated
        public boolean isProxy() {
            return this.proxy;
        }

        @Generated
        public boolean isHosting() {
            return this.hosting;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public void setMessage(String message) {
            this.message = message;
        }

        @Generated
        public void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        @Generated
        public void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        @Generated
        public void setCity(String city) {
            this.city = city;
        }

        @Generated
        public void setAs(String as) {
            this.as = as;
        }

        @Generated
        public void setProxy(boolean proxy) {
            this.proxy = proxy;
        }

        @Generated
        public void setHosting(boolean hosting) {
            this.hosting = hosting;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IpInfo)) {
                return false;
            }
            IpInfo other = (IpInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isProxy() != other.isProxy()) {
                return false;
            }
            if (this.isHosting() != other.isHosting()) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            String this$countryCode = this.getCountryCode();
            String other$countryCode = other.getCountryCode();
            if (this$countryCode == null ? other$countryCode != null : !this$countryCode.equals(other$countryCode)) {
                return false;
            }
            String this$regionName = this.getRegionName();
            String other$regionName = other.getRegionName();
            if (this$regionName == null ? other$regionName != null : !this$regionName.equals(other$regionName)) {
                return false;
            }
            String this$city = this.getCity();
            String other$city = other.getCity();
            if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
                return false;
            }
            String this$as = this.getAs();
            String other$as = other.getAs();
            return !(this$as == null ? other$as != null : !this$as.equals(other$as));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof IpInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isProxy() ? 79 : 97);
            result = result * 59 + (this.isHosting() ? 79 : 97);
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            String $countryCode = this.getCountryCode();
            result = result * 59 + ($countryCode == null ? 43 : $countryCode.hashCode());
            String $regionName = this.getRegionName();
            result = result * 59 + ($regionName == null ? 43 : $regionName.hashCode());
            String $city = this.getCity();
            result = result * 59 + ($city == null ? 43 : $city.hashCode());
            String $as = this.getAs();
            result = result * 59 + ($as == null ? 43 : $as.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "IpApiClient.IpInfo(status=" + this.getStatus() + ", message=" + this.getMessage() + ", countryCode=" + this.getCountryCode() + ", regionName=" + this.getRegionName() + ", city=" + this.getCity() + ", as=" + this.getAs() + ", proxy=" + this.isProxy() + ", hosting=" + this.isHosting() + ")";
        }
    }
}

