/*
 * Decompiled with CFR 0.152.
 */
package gg.modl.minecraft.core.util;

import co.aikar.commands.CommandIssuer;
import gg.modl.minecraft.api.http.response.SyncResponse;
import gg.modl.minecraft.core.impl.cache.Cache;
import java.util.List;
import java.util.UUID;

public class PermissionUtil {
    public static boolean hasPermission(CommandIssuer issuer, Cache cache, String permission) {
        if (!issuer.isPlayer()) {
            return true;
        }
        UUID playerUuid = issuer.getUniqueId();
        return cache.hasPermission(playerUuid, permission);
    }

    public static boolean hasAnyPermission(CommandIssuer issuer, Cache cache, String ... permissions) {
        if (!issuer.isPlayer()) {
            return true;
        }
        for (String permission : permissions) {
            if (!PermissionUtil.hasPermission(issuer, cache, permission)) continue;
            return true;
        }
        return false;
    }

    public static SyncResponse.ActiveStaffMember getStaffMember(CommandIssuer issuer, Cache cache) {
        if (!issuer.isPlayer()) {
            return null;
        }
        return cache.getStaffMember(issuer.getUniqueId());
    }

    public static boolean isStaff(CommandIssuer issuer, Cache cache) {
        if (!issuer.isPlayer()) {
            return true;
        }
        return cache.isStaffMemberByPermissions(issuer.getUniqueId()) || cache.isStaffMember(issuer.getUniqueId());
    }

    public static List<String> getPermissions(CommandIssuer issuer, Cache cache) {
        SyncResponse.ActiveStaffMember staffMember = PermissionUtil.getStaffMember(issuer, cache);
        return staffMember != null ? staffMember.getPermissions() : List.of();
    }

    public static String formatPunishmentPermission(String punishmentTypeName) {
        return "punishment.apply." + punishmentTypeName.toLowerCase().replace(" ", "-");
    }
}

