/*
 * Decompiled with CFR 0.152.
 */
package gg.modl.minecraft.core.util;

import gg.modl.minecraft.api.SimplePunishment;
import gg.modl.minecraft.core.locale.LocaleManager;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class PunishmentMessages {
    @Deprecated
    public static String formatBanMessage(SimplePunishment ban) {
        return PunishmentMessages.formatBanMessage(ban, new LocaleManager());
    }

    public static String formatBanMessage(SimplePunishment ban, LocaleManager localeManager) {
        return PunishmentMessages.formatBanMessage(ban, localeManager, MessageContext.DEFAULT);
    }

    public static String formatBanMessage(SimplePunishment ban, LocaleManager localeManager, MessageContext context) {
        int ordinal = ban.getOrdinal();
        Map<String, String> variables = PunishmentMessages.buildBasicPunishmentVariables(ban, localeManager);
        return localeManager.getPlayerNotificationMessage(ordinal, ban.getType(), variables, ban, context);
    }

    public static String getFormattedDuration(SimplePunishment punishment) {
        if (punishment.isPermanent()) {
            return "permanently";
        }
        if (punishment.isExpired()) {
            return "expired";
        }
        assert (punishment.getExpiration() != null);
        long timeLeft = punishment.getExpiration() - System.currentTimeMillis();
        return PunishmentMessages.formatDuration(timeLeft);
    }

    @Deprecated
    public static String formatMuteMessage(SimplePunishment mute) {
        return PunishmentMessages.formatMuteMessage(mute, new LocaleManager());
    }

    public static String formatMuteMessage(SimplePunishment mute, LocaleManager localeManager) {
        return PunishmentMessages.formatMuteMessage(mute, localeManager, MessageContext.DEFAULT);
    }

    public static String formatMuteMessage(SimplePunishment mute, LocaleManager localeManager, MessageContext context) {
        int ordinal = mute.getOrdinal();
        Map<String, String> variables = PunishmentMessages.buildBasicPunishmentVariables(mute, localeManager);
        return localeManager.getPlayerNotificationMessage(ordinal, mute.getType(), variables, mute, context);
    }

    @Deprecated
    public static String formatKickMessage(SimplePunishment kick) {
        return PunishmentMessages.formatKickMessage(kick, new LocaleManager());
    }

    public static String formatKickMessage(SimplePunishment kick, LocaleManager localeManager) {
        return PunishmentMessages.formatKickMessage(kick, localeManager, MessageContext.DEFAULT);
    }

    public static String formatKickMessage(SimplePunishment kick, LocaleManager localeManager, MessageContext context) {
        int ordinal = kick.getOrdinal();
        Map<String, String> variables = PunishmentMessages.buildBasicPunishmentVariables(kick, localeManager);
        return localeManager.getPlayerNotificationMessage(ordinal, kick.getType(), variables, kick, context);
    }

    @Deprecated
    public static String formatPunishmentBroadcast(String username, SimplePunishment punishment, String action) {
        return PunishmentMessages.formatPunishmentBroadcast(username, punishment, action, new LocaleManager());
    }

    public static String formatPunishmentBroadcast(String username, SimplePunishment punishment, String action, LocaleManager localeManager) {
        int ordinal = switch (action.toLowerCase()) {
            case "kicked" -> 0;
            case "muted" -> 1;
            case "banned" -> 2;
            default -> punishment.getType() != null ? Integer.parseInt(punishment.getType()) : 2;
        };
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("target", username);
        variables.put("reason", punishment.getDescription() != null ? punishment.getDescription() : "No reason specified");
        variables.put("description", punishment.getDescription() != null ? punishment.getDescription() : "No reason specified");
        variables.put("duration", punishment.isPermanent() ? "permanent" : PunishmentMessages.formatDuration(punishment.getExpiration() - System.currentTimeMillis()));
        variables.put("appeal_url", localeManager.getMessage("config.appeal_url"));
        variables.put("id", punishment.getId() != null ? punishment.getId() : "Unknown");
        return localeManager.getPublicNotificationMessage(ordinal, punishment.getType(), variables);
    }

    public static String formatTime(Date date) {
        if (date == null) {
            return "Never";
        }
        SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yy hh:mm:ss aa");
        return formatter.format(date);
    }

    public static String formatDuration(long millis) {
        long seconds = millis / 1000L + 1L;
        if (seconds < 1L) {
            return "0 seconds";
        }
        long minutes = seconds / 60L;
        seconds %= 60L;
        long hours = minutes / 60L;
        minutes %= 60L;
        long day = hours / 24L;
        hours %= 24L;
        long years = day / 365L;
        day %= 365L;
        StringBuilder time = new StringBuilder();
        if (years != 0L) {
            time.append(years).append("y ");
        }
        if (day != 0L) {
            time.append(day).append("d ");
        }
        if (hours != 0L) {
            time.append(hours).append("h ");
        }
        if (minutes != 0L) {
            time.append(minutes).append("m ");
        }
        if (seconds != 0L) {
            time.append(seconds).append("s ");
        }
        return time.toString().trim();
    }

    private static Map<String, String> buildBasicPunishmentVariables(SimplePunishment punishment, LocaleManager localeManager) {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("target", "You");
        variables.put("reason", punishment.getDescription() != null ? punishment.getDescription() : "No reason specified");
        variables.put("description", punishment.getDescription() != null ? punishment.getDescription() : "No reason specified");
        variables.put("duration", punishment.isPermanent() ? "permanent" : PunishmentMessages.formatDuration(punishment.getExpiration() - System.currentTimeMillis()));
        variables.put("appeal_url", localeManager.getMessage("config.appeal_url"));
        variables.put("id", punishment.getId() != null ? punishment.getId() : "Unknown");
        return variables;
    }

    public static String stripColors(String message) {
        return message.replaceAll("\u00a7[0-9a-fk-or]", "");
    }

    public static String translateColors(String message) {
        return message.replace('&', '\u00a7');
    }

    public static enum MessageContext {
        DEFAULT,
        SYNC,
        LOGIN,
        CHAT;

    }
}

