/*
 * Decompiled with CFR 0.152.
 */
package gg.modl.minecraft.core.util;

import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeUtil {
    public static String formatTimeMillis(long millis) {
        long seconds = millis / 1000L + 1L;
        if (seconds < 1L) {
            return "0 seconds";
        }
        long minutes = seconds / 60L;
        seconds %= 60L;
        long hours = minutes / 60L;
        minutes %= 60L;
        long day = hours / 24L;
        hours %= 24L;
        long years = day / 365L;
        day %= 365L;
        StringBuilder time = new StringBuilder();
        if (years != 0L) {
            time.append(years).append("y ");
        }
        if (day != 0L) {
            time.append(day).append("d ");
        }
        if (hours != 0L) {
            time.append(hours).append("h ");
        }
        if (minutes != 0L) {
            time.append(minutes).append("m ");
        }
        if (seconds != 0L) {
            time.append(seconds).append("s ");
        }
        return time.toString().trim();
    }

    public static long getDuration(String arg) {
        Pattern p = Pattern.compile("[a-z]+|\\d+");
        Matcher m = p.matcher(arg.toLowerCase());
        int time = -1;
        String type = null;
        long duration = 0L;
        while (m.find()) {
            String a = m.group();
            try {
                time = Integer.parseInt(a);
                if (time < 1) {
                    time = -1;
                }
            }
            catch (NumberFormatException ignored) {
                type = a;
            }
            if (time <= 0 || type == null) continue;
            switch (type) {
                case "seconds": 
                case "second": 
                case "sec": 
                case "s": {
                    duration += (long)time * 1000L;
                    break;
                }
                case "minutes": 
                case "minute": 
                case "m": {
                    duration += (long)(time * 60) * 1000L;
                    break;
                }
                case "hours": 
                case "hrs": 
                case "hr": 
                case "h": {
                    duration += (long)(time * 60 * 60) * 1000L;
                    break;
                }
                case "days": 
                case "day": 
                case "d": {
                    duration += (long)(time * 24 * 60 * 60) * 1000L;
                    break;
                }
                case "weeks": 
                case "week": 
                case "w": {
                    duration += (long)(time * 7 * 24 * 60 * 60) * 1000L;
                    break;
                }
                case "months": 
                case "month": 
                case "mo": {
                    duration += (long)(time * 30 * 24 * 60 * 60) * 1000L;
                }
            }
            time = -1;
            type = null;
        }
        if (duration == 0L) {
            return -1L;
        }
        return duration;
    }

    public static Date getTime(String arg) {
        Pattern p = Pattern.compile("[a-z]+|\\d+");
        Matcher m = p.matcher(arg.toLowerCase());
        int time = -1;
        String type = null;
        boolean isTemp = false;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        while (m.find()) {
            String a = m.group();
            try {
                time = Integer.parseInt(a);
                if (time < 1) {
                    time = -1;
                }
            }
            catch (NumberFormatException ignored) {
                type = a;
            }
            if (time <= 0 || type == null) continue;
            switch (type) {
                case "seconds": 
                case "second": 
                case "sec": 
                case "s": {
                    calendar.add(13, time);
                    break;
                }
                case "minutes": 
                case "minute": 
                case "m": {
                    calendar.add(12, time);
                    break;
                }
                case "hours": 
                case "hrs": 
                case "hr": 
                case "h": {
                    calendar.add(10, time);
                    break;
                }
                case "days": 
                case "day": 
                case "d": {
                    calendar.add(10, time * 24);
                    break;
                }
                case "weeks": 
                case "week": 
                case "w": {
                    calendar.add(10, time * 24 * 7);
                    break;
                }
                case "months": 
                case "month": 
                case "mo": {
                    calendar.add(2, time);
                }
            }
            isTemp = true;
            time = -1;
            type = null;
        }
        return isTemp ? calendar.getTime() : null;
    }
}

