/*
 * Decompiled with CFR 0.152.
 */
package gg.modl.minecraft.core.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Base64;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public record WebPlayer(String name, UUID uuid, String skin, boolean valid) {
    private static final Logger logger = Logger.getLogger(WebPlayer.class.getName());
    private static final String REGEX_PATTERN = "(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)";
    private static final HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(5L)).build();

    public static CompletableFuture<WebPlayer> get(String username) {
        return WebPlayer.fromUrl("https://api.mojang.com/users/profiles/minecraft/" + username);
    }

    public static CompletableFuture<WebPlayer> get(UUID uuid) {
        return WebPlayer.fromUrl("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid.toString().replace("-", ""));
    }

    private static CompletableFuture<WebPlayer> fromUrl(String rawUrl) {
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(rawUrl)).timeout(Duration.ofSeconds(10L)).GET().build();
            return ((CompletableFuture)httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(response -> {
                try {
                    String idString;
                    if (response.statusCode() != 200) {
                        logger.warning("Mojang API returned status " + response.statusCode() + " for URL: " + rawUrl);
                        return new WebPlayer(null, null, null, false);
                    }
                    String jsonString = (String)response.body();
                    if (jsonString == null || jsonString.trim().isEmpty()) {
                        logger.warning("Empty response from Mojang API for URL: " + rawUrl);
                        return new WebPlayer(null, null, null, false);
                    }
                    JsonObject json = JsonParser.parseString(jsonString).getAsJsonObject();
                    if (json == null) {
                        logger.warning("Invalid JSON response from Mojang API for URL: " + rawUrl);
                        return new WebPlayer(null, null, null, false);
                    }
                    String name = json.has("name") ? json.get("name").getAsString() : null;
                    String string = idString = json.has("id") ? json.get("id").getAsString() : null;
                    if (name == null || idString == null) {
                        logger.warning("Missing name or id in Mojang API response for URL: " + rawUrl);
                        return new WebPlayer(null, null, null, false);
                    }
                    UUID playerUuid = UUID.fromString(idString.replaceFirst(REGEX_PATTERN, "$1-$2-$3-$4-$5"));
                    String skinId = WebPlayer.getSkinId(json);
                    return new WebPlayer(name, playerUuid, skinId, true);
                }
                catch (Exception e) {
                    logger.warning("Error parsing Mojang API response for URL " + rawUrl + ": " + e.getMessage());
                    return new WebPlayer(null, null, null, false);
                }
            })).exceptionally(throwable -> {
                logger.warning("Failed to fetch player data from Mojang API for URL " + rawUrl + ": " + throwable.getMessage());
                return new WebPlayer(null, null, null, false);
            });
        }
        catch (Exception e) {
            logger.warning("Error creating request for Mojang API URL " + rawUrl + ": " + e.getMessage());
            return CompletableFuture.completedFuture(new WebPlayer(null, null, null, false));
        }
    }

    public static String getSkinId(JsonObject json) {
        try {
            if (!json.has("properties") || json.getAsJsonArray("properties").size() == 0) {
                return null;
            }
            JsonObject properties = json.getAsJsonArray("properties").get(0).getAsJsonObject();
            if (!properties.has("value")) {
                return null;
            }
            return WebPlayer.getSkinId(properties.get("value").getAsString());
        }
        catch (Exception e) {
            logger.warning("Error extracting skin ID from JSON: " + e.getMessage());
            return null;
        }
    }

    public static String getSkinId(String base64) {
        try {
            if (base64 == null || base64.trim().isEmpty()) {
                return null;
            }
            String decodedJson = new String(Base64.getDecoder().decode(base64));
            JsonObject decodedObject = JsonParser.parseString(decodedJson).getAsJsonObject();
            if (!decodedObject.has("textures")) {
                return null;
            }
            JsonObject textures = decodedObject.getAsJsonObject("textures");
            if (!textures.has("SKIN")) {
                return null;
            }
            JsonObject skin = textures.getAsJsonObject("SKIN");
            if (!skin.has("url")) {
                return null;
            }
            String url = skin.get("url").getAsString();
            return url.replace("http://textures.minecraft.net/texture/", "").replace("https://textures.minecraft.net/texture/", "");
        }
        catch (Exception e) {
            logger.warning("Error extracting skin ID from base64: " + e.getMessage());
            return null;
        }
    }

    @Deprecated
    public static WebPlayer getSync(String username) {
        try {
            return WebPlayer.get(username).get(TimeUnit.SECONDS.toMillis(10L), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            logger.warning("Synchronous WebPlayer.get() failed for username " + username + ": " + e.getMessage());
            return new WebPlayer(null, null, null, false);
        }
    }

    @Deprecated
    public static WebPlayer getSync(UUID uuid) {
        try {
            return WebPlayer.get(uuid).get(TimeUnit.SECONDS.toMillis(10L), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            logger.warning("Synchronous WebPlayer.get() failed for UUID " + String.valueOf(uuid) + ": " + e.getMessage());
            return new WebPlayer(null, null, null, false);
        }
    }
}

