/*
 * Decompiled with CFR 0.152.
 */
package gg.modl.minecraft.core.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class YamlConfig {
    private final Yaml yaml = new Yaml();
    private YamlConfig original;
    private String prefix = null;
    private final List<Integer> placeholders = new LinkedList<Integer>();
    private Logger logger = LoggerFactory.getLogger(YamlConfig.class);

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoadResult reload(@NotNull File configFile) {
        return this.reload(configFile, null);
    }

    public LoadResult reload(@NotNull File configFile, String prefix) {
        LoadResult result = this.load(configFile, prefix);
        switch (result.ordinal()) {
            case 0: {
                this.save(configFile);
                break;
            }
            case 1: 
            case 2: {
                this.save(configFile);
                this.load(configFile, prefix);
                break;
            }
            default: {
                throw new AssertionError((Object)"Invalid Result.");
            }
        }
        return result;
    }

    public LoadResult load(@NotNull File configFile, String prefix) {
        try {
            this.original = (YamlConfig)this.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to create new instance of " + this.getClass().getName());
        }
        if (!configFile.exists()) {
            return LoadResult.CONFIG_NOT_EXISTS;
        }
        this.dispose();
        this.prefix = prefix;
        Path configPath = configFile.toPath();
        String now = LocalDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME).replace("T", "_").replace(":", ".");
        now = now.substring(0, now.lastIndexOf("."));
        try (InputStream fileInputStream = Files.newInputStream(configPath, new OpenOption[0]);){
            Map data = (Map)this.yaml.load(fileInputStream);
            if (data != null && !data.isEmpty()) {
                this.processMap(data, this.original, "", null, now, false);
                this.processMap(data, this, "", configFile, now, true);
            }
        }
        catch (Throwable t) {
            try {
                File configFileCopy = new File(configFile.getParent(), configFile.getName() + "_invalid_" + now);
                Files.copy(configPath, configFileCopy.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.logger.warn("Unable to load config. File was copied to {}", (Object)configFileCopy.getName(), (Object)t);
            }
            catch (Exception e) {
                this.logger.warn("Unable to load config and to make a copy.", (Throwable)e);
            }
            return LoadResult.FAIL;
        }
        return LoadResult.SUCCESS;
    }

    private void processMap(Map<String, Object> input, Object instance, String oldPath, File configFile, String now, boolean usePrefix) {
        for (Map.Entry<String, Object> entry : input.entrySet()) {
            String key = oldPath + (oldPath.isEmpty() ? oldPath : ".") + entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                String stringValue = ((String)value).replace("{NL}", "\n");
                if (usePrefix) {
                    if (this.prefix != null) {
                        stringValue = stringValue.replace("{PRFX}", this.prefix);
                    }
                    value = stringValue;
                    if (key.equals("prefix")) {
                        this.prefix = stringValue;
                    }
                }
            }
            this.setFieldByKey(key, instance, value, configFile, now, usePrefix);
        }
    }

    private void setFieldByKey(String key, Object dest, Object value, File configFile, String now, boolean usePrefix) {
        File configFileBackup;
        Field field;
        String[] split = key.split("\\.");
        Object instance = this.getInstance(dest, split);
        if (instance != null && (field = this.getField(split, instance)) != null) {
            try {
                if (field.getType() != Map.class && value instanceof Map) {
                    this.processMap((Map)value, dest, key, configFile, now, usePrefix);
                } else if (field.getAnnotation(Final.class) == null) {
                    if (field.getType() == String.class && !(value instanceof String)) {
                        value = String.valueOf(value);
                    } else if (usePrefix && field.getAnnotation(Placeholders.class) != null) {
                        if (field.getType() != String.class) {
                            throw new IllegalAccessException(String.valueOf(field.getType()) + " is incompatible with placeholders");
                        }
                        Placeholders placeholders = field.getAnnotation(Placeholders.class);
                        int hash = gg.modl.minecraft.core.util.Placeholders.addPlaceholders(value, placeholders.value());
                        this.placeholders.add(hash);
                    } else if (field.getGenericType() instanceof ParameterizedType) {
                        Class parameter;
                        Type parameterType;
                        if (field.getType() == Map.class && value instanceof Map) {
                            Class parameter2;
                            Type parameterType2 = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[1];
                            if (parameterType2 instanceof Class && (parameter2 = (Class)parameterType2).getAnnotation(NodeSequence.class) != null) {
                                value = ((Map)value).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.createNodeSequence(parameter2, (Map)e.getValue(), usePrefix)));
                            }
                        } else if (field.getType() == List.class && value instanceof List && (parameterType = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]) instanceof Class && (parameter = (Class)parameterType).getAnnotation(NodeSequence.class) != null) {
                            value = ((List)value).stream().map(obj -> this.createNodeSequence(parameter, (Map)obj, usePrefix)).collect(Collectors.toList());
                        }
                    }
                    this.setField(field, instance, value);
                }
                return;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        System.out.println("Failed to set config option: " + key + ": " + String.valueOf(value) + " | " + String.valueOf(instance));
        System.out.println("lolol");
        this.logger.debug("Failed to set config option: " + key + ": " + String.valueOf(value) + " | " + String.valueOf(instance));
        if (configFile != null && !(configFileBackup = new File(configFile.getParent(), configFile.getName() + "_backup_" + now)).exists()) {
            try {
                Files.copy(configFile.toPath(), configFileBackup.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.logger.warn("Unable to load some of the config options. File was copied to {}", (Object)configFileBackup.getName());
            }
            catch (Throwable t) {
                this.logger.warn("Unable to load some of the config options and to make a copy.", t);
            }
        }
    }

    private Object getInstance(@NotNull Object instance, String[] split) {
        try {
            for (int i = 0; i < split.length - 1; ++i) {
                String name = this.toFieldName(split[i]);
                Field field = instance.getClass().getDeclaredField(name);
                field.setAccessible(true);
                Object value = field.get(instance);
                if (value == null) {
                    value = field.getType().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    this.setField(field, instance, value);
                }
                instance = value;
            }
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Unable to find field " + e.getMessage() + " in " + instance.getClass().getName());
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to create new instance: " + e.getMessage());
        }
        return instance;
    }

    private Field getField(String[] split, Object instance) {
        try {
            Field field = instance.getClass().getField(this.toFieldName(split[split.length - 1]));
            field.setAccessible(true);
            return field;
        }
        catch (Throwable t) {
            this.logger.debug("Invalid config field: " + String.join((CharSequence)".", split) + " for " + this.toNodeName(instance.getClass().getSimpleName()));
            return null;
        }
    }

    private String toFieldName(String node) {
        return node.toUpperCase(Locale.ROOT).replaceAll("-", "_");
    }

    public void save(@NotNull File configFile) {
        try {
            Path parent = configFile.toPath().getParent();
            if (!configFile.exists() && parent != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
                configFile.createNewFile();
            }
            PrintWriter writer = new PrintWriter(configFile, "UTF-8");
            this.writeConfigKeyValue(writer, this.getClass(), this, this.original, 0, true);
            writer.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void writeConfigKeyValue(PrintWriter writer, Class<?> clazz, Object instance, Object original, int indent, boolean usePrefix) {
        try {
            String lineSeparator = System.lineSeparator();
            String spacing = this.getSpacing(indent);
            for (Field field : clazz.getFields()) {
                Class<?> current;
                if (field.getAnnotation(Ignore.class) != null || (current = field.getType()).getAnnotation(Ignore.class) != null) continue;
                this.writeNewLines(field.getAnnotation(NewLine.class), writer, lineSeparator);
                Comment[] comments = (Comment[])field.getAnnotationsByType(Comment.class);
                this.writePrependComments(comments, writer, spacing, lineSeparator);
                if (field.getAnnotation(Create.class) != null) {
                    Object originalValue;
                    this.writeNewLines(current.getAnnotation(NewLine.class), writer, lineSeparator);
                    if (indent == 0) {
                        writer.write(lineSeparator);
                    }
                    comments = (Comment[])current.getAnnotationsByType(Comment.class);
                    this.writePrependComments(comments, writer, spacing, lineSeparator);
                    writer.write(spacing + this.toNodeName(current.getSimpleName()) + ":");
                    this.writeComments(comments, writer, lineSeparator, spacing + "  ");
                    field.setAccessible(true);
                    Object value = field.get(instance);
                    if (value == null) {
                        value = current.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        this.setField(field, instance, value);
                    }
                    if ((originalValue = field.get(original)) == null) {
                        originalValue = current.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        this.setField(field, original, originalValue);
                    }
                    this.writeConfigKeyValue(writer, current, value, originalValue, indent + 2, usePrefix);
                    continue;
                }
                String fieldName = field.getName();
                String fieldValue = this.toYamlString(field.get(instance), fieldName, lineSeparator, spacing, usePrefix);
                String originalFieldValue = this.toYamlString(field.get(original), fieldName, lineSeparator, spacing, usePrefix);
                String valueToWrite = fieldValue;
                if (this.prefix != null) {
                    if (fieldValue.startsWith("\"") && fieldValue.endsWith("\"")) {
                        if (fieldValue.replace("{PRFX}", this.prefix).equals(originalFieldValue.replace("{PRFX}", this.prefix))) {
                            valueToWrite = originalFieldValue;
                        }
                    } else if (fieldValue.contains(lineSeparator)) {
                        StringBuilder builder = new StringBuilder();
                        String[] lines = fieldValue.split(lineSeparator);
                        String[] originalLines = originalFieldValue.split(lineSeparator);
                        for (int i = 0; i < lines.length; ++i) {
                            String line;
                            String toAppend = line = lines[i];
                            if (i < originalLines.length) {
                                String originalLine = originalLines[i];
                                if (line.replace("{PRFX}", this.prefix).equals(originalLine.replace("{PRFX}", this.prefix))) {
                                    toAppend = originalLine;
                                }
                            }
                            builder.append(toAppend).append(lineSeparator);
                        }
                        builder.setLength(builder.length() - lineSeparator.length());
                        valueToWrite = builder.toString();
                    }
                }
                writer.write(spacing + this.toNodeName(fieldName) + (valueToWrite.contains(lineSeparator) ? ":" : ": ") + valueToWrite);
                this.writeComments(comments, writer, lineSeparator, spacing);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private String getSpacing(int indent) {
        return new String(new char[indent]).replace('\u0000', ' ');
    }

    private void writeNewLines(NewLine newLine, PrintWriter writer, String lineSeparator) {
        if (newLine != null) {
            for (int i = 0; i < newLine.amount(); ++i) {
                writer.write(lineSeparator);
            }
        }
    }

    private void writePrependComments(Comment[] comments, PrintWriter writer, String spacing, String lineSeparator) {
        Arrays.stream(comments).filter(comment -> comment.at().equals((Object)Comment.At.PREPEND)).flatMap(comment -> Arrays.stream(comment.value())).forEach(commentLine -> writer.write(spacing + "# " + commentLine.replace("\n", lineSeparator) + lineSeparator));
    }

    private void writeComments(Comment[] comments, PrintWriter writer, String lineSeparator, String spacing) {
        Map<Comment.At, List<Comment>> groups = Arrays.stream(comments).collect(Collectors.groupingBy(Comment::at));
        writer.write((String)(groups.containsKey((Object)Comment.At.SAME_LINE) ? " # " + groups.get((Object)Comment.At.SAME_LINE).get(0).value()[0] : "") + lineSeparator);
        groups.getOrDefault((Object)Comment.At.APPEND, Collections.emptyList()).stream().flatMap(comment -> Arrays.stream(comment.value())).forEach(commentLine -> writer.write(spacing + "# " + commentLine.replace("\n", lineSeparator) + lineSeparator));
    }

    private void setField(Field field, Object owner, Object value) throws IllegalAccessException {
        int modifiers = field.getModifiers();
        if (Modifier.isStatic(modifiers)) {
            throw new IllegalStateException("This field shouldn't be static.");
        }
        if (Modifier.isFinal(modifiers)) {
            throw new IllegalStateException("This field shouldn't be final.");
        }
        if (field.getType() == Map.class && value instanceof Map) {
            if (((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0] != String.class) {
                throw new IllegalStateException("Key type of this map should be " + String.valueOf(String.class));
            }
            value = ((Map)value).entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), Map.Entry::getValue));
        }
        field.set(owner, value);
    }

    protected static <T> T createNodeSequence(Class<T> nodeSequenceClass) {
        try {
            if (nodeSequenceClass.getAnnotation(NodeSequence.class) == null) {
                throw new IllegalStateException(nodeSequenceClass.getName() + " is not a node class");
            }
            Constructor<T> constructor = nodeSequenceClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Method not found: " + e.getMessage());
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Unable to create instance of " + nodeSequenceClass.getName());
        }
    }

    private <T> T createNodeSequence(Class<T> nodeSequenceClass, Map<String, Object> objects, boolean usePrefix) {
        T instance = YamlConfig.createNodeSequence(nodeSequenceClass);
        this.processMap(objects, instance, "", null, null, usePrefix);
        return instance;
    }

    protected static <T> T createNodeSequence(Class<T> nodeSequenceClass, Object ... values) {
        try {
            T instance = YamlConfig.createNodeSequence(nodeSequenceClass);
            Field[] fields = nodeSequenceClass.getDeclaredFields();
            int idx = 0;
            for (Field field : fields) {
                Object value;
                if (field.getAnnotation(Final.class) != null || field.getAnnotation(Ignore.class) != null || field.getType().getAnnotation(Ignore.class) != null) continue;
                int modifiers = field.getModifiers();
                if (Modifier.isFinal(modifiers)) {
                    throw new IllegalStateException("Field " + field.getName() + " can't be final");
                }
                if (Modifier.isStatic(modifiers)) {
                    throw new IllegalStateException("Field " + field.getName() + " can't be static");
                }
                field.setAccessible(true);
                Object object = value = idx >= values.length ? null : values[idx];
                if (field.getAnnotation(Create.class) != null && !field.getType().isInstance(value)) {
                    field.set(instance, field.getType().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    continue;
                }
                if (value == null) continue;
                field.set(instance, value);
                ++idx;
            }
            return instance;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to set field: " + e.getMessage());
        }
        catch (InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to create new instance: " + e.getMessage());
        }
    }

    private String toNodeName(String fieldName) {
        if (fieldName.matches("^\\d+$")) {
            return "\"" + fieldName + "\"";
        }
        return fieldName.toLowerCase(Locale.ROOT).replace("_", "-");
    }

    private String toYamlString(Object value, String fieldName, String lineSeparator, String spacing, boolean usePrefix) {
        return this.toYamlString(value, fieldName, lineSeparator, spacing, false, 0, usePrefix);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String toYamlString(Object value, String fieldName, String lineSeparator, String spacing, boolean isMap, int nested, boolean usePrefix) {
        if (value instanceof Map) {
            Map map = (Map)value;
            if (map.isEmpty()) {
                return "{}";
            }
            StringBuilder builder = new StringBuilder();
            map.forEach((key, mapValue) -> {
                String stringKey = String.valueOf(key);
                String data = this.toYamlString(mapValue, stringKey, lineSeparator, spacing, true, 0, usePrefix);
                builder.append(lineSeparator).append(spacing).append("  ").append(this.toNodeName(String.valueOf(key))).append(data.startsWith(lineSeparator) ? ":" : ": ").append(data);
            });
            return builder.toString();
        }
        if (value instanceof List) {
            List listValue = (List)value;
            if (listValue.isEmpty()) {
                return "[]";
            }
            StringBuilder builder = new StringBuilder();
            boolean newLine = nested == 0;
            for (Object obj : listValue) {
                if (newLine) {
                    builder.append(lineSeparator).append(spacing).append(this.getSpacing(2 + nested * 2));
                } else {
                    newLine = true;
                }
                builder.append("- ").append(this.toYamlString(obj, fieldName, lineSeparator, spacing, false, nested + 1, usePrefix));
            }
            return builder.toString();
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            if (stringValue.isEmpty()) {
                return "\"\"";
            }
            return ("\"" + stringValue + "\"").replace("\n", "{NL}");
        }
        if (value != null && value.getClass().getAnnotation(NodeSequence.class) != null) {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8));
                try {
                    if (isMap) {
                        writer.write(lineSeparator);
                    }
                    int indent = spacing.length() + 4;
                    this.writeConfigKeyValue(writer, value.getClass(), value, value, indent, usePrefix);
                    writer.flush();
                    String data = baos.toString("UTF-8");
                    String string = data.substring(isMap ? 0 : indent, data.length() - lineSeparator.length());
                    writer.close();
                    return string;
                }
                catch (Throwable throwable) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return String.valueOf(value);
    }

    public void dispose() {
        this.placeholders.forEach(gg.modl.minecraft.core.util.Placeholders.placeholders::remove);
        this.placeholders.clear();
        this.prefix = null;
    }

    public static enum LoadResult {
        SUCCESS,
        FAIL,
        CONFIG_NOT_EXISTS;

    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    protected static @interface Final {
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    protected static @interface Placeholders {
        public String[] value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    protected static @interface NodeSequence {
    }

    @Target(value={ElementType.FIELD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    protected static @interface Ignore {
    }

    @Target(value={ElementType.FIELD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    protected static @interface NewLine {
        public int amount() default 1;
    }

    @Target(value={ElementType.FIELD, ElementType.TYPE})
    @Repeatable(value=CommentsHolder.class)
    @Retention(value=RetentionPolicy.RUNTIME)
    protected static @interface Comment {
        public String[] value();

        public At at() default At.PREPEND;

        public static enum At {
            PREPEND,
            SAME_LINE,
            APPEND;

        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    protected static @interface Create {
    }

    @Target(value={ElementType.FIELD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    protected static @interface CommentsHolder {
        public Comment[] value();
    }
}

