/*
 * Decompiled with CFR 0.152.
 */
package gg.modl.minecraft.spigot;

import co.aikar.commands.BukkitCommandManager;
import co.aikar.commands.CommandManager;
import dev.simplix.cirrus.player.CirrusPlayerWrapper;
import gg.modl.minecraft.api.AbstractPlayer;
import gg.modl.minecraft.core.Platform;
import java.util.Collection;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import lombok.Generated;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class SpigotPlatform
implements Platform {
    private final BukkitCommandManager commandManager;
    private final Logger logger;

    @Override
    public void broadcast(String string) {
        Bukkit.broadcastMessage((String)ChatColor.translateAlternateColorCodes((char)'&', (String)string));
    }

    @Override
    public void staffBroadcast(String string) {
        String message = ChatColor.translateAlternateColorCodes((char)'&', (String)string);
        Bukkit.getOnlinePlayers().stream().filter(player -> player.hasPermission("modl.staff")).forEach(player -> player.sendMessage(message));
    }

    @Override
    public void disconnect(UUID uuid, String message) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player != null && player.isOnline()) {
            player.kickPlayer(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
        }
    }

    @Override
    public void sendMessage(UUID uuid, String message) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player != null && player.isOnline()) {
            String formattedMessage = message.replace("\\n", "\n").replace("\\\\n", "\n");
            player.sendMessage(formattedMessage);
        }
    }

    @Override
    public void sendJsonMessage(UUID uuid, String jsonMessage) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player != null && player.isOnline()) {
            player.spigot().sendMessage(ComponentSerializer.parse((String)jsonMessage));
        }
    }

    @Override
    public boolean isOnline(UUID uuid) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        return player != null && player.isOnline();
    }

    @Override
    @NotNull
    public CommandManager<?, ?, ?, ?, ?, ?> getCommandManager() {
        return this.commandManager;
    }

    @Override
    public AbstractPlayer getAbstractPlayer(UUID uuid, boolean queryMojang) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player != null) {
            return new AbstractPlayer(uuid, player.getName(), player.isOnline(), player.getAddress() != null ? player.getAddress().getAddress().getHostAddress() : null);
        }
        if (queryMojang) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
            return new AbstractPlayer(uuid, offlinePlayer.getName(), false, null);
        }
        return null;
    }

    @Override
    public AbstractPlayer getAbstractPlayer(String username, boolean queryMojang) {
        OfflinePlayer offlinePlayer;
        Player player = Bukkit.getPlayer((String)username);
        if (player != null) {
            return new AbstractPlayer(player.getUniqueId(), player.getName(), player.isOnline(), player.getAddress() != null ? player.getAddress().getAddress().getHostAddress() : null);
        }
        if (queryMojang && (offlinePlayer = Bukkit.getOfflinePlayer((String)username)).hasPlayedBefore()) {
            return new AbstractPlayer(offlinePlayer.getUniqueId(), offlinePlayer.getName(), false, null);
        }
        return null;
    }

    @Override
    public CirrusPlayerWrapper getPlayerWrapper(UUID uuid) {
        return null;
    }

    @Override
    public Collection<AbstractPlayer> getOnlinePlayers() {
        return Bukkit.getOnlinePlayers().stream().map(player -> new AbstractPlayer(player.getUniqueId(), player.getName(), true, player.getAddress() != null ? player.getAddress().getAddress().getHostAddress() : null)).collect(Collectors.toList());
    }

    @Override
    public AbstractPlayer getPlayer(UUID uuid) {
        return this.getAbstractPlayer(uuid, false);
    }

    @Override
    public int getMaxPlayers() {
        return Bukkit.getMaxPlayers();
    }

    @Override
    public String getServerVersion() {
        return Bukkit.getVersion();
    }

    @Override
    public void runOnMainThread(Runnable task) {
        if (Bukkit.isPrimaryThread()) {
            task.run();
        } else {
            Bukkit.getScheduler().runTask(Bukkit.getPluginManager().getPlugin("modl"), task);
        }
    }

    @Override
    public void kickPlayer(AbstractPlayer player, String reason) {
        Player bukkitPlayer = Bukkit.getPlayer((UUID)player.getUuid());
        if (bukkitPlayer != null && bukkitPlayer.isOnline()) {
            String formattedReason = reason.replace("\\n", "\n").replace("\\\\n", "\n");
            bukkitPlayer.kickPlayer(formattedReason);
        }
    }

    @Override
    public String getServerName() {
        return "spigot-server";
    }

    public Logger getLogger() {
        return this.logger;
    }

    @Generated
    public SpigotPlatform(BukkitCommandManager commandManager, Logger logger) {
        this.commandManager = commandManager;
        this.logger = logger;
    }
}

