/*
 * Decompiled with CFR 0.152.
 */
package gg.modl.minecraft.spigot;

import co.aikar.commands.BukkitCommandManager;
import gg.modl.minecraft.core.HttpManager;
import gg.modl.minecraft.core.PluginLoader;
import gg.modl.minecraft.core.service.ChatMessageCache;
import gg.modl.minecraft.spigot.SpigotCommandRegister;
import gg.modl.minecraft.spigot.SpigotListener;
import gg.modl.minecraft.spigot.SpigotPlatform;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SpigotPlugin
extends JavaPlugin {
    private PluginLoader loader;

    public synchronized void onEnable() {
        this.saveDefaultConfig();
        this.createLocaleFiles();
        String apiUrl = this.getConfig().getString("api.url");
        if ("https://yourserver.modl.gg".equals(apiUrl)) {
            this.getLogger().severe("===============================================");
            this.getLogger().severe("MODL CONFIGURATION ERROR");
            this.getLogger().severe("===============================================");
            this.getLogger().severe("You must configure your API URL in config.yml!");
            this.getLogger().severe("Please set 'api.url' to your actual MODL panel URL.");
            this.getLogger().severe("Example: https://yourserver.modl.gg");
            this.getLogger().severe("Plugin will now disable itself.");
            this.getLogger().severe("===============================================");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        HttpManager httpManager = new HttpManager(this.getConfig().getString("api.key"), apiUrl, this.getConfig().getBoolean("api.debug", false));
        BukkitCommandManager commandManager = new BukkitCommandManager((Plugin)this);
        SpigotPlatform platform = new SpigotPlatform(commandManager, this.getLogger());
        ChatMessageCache chatMessageCache = new ChatMessageCache();
        int syncPollingRate = Math.max(1, this.getConfig().getInt("sync.polling_rate", 2));
        this.loader = new PluginLoader(platform, new SpigotCommandRegister(commandManager), this.getDataFolder().toPath(), chatMessageCache, httpManager, syncPollingRate);
        this.getServer().getPluginManager().registerEvents((Listener)new SpigotListener(platform, this.loader.getCache(), this.loader.getHttpClient(), chatMessageCache, this.loader.getSyncService(), httpManager.getPanelUrl(), this.loader.getLocaleManager(), this.loader.getLoginCache()), (Plugin)this);
    }

    public synchronized void onDisable() {
        if (this.loader != null) {
            this.loader.shutdown();
        }
    }

    private void createLocaleFiles() {
        block11: {
            try {
                File enUsFile;
                File localeDir = new File(this.getDataFolder(), "locale");
                if (!localeDir.exists()) {
                    localeDir.mkdirs();
                    this.getLogger().info("Created locale directory at: " + localeDir.getPath());
                }
                if ((enUsFile = new File(localeDir, "en_US.yml")).exists()) break block11;
                try (InputStream defaultLocale = this.getResource("locale/en_US.yml");){
                    if (defaultLocale != null) {
                        Files.copy(defaultLocale, enUsFile.toPath(), new CopyOption[0]);
                        this.getLogger().info("Created default locale file at: " + enUsFile.getPath());
                    } else {
                        this.getLogger().warning("Default locale resource not found in JAR");
                    }
                }
            }
            catch (IOException e) {
                this.getLogger().severe("Failed to create locale files: " + e.getMessage());
            }
        }
    }
}

