/*
 * Decompiled with CFR 0.152.
 */
package gg.modl.minecraft.velocity;

import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.player.PlayerChatEvent;
import com.velocitypowered.api.proxy.ServerConnection;
import gg.modl.minecraft.api.Punishment;
import gg.modl.minecraft.core.impl.cache.Cache;
import gg.modl.minecraft.core.locale.LocaleManager;
import gg.modl.minecraft.core.service.ChatMessageCache;
import gg.modl.minecraft.core.util.PunishmentMessages;
import gg.modl.minecraft.velocity.Colors;
import gg.modl.minecraft.velocity.VelocityPlatform;
import net.kyori.adventure.text.Component;

public class ChatListener {
    private final VelocityPlatform platform;
    private final Cache cache;
    private final ChatMessageCache chatMessageCache;
    private final LocaleManager localeManager;

    public ChatListener(VelocityPlatform platform, Cache cache, ChatMessageCache chatMessageCache, LocaleManager localeManager) {
        this.platform = platform;
        this.cache = cache;
        this.chatMessageCache = chatMessageCache;
        this.localeManager = localeManager;
    }

    @Subscribe
    public void onPlayerChat(PlayerChatEvent event) {
        String serverName = event.getPlayer().getCurrentServer().isPresent() ? ((ServerConnection)event.getPlayer().getCurrentServer().get()).getServerInfo().getName() : "unknown";
        this.chatMessageCache.addMessage(serverName, event.getPlayer().getUniqueId().toString(), event.getPlayer().getUsername(), event.getMessage());
        if (this.cache.isMuted(event.getPlayer().getUniqueId())) {
            event.setResult(PlayerChatEvent.ChatResult.denied());
            Cache.CachedPlayerData data = this.cache.getCache().get(event.getPlayer().getUniqueId());
            if (data != null) {
                String muteMessage = data.getSimpleMute() != null ? PunishmentMessages.formatMuteMessage(data.getSimpleMute(), this.localeManager, PunishmentMessages.MessageContext.CHAT) : (data.getMute() != null ? this.formatMuteMessage(data.getMute()) : "\u00a7cYou are muted!");
                String formattedMessage = muteMessage.replace("\\n", "\n").replace("\\\\n", "\n");
                Component muteComponent = Colors.get(formattedMessage);
                event.getPlayer().sendMessage(muteComponent);
            }
        }
    }

    private String formatMuteMessage(Punishment mute) {
        String reason = mute.getReason() != null ? mute.getReason() : "No reason provided";
        StringBuilder message = new StringBuilder();
        message.append("\u00a7cYou are muted!\n");
        message.append("\u00a77Reason: \u00a7f").append(reason).append("\n");
        if (mute.getExpires() != null) {
            long timeLeft = mute.getExpires().getTime() - System.currentTimeMillis();
            if (timeLeft > 0L) {
                String timeString = PunishmentMessages.formatDuration(timeLeft);
                message.append("\u00a77Time remaining: \u00a7f").append(timeString).append("\n");
            }
        } else {
            message.append("\u00a74This mute is permanent.\n");
        }
        return message.toString();
    }

    public ChatMessageCache getChatMessageCache() {
        return this.chatMessageCache;
    }
}

