/*
 * Decompiled with CFR 0.152.
 */
package gg.modl.minecraft.velocity;

import com.google.gson.JsonObject;
import com.velocitypowered.api.event.ResultedEvent;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.LoginEvent;
import com.velocitypowered.api.event.connection.PostLoginEvent;
import gg.modl.minecraft.api.SimplePunishment;
import gg.modl.minecraft.api.http.ModlHttpClient;
import gg.modl.minecraft.api.http.PanelUnavailableException;
import gg.modl.minecraft.api.http.request.PlayerDisconnectRequest;
import gg.modl.minecraft.api.http.request.PlayerLoginRequest;
import gg.modl.minecraft.api.http.request.PunishmentAcknowledgeRequest;
import gg.modl.minecraft.api.http.response.PlayerLoginResponse;
import gg.modl.minecraft.api.http.response.SyncResponse;
import gg.modl.minecraft.core.Platform;
import gg.modl.minecraft.core.impl.cache.Cache;
import gg.modl.minecraft.core.locale.LocaleManager;
import gg.modl.minecraft.core.service.ChatMessageCache;
import gg.modl.minecraft.core.sync.SyncService;
import gg.modl.minecraft.core.util.IpApiClient;
import gg.modl.minecraft.core.util.PunishmentMessages;
import gg.modl.minecraft.core.util.WebPlayer;
import gg.modl.minecraft.velocity.Colors;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.slf4j.Logger;

public class JoinListener {
    private final ModlHttpClient httpClient;
    private final Cache cache;
    private final Logger logger;
    private final ChatMessageCache chatMessageCache;
    private final Platform platform;
    private final SyncService syncService;
    private final String panelUrl;
    private final LocaleManager localeManager;

    @Subscribe
    public void onLogin(LoginEvent event) {
        String ipAddress = event.getPlayer().getRemoteAddress().getAddress().getHostAddress();
        JsonObject ipInfo = null;
        try {
            CompletableFuture<JsonObject> ipInfoFuture = IpApiClient.getIpInfo(ipAddress);
            ipInfo = ipInfoFuture.get(3L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            this.logger.warn("Failed to get IP info for {} within timeout: {}", (Object)ipAddress, (Object)e.getMessage());
        }
        String skinHash = null;
        try {
            WebPlayer webPlayer = WebPlayer.get(event.getPlayer().getUniqueId()).get(3L, TimeUnit.SECONDS);
            if (webPlayer != null && webPlayer.valid()) {
                skinHash = webPlayer.skin();
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to get skin hash for {}: {}", (Object)event.getPlayer().getUsername(), (Object)e.getMessage());
        }
        PlayerLoginRequest request = new PlayerLoginRequest(event.getPlayer().getUniqueId().toString(), event.getPlayer().getUsername(), ipAddress, skinHash, ipInfo, this.platform.getServerName());
        try {
            CompletableFuture<PlayerLoginResponse> loginFuture = this.httpClient.playerLogin(request);
            PlayerLoginResponse response = loginFuture.get(5L, TimeUnit.SECONDS);
            this.logger.info(String.format("Login response for %s: status=%d, punishments=%s", event.getPlayer().getUsername(), response.getStatus(), response.getActivePunishments()));
            if (response.getActivePunishments() != null) {
                for (SimplePunishment simplePunishment : response.getActivePunishments()) {
                    this.logger.info(String.format("Punishment: type='%s', isBan=%s, isMute=%s, started=%s, id=%s", simplePunishment.getType(), simplePunishment.isBan(), simplePunishment.isMute(), simplePunishment.isStarted(), simplePunishment.getId()));
                }
            }
            this.logger.info(String.format("Login response for %s: hasBan=%s, hasMute=%s", event.getPlayer().getUsername(), response.hasActiveBan(), response.hasActiveMute()));
            if (response.hasActiveBan()) {
                SimplePunishment ban = response.getActiveBan();
                String string = PunishmentMessages.formatBanMessage(ban, this.localeManager, PunishmentMessages.MessageContext.LOGIN);
                Component kickMessage = Colors.get(string);
                event.setResult(ResultedEvent.ComponentResult.denied((Component)kickMessage));
                this.logger.info(String.format("Denied login for %s due to active ban: %s", event.getPlayer().getUsername(), ban.getDescription()));
                if (!ban.isStarted()) {
                    this.acknowledgeBanEnforcement(ban, event.getPlayer().getUniqueId().toString());
                }
            } else {
                if (response.hasActiveMute()) {
                    SimplePunishment mute = response.getActiveMute();
                    this.cache.cacheMute(event.getPlayer().getUniqueId(), mute);
                    this.logger.info(String.format("Cached active mute for %s: %s", event.getPlayer().getUsername(), mute.getDescription()));
                }
                if (response.hasNotifications()) {
                    for (Map map : response.getPendingNotifications()) {
                        SyncResponse.PlayerNotification notification = this.mapToPlayerNotification(map);
                        if (notification == null) continue;
                        this.cache.cacheNotification(event.getPlayer().getUniqueId(), notification);
                    }
                }
                event.setResult(ResultedEvent.ComponentResult.allowed());
                this.logger.info(String.format("Allowed login for %s", event.getPlayer().getUsername()));
            }
        }
        catch (PanelUnavailableException e) {
            this.logger.warn(String.format("Panel 502 during login check for %s - blocking login for safety", event.getPlayer().getUsername()));
            Component errorMessage = Component.text((String)"Unable to verify ban status. Login temporarily restricted for safety.").color((TextColor)NamedTextColor.RED);
            event.setResult(ResultedEvent.ComponentResult.denied((Component)errorMessage));
        }
        catch (TimeoutException e) {
            this.logger.warn(String.format("Login check timed out for %s - blocking login for safety", event.getPlayer().getUsername()));
            Component errorMessage = Component.text((String)"Login verification timed out. Please try again.").color((TextColor)NamedTextColor.RED);
            event.setResult(ResultedEvent.ComponentResult.denied((Component)errorMessage));
        }
        catch (Exception e) {
            this.logger.error("Failed to check punishments for " + event.getPlayer().getUsername() + " - allowing login as fallback", (Throwable)e);
            event.setResult(ResultedEvent.ComponentResult.allowed());
        }
    }

    @Subscribe
    public void onPostLogin(PostLoginEvent event) {
        this.syncService.deliverPendingNotifications(event.getPlayer().getUniqueId());
    }

    @Subscribe
    public void onDisconnect(DisconnectEvent event) {
        PlayerDisconnectRequest request = new PlayerDisconnectRequest(event.getPlayer().getUniqueId().toString());
        this.httpClient.playerDisconnect(request);
        this.cache.removePlayer(event.getPlayer().getUniqueId());
        this.chatMessageCache.removePlayer(event.getPlayer().getUniqueId().toString());
    }

    public Cache getPunishmentCache() {
        return this.cache;
    }

    public ChatMessageCache getChatMessageCache() {
        return this.chatMessageCache;
    }

    private void acknowledgeBanEnforcement(SimplePunishment ban, String playerUuid) {
        try {
            PunishmentAcknowledgeRequest request = new PunishmentAcknowledgeRequest(ban.getId(), playerUuid, Instant.now().toString(), true, null);
            ((CompletableFuture)this.httpClient.acknowledgePunishment(request).thenAccept(response -> this.logger.info("Successfully acknowledged ban enforcement for punishment " + ban.getId()))).exceptionally(throwable -> {
                this.logger.error("Failed to acknowledge ban enforcement for punishment " + ban.getId(), throwable);
                return null;
            });
        }
        catch (Exception e) {
            this.logger.error("Error acknowledging ban enforcement for punishment " + ban.getId(), (Throwable)e);
        }
    }

    private SyncResponse.PlayerNotification mapToPlayerNotification(Map<String, Object> data) {
        try {
            SyncResponse.PlayerNotification notification = new SyncResponse.PlayerNotification();
            notification.setId((String)data.get("id"));
            notification.setMessage((String)data.get("message"));
            notification.setType((String)data.get("type"));
            if (data.get("timestamp") instanceof Number) {
                notification.setTimestamp(((Number)data.get("timestamp")).longValue());
            }
            notification.setTargetPlayerUuid((String)data.get("targetPlayerUuid"));
            Object nestedData = data.get("data");
            if (nestedData instanceof Map) {
                Map dataMap = (Map)nestedData;
                notification.setData(dataMap);
            }
            return notification;
        }
        catch (Exception e) {
            this.logger.warn("Failed to convert notification data: " + e.getMessage());
            return null;
        }
    }

    @Generated
    public JoinListener(ModlHttpClient httpClient, Cache cache, Logger logger, ChatMessageCache chatMessageCache, Platform platform, SyncService syncService, String panelUrl, LocaleManager localeManager) {
        this.httpClient = httpClient;
        this.cache = cache;
        this.logger = logger;
        this.chatMessageCache = chatMessageCache;
        this.platform = platform;
        this.syncService = syncService;
        this.panelUrl = panelUrl;
        this.localeManager = localeManager;
    }
}

